/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.progress;

import io.github.flemmli97.runecraftory.common.quests.tasks.TamingTask;
import io.github.flemmli97.simplequests_api.impls.progression.ProgressionTrackerBase;
import io.github.flemmli97.simplequests_api.player.ProgressionTrackerKey;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class TamingTracker
extends ProgressionTrackerBase<Entity, TamingTask.TamingTaskResolved> {
    public static final String TAMING_PROGRESS = String.valueOf(TamingTask.ID) + ".progress";
    public static final ProgressionTrackerKey<Entity, TamingTask.TamingTaskResolved> KEY = new ProgressionTrackerKey("runecraftory", "taming_tracker", TamingTask.ID);
    private final Set<UUID> entities = new HashSet<UUID>();

    public TamingTracker(TamingTask.TamingTaskResolved questEntry) {
        super((ResolvedQuestTask)questEntry);
    }

    public boolean progress(ServerPlayer player, QuestProgress prog, Entity with) {
        if (((EntityPredicate)((TamingTask.TamingTaskResolved)this.questEntry()).predicate().value()).matches(player, with)) {
            if (this.entities.contains(with.getUUID())) {
                return false;
            }
            this.entities.add(with.getUUID());
            return this.entities.size() >= ((TamingTask.TamingTaskResolved)this.questEntry()).amount();
        }
        return false;
    }

    public MutableComponent formattedProgress(ServerPlayer player, QuestProgress progress) {
        float perc = (float)this.entities.size() / (float)((TamingTask.TamingTaskResolved)this.questEntry()).amount();
        return Component.translatable((String)TAMING_PROGRESS, (Object[])new Object[]{this.entities.size(), ((TamingTask.TamingTaskResolved)this.questEntry()).amount()}).withStyle(ProgressionTrackerBase.of((float)perc));
    }

    public Tag save() {
        ListTag list = new ListTag();
        this.entities.forEach(uuid -> list.add((Object)NbtUtils.createUUID((UUID)uuid)));
        return list;
    }

    public void load(Tag tag) {
        try {
            ListTag list = (ListTag)tag;
            list.forEach(t -> this.entities.add(NbtUtils.loadUUID((Tag)t)));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }
}

