/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.quests.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.simplequests_api.SimpleQuestsAPI;
import io.github.flemmli97.simplequests_api.player.PlayerQuestData;
import io.github.flemmli97.simplequests_api.player.QuestProgress;
import io.github.flemmli97.simplequests_api.quest.QuestBase;
import io.github.flemmli97.simplequests_api.quest.entry.QuestEntryKey;
import io.github.flemmli97.simplequests_api.quest.entry.QuestTask;
import io.github.flemmli97.simplequests_api.quest.entry.ResolvedQuestTask;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LevelTask
implements QuestTask<LevelTaskResolved> {
    public static final QuestEntryKey<LevelTask> ID = new QuestEntryKey(RuneCraftory.modRes("level"));
    public static final MapCodec<LevelTask> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("description").forGetter(d -> d.description), (App)NumberProviders.CODEC.fieldOf("level").forGetter(d -> d.range)).apply((Applicative)instance, LevelTask::new));
    private final String description;
    private final NumberProvider range;

    public LevelTask(String description, NumberProvider range) {
        this.description = description;
        this.range = range;
        if (this.description.isEmpty() && !(this.range instanceof ConstantValue)) {
            throw new IllegalStateException("Description is required");
        }
    }

    public MutableComponent translation(ServerPlayer player) {
        if (this.description.isEmpty() && this.range instanceof ConstantValue) {
            return Component.translatable((String)this.getId().toString(), (Object[])new Object[]{this.range.getInt(null)});
        }
        return Component.translatable((String)this.description);
    }

    public QuestEntryKey<?> getId() {
        return ID;
    }

    public LevelTaskResolved resolve(PlayerQuestData data, QuestProgress progress, QuestBase base) {
        LootContext ctx = SimpleQuestsAPI.createContext((PlayerQuestData)data, (ResourceLocation)base.id);
        return new LevelTaskResolved(this.range.getInt(ctx));
    }

    public record LevelTaskResolved(int level) implements ResolvedQuestTask
    {
        public static final MapCodec<LevelTaskResolved> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("level").forGetter(d -> d.level)).apply((Applicative)instance, LevelTaskResolved::new));

        public boolean submit(ServerPlayer player) {
            return ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getPlayerLevel().getLevel() >= this.level;
        }

        public QuestEntryKey<LevelTask> getId() {
            return ID;
        }

        public MutableComponent translation(ServerPlayer player) {
            return Component.translatable((String)this.getId().toString(), (Object[])new Object[]{this.level});
        }
    }
}

