/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.recipes;

import com.google.common.base.Suppliers;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.inventory.PlayerBoundCraftingContainer;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.CraftingUtils;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SpecialSextupleRecipe
extends SextupleRecipe {
    public static final Supplier<RecipeHolder<SpecialSextupleRecipe>> SCRAP = Suppliers.memoize(() -> new RecipeHolder(RuneCraftory.modRes("scrap_metal"), (Recipe)new SpecialSextupleRecipe(new ItemStack((ItemLike)RuneCraftoryItems.SCRAP.get()), new AlternateResult(new ItemStack((ItemLike)RuneCraftoryItems.SCRAP_PLUS.get()), 0.1f))));
    public static final Supplier<RecipeHolder<SpecialSextupleRecipe>> OBJECT_X = Suppliers.memoize(() -> new RecipeHolder(RuneCraftory.modRes("object_x"), (Recipe)new SpecialSextupleRecipe(new ItemStack((ItemLike)RuneCraftoryItems.OBJECT_X.get()), null)));
    public static final Supplier<RecipeHolder<SpecialSextupleRecipe>> FAILED_DISH = Suppliers.memoize(() -> new RecipeHolder(RuneCraftory.modRes("failed_dish"), (Recipe)new SpecialSextupleRecipe(new ItemStack((ItemLike)RuneCraftoryItems.FAILED_DISH.get()), new AlternateResult(new ItemStack((ItemLike)RuneCraftoryItems.DISASTROUS_DISH.get()), 0.1f))));
    private final AlternateResult alternateResult;

    private SpecialSextupleRecipe(ItemStack result, AlternateResult alternateResult) {
        super("", 1, 10, result, (NonNullList<Ingredient>)NonNullList.create());
        this.alternateResult = alternateResult;
    }

    @Override
    public boolean matches(PlayerBoundCraftingContainer inv, Level level) {
        return !inv.isEmpty();
    }

    @Override
    public SextupleRecipe.RecipeOutput createOutput(PlayerBoundCraftingContainer inv, boolean unlocked) {
        if (inv.isEmpty()) {
            return null;
        }
        CraftingUtils.RAND.setSeed(((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)inv.getPlayer())).getCraftingSeed(inv.getPlayer()));
        ItemStack res = this.alternateResult != null && CraftingUtils.RAND.nextFloat() < this.alternateResult.chance() ? this.alternateResult.stack().copy() : this.getResultItem((HolderLookup.Provider)inv.getPlayer().registryAccess());
        return new SextupleRecipe.RecipeOutput(res, new ItemStack((ItemLike)RuneCraftoryItems.UNKNOWN.get()), (NonNullList<ItemStack>)NonNullList.create());
    }

    public ItemStack getToastSymbol() {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return null;
    }

    public RecipeType<?> getType() {
        return null;
    }

    private record AlternateResult(ItemStack stack, float chance) {
    }
}

