/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import io.github.flemmli97.runecraftory.common.blocks.AccessoryBlock;
import io.github.flemmli97.runecraftory.common.blocks.BossSpawnerBlock;
import io.github.flemmli97.runecraftory.common.blocks.BrokenMineralBlock;
import io.github.flemmli97.runecraftory.common.blocks.CashRegisterBlock;
import io.github.flemmli97.runecraftory.common.blocks.ChemistryBlock;
import io.github.flemmli97.runecraftory.common.blocks.CookingBlock;
import io.github.flemmli97.runecraftory.common.blocks.ExtendedCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.ForgeBlock;
import io.github.flemmli97.runecraftory.common.blocks.GiantCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.HerbBlock;
import io.github.flemmli97.runecraftory.common.blocks.MineralBlock;
import io.github.flemmli97.runecraftory.common.blocks.MonsterBarnBlock;
import io.github.flemmli97.runecraftory.common.blocks.QuestboardBlock;
import io.github.flemmli97.runecraftory.common.blocks.ShippingBinBlock;
import io.github.flemmli97.runecraftory.common.blocks.SingleTimeSpawnerBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeFruitLeavesBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeLeavesBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeLogBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeRootBlock;
import io.github.flemmli97.runecraftory.common.blocks.TreeSaplingBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.AccessoryBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.BossSpawnerBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.BrokenMineralBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.ChemistryBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.CookingBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.ForgingBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.MonsterBarnBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.SingleTimeSpawner;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeLogBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.util.MineralBlockTier;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFeatures;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryFluids;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.tenshilib.loader.LoaderRegistryAccess;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import io.github.flemmli97.tenshilib.loader.registry.LoaderRegister;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class RuneCraftoryBlocks {
    public static final LoaderRegister<Block> BLOCKS = LoaderRegistryAccess.INSTANCE.of(Registries.BLOCK, "runecraftory");
    public static final LoaderRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = LoaderRegistryAccess.INSTANCE.of(Registries.BLOCK_ENTITY_TYPE, "runecraftory");
    public static final Map<RegistryEntrySupplier<Block, ?>, RunecraftoryTags.Biomes.BiomeGenerationTags> GENERATION_TAGS = new HashMap();
    public static final List<RegistryEntrySupplier<Block, ?>> CROPS = new ArrayList();
    public static final List<RegistryEntrySupplier<Block, ?>> FLOWERS = new ArrayList();
    public static final List<RegistryEntrySupplier<Block, ?>> HERBS = new ArrayList();
    public static final Map<RegistryEntrySupplier<Block, ?>, RegistryEntrySupplier<Block, ?>> GIANT_CROP_MAP = new HashMap();
    public static final EnumMap<MineralBlockTier, RegistryEntrySupplier<Block, ?>> MINERAL_MAP = new EnumMap(MineralBlockTier.class);
    public static final EnumMap<MineralBlockTier, RegistryEntrySupplier<Block, ?>> BROKEN_MINERAL_MAP = new EnumMap(MineralBlockTier.class);
    public static final RegistryEntrySupplier<Block, ForgeBlock> FORGE = BLOCKS.register("forge", () -> new ForgeBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).noOcclusion().strength(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block, AccessoryBlock> ACCESSORY_WORKBENCH = BLOCKS.register("accessory_workbench", () -> new AccessoryBlock(BlockBehaviour.Properties.of().noOcclusion().strength(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block, ChemistryBlock> CHEMISTRY_SET = BLOCKS.register("chemistry_set", () -> new ChemistryBlock(BlockBehaviour.Properties.of().noOcclusion().strength(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block, CookingBlock> COOKING_TABLE = BLOCKS.register("cooking_table", () -> new CookingBlock(BlockBehaviour.Properties.of().noOcclusion().strength(3.0f, 100.0f)));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_IRON = RuneCraftoryBlocks.mineral(MineralBlockTier.IRON, List.of(BiomeTags.IS_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_TIN = RuneCraftoryBlocks.mineral(MineralBlockTier.TIN, List.of(BiomeTags.IS_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_SILVER = RuneCraftoryBlocks.mineral(MineralBlockTier.SILVER, List.of(BiomeTags.IS_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_GOLD = RuneCraftoryBlocks.mineral(MineralBlockTier.GOLD, List.of(BiomeTags.IS_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_PLATINUM = RuneCraftoryBlocks.mineral(MineralBlockTier.PLATINUM, List.of(BiomeTags.IS_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_ORICHALCUM = RuneCraftoryBlocks.mineral(MineralBlockTier.ORICHALCUM, List.of(BiomeTags.IS_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_DIAMOND = RuneCraftoryBlocks.mineral(MineralBlockTier.DIAMOND, List.of(BiomeTags.IS_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_DRAGONIC = RuneCraftoryBlocks.mineral(MineralBlockTier.DRAGONIC, List.of(BiomeTags.IS_END), List.of());
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_AQUAMARINE = RuneCraftoryBlocks.mineral(MineralBlockTier.AQUAMARINE, List.of(RunecraftoryTags.Biomes.IS_AQUATIC, BiomeTags.IS_BEACH, RunecraftoryTags.Biomes.IS_WET), List.of(BiomeTags.IS_NETHER, BiomeTags.IS_END));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_AMETHYST = RuneCraftoryBlocks.mineral(MineralBlockTier.AMETHYST, List.of(BiomeTags.IS_FOREST, BiomeTags.IS_MOUNTAIN, RunecraftoryTags.Biomes.IS_DEAD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_RUBY = RuneCraftoryBlocks.mineral(MineralBlockTier.RUBY, List.of(RunecraftoryTags.Biomes.IS_HOT, BiomeTags.IS_NETHER), List.of());
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_EMERALD = RuneCraftoryBlocks.mineral(MineralBlockTier.EMERALD, List.of(RunecraftoryTags.Biomes.IS_PLAINS, RunecraftoryTags.Biomes.IS_WASTELAND, RunecraftoryTags.Biomes.IS_SPARSE_VEGETATION_OVERWORLD, BiomeTags.IS_HILL), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, MineralBlock> MINERAL_SAPPHIRE = RuneCraftoryBlocks.mineral(MineralBlockTier.SAPPHIRE, List.of(RunecraftoryTags.Biomes.IS_MAGICAL, RunecraftoryTags.Biomes.IS_SNOWY), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST));
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_IRON = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.IRON);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_TIN = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.TIN);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_SILVER = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.SILVER);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_GOLD = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.GOLD);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_PLATINUM = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.PLATINUM);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_ORICHALCUM = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.ORICHALCUM);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_DIAMOND = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.DIAMOND);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_DRAGONIC = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.DRAGONIC);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_AQUAMARINE = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.AQUAMARINE);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_AMETHYST = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.AMETHYST);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_RUBY = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.RUBY);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_EMERALD = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.EMERALD);
    public static final RegistryEntrySupplier<Block, BrokenMineralBlock> BROKEN_MINERAL_SAPPHIRE = RuneCraftoryBlocks.brokenMineral(MineralBlockTier.SAPPHIRE);
    public static final RegistryEntrySupplier<Block, BossSpawnerBlock> BOSS_SPAWNER = BLOCKS.register("boss_spawner", () -> new BossSpawnerBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).instrument(NoteBlockInstrument.BASEDRUM).strength(60.0f, 9999.0f).noOcclusion()));
    public static final RegistryEntrySupplier<Block, ShippingBinBlock> SHIPPING = BLOCKS.register("shipping_bin", () -> new ShippingBinBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).instrument(NoteBlockInstrument.XYLOPHONE).strength(3.0f, 10.0f)));
    public static final RegistryEntrySupplier<Block, SingleTimeSpawnerBlock> SINGLE_SPAWN_BLOCK = BLOCKS.register("one_time_spawner", () -> new SingleTimeSpawnerBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).instrument(NoteBlockInstrument.BASEDRUM).strength(60.0f, 9999.0f).noOcclusion()));
    public static final RegistryEntrySupplier<Block, CashRegisterBlock> CASH_REGISTER = BLOCKS.register("cash_register", () -> new CashRegisterBlock(BlockBehaviour.Properties.of().sound(SoundType.TUFF).requiresCorrectToolForDrops().strength(3.0f, 5.0f)));
    public static final RegistryEntrySupplier<Block, MonsterBarnBlock> MONSTER_BARN = BLOCKS.register("monster_barn", () -> new MonsterBarnBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).noOcclusion().noCollission().strength(1.0f, 10000.0f)));
    public static final RegistryEntrySupplier<Block, QuestboardBlock> QUEST_BOARD = BLOCKS.register("quest_board", () -> new QuestboardBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).noOcclusion().strength(2.0f, 5.0f)));
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> TURNIP = RuneCraftoryBlocks.crop("turnip", () -> RuneCraftoryItems.TURNIP.getKey(), () -> RuneCraftoryItems.TURNIP_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> TURNIP_PINK = RuneCraftoryBlocks.crop("turnip_pink", () -> RuneCraftoryItems.TURNIP_PINK.getKey(), () -> RuneCraftoryItems.TURNIP_PINK_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> CABBAGE = RuneCraftoryBlocks.crop("cabbage", () -> RuneCraftoryItems.CABBAGE.getKey(), () -> RuneCraftoryItems.CABBAGE_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> PINK_MELON = RuneCraftoryBlocks.crop("pink_melon", () -> RuneCraftoryItems.PINK_MELON.getKey(), () -> RuneCraftoryItems.PINK_MELON_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> PINEAPPLE = RuneCraftoryBlocks.crop("pineapple", () -> RuneCraftoryItems.PINEAPPLE.getKey(), () -> RuneCraftoryItems.PINEAPPLE_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> STRAWBERRY = RuneCraftoryBlocks.crop("strawberry", () -> RuneCraftoryItems.STRAWBERRY.getKey(), () -> RuneCraftoryItems.STRAWBERRY_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> GOLDEN_TURNIP = RuneCraftoryBlocks.crop("golden_turnip", () -> RuneCraftoryItems.GOLDEN_TURNIP.getKey(), () -> RuneCraftoryItems.GOLDEN_TURNIP_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> GOLDEN_POTATO = RuneCraftoryBlocks.crop("golden_potato", () -> RuneCraftoryItems.GOLDEN_POTATO.getKey(), () -> RuneCraftoryItems.GOLDEN_POTATO_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> GOLDEN_PUMPKIN = RuneCraftoryBlocks.crop("golden_pumpkin", () -> RuneCraftoryItems.GOLDEN_PUMPKIN.getKey(), () -> RuneCraftoryItems.GOLDEN_PUMPKIN_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> GOLDEN_CABBAGE = RuneCraftoryBlocks.crop("golden_cabbage", () -> RuneCraftoryItems.GOLDEN_CABBAGE.getKey(), () -> RuneCraftoryItems.GOLDEN_CABBAGE_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> HOT_HOT_FRUIT = RuneCraftoryBlocks.crop("hot_hot_fruit", () -> RuneCraftoryItems.HOT_HOT_FRUIT.getKey(), () -> RuneCraftoryItems.HOT_HOT_FRUIT_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> NAPA_CABBAGE = RuneCraftoryBlocks.crop("napa_cabbage", () -> RuneCraftoryItems.NAPA_CABBAGE.getKey(), () -> RuneCraftoryItems.NAPA_CABBAGE_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> LEEK = RuneCraftoryBlocks.crop("leek", () -> RuneCraftoryItems.LEEK.getKey(), () -> RuneCraftoryItems.LEEK_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> RADISH = RuneCraftoryBlocks.crop("radish", () -> RuneCraftoryItems.RADISH.getKey(), () -> RuneCraftoryItems.RADISH_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> SPINACH = RuneCraftoryBlocks.crop("spinach", () -> RuneCraftoryItems.SPINACH.getKey(), () -> RuneCraftoryItems.SPINACH_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> GREEN_PEPPER = RuneCraftoryBlocks.crop("green_pepper", () -> RuneCraftoryItems.GREEN_PEPPER.getKey(), () -> RuneCraftoryItems.GREEN_PEPPER_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> YAM = RuneCraftoryBlocks.crop("yam", () -> RuneCraftoryItems.YAM.getKey(), () -> RuneCraftoryItems.YAM_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> EGGPLANT = RuneCraftoryBlocks.crop("eggplant", () -> RuneCraftoryItems.EGGPLANT.getKey(), () -> RuneCraftoryItems.EGGPLANT_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> TOMATO = RuneCraftoryBlocks.crop("tomato", () -> RuneCraftoryItems.TOMATO.getKey(), () -> RuneCraftoryItems.TOMATO_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> CORN = RuneCraftoryBlocks.crop("corn", () -> RuneCraftoryItems.CORN.getKey(), () -> RuneCraftoryItems.CORN_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> CUCUMBER = RuneCraftoryBlocks.crop("cucumber", () -> RuneCraftoryItems.CUCUMBER.getKey(), () -> RuneCraftoryItems.CUCUMBER_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> PUMPKIN = RuneCraftoryBlocks.crop("pumpkin", () -> RuneCraftoryItems.PUMPKIN.getKey(), () -> RuneCraftoryItems.PUMPKIN_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> ONION = RuneCraftoryBlocks.crop("onion", () -> RuneCraftoryItems.ONION.getKey(), () -> RuneCraftoryItems.ONION_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, GiantCropBlock> TURNIP_GIANT = RuneCraftoryBlocks.giantCrop("tyrant_turnip", () -> RuneCraftoryItems.TURNIP_GIANT.getKey(), () -> RuneCraftoryItems.TURNIP_SEEDS.getKey(), TURNIP);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> TURNIP_PINK_GIANT = RuneCraftoryBlocks.giantCrop("colossal_pink", () -> RuneCraftoryItems.TURNIP_PINK_GIANT.getKey(), () -> RuneCraftoryItems.TURNIP_PINK_SEEDS.getKey(), TURNIP_PINK);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> CABBAGE_GIANT = RuneCraftoryBlocks.giantCrop("king_cabbage", () -> RuneCraftoryItems.CABBAGE_GIANT.getKey(), () -> RuneCraftoryItems.CABBAGE_SEEDS.getKey(), CABBAGE);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> PINK_MELON_GIANT = RuneCraftoryBlocks.giantCrop("conqueror_melon", () -> RuneCraftoryItems.PINK_MELON_GIANT.getKey(), () -> RuneCraftoryItems.PINK_MELON_SEEDS.getKey(), PINK_MELON);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> PINEAPPLE_GIANT = RuneCraftoryBlocks.giantCrop("king_pineapple", () -> RuneCraftoryItems.PINEAPPLE_GIANT.getKey(), () -> RuneCraftoryItems.PINEAPPLE_SEEDS.getKey(), PINEAPPLE);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> STRAWBERRY_GIANT = RuneCraftoryBlocks.giantCrop("sultan_strawberry", () -> RuneCraftoryItems.STRAWBERRY_GIANT.getKey(), () -> RuneCraftoryItems.STRAWBERRY_SEEDS.getKey(), STRAWBERRY);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> GOLDEN_TURNIP_GIANT = RuneCraftoryBlocks.giantCrop("golden_tyrant_turnip", () -> RuneCraftoryItems.GOLDEN_TURNIP_GIANT.getKey(), () -> RuneCraftoryItems.GOLDEN_TURNIP_SEEDS.getKey(), GOLDEN_TURNIP);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> GOLDEN_POTATO_GIANT = RuneCraftoryBlocks.giantCrop("gold_prince_potato", () -> RuneCraftoryItems.GOLDEN_POTATO_GIANT.getKey(), () -> RuneCraftoryItems.GOLDEN_POTATO_SEEDS.getKey(), GOLDEN_POTATO);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> GOLDEN_PUMPKIN_GIANT = RuneCraftoryBlocks.giantCrop("golden_doom_pumpkin", () -> RuneCraftoryItems.GOLDEN_PUMPKIN_GIANT.getKey(), () -> RuneCraftoryItems.GOLDEN_PUMPKIN_SEEDS.getKey(), GOLDEN_PUMPKIN);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> GOLDEN_CABBAGE_GIANT = RuneCraftoryBlocks.giantCrop("golden_king_cabbage", () -> RuneCraftoryItems.GOLDEN_CABBAGE_GIANT.getKey(), () -> RuneCraftoryItems.GOLDEN_CABBAGE_SEEDS.getKey(), GOLDEN_CABBAGE);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> HOT_HOT_FRUIT_GIANT = RuneCraftoryBlocks.giantCrop("giant_hot_hot_fruit", () -> RuneCraftoryItems.HOT_HOT_FRUIT_GIANT.getKey(), () -> RuneCraftoryItems.HOT_HOT_FRUIT_SEEDS.getKey(), HOT_HOT_FRUIT);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> NAPA_CABBAGE_GIANT = RuneCraftoryBlocks.giantCrop("napa_cabbage_chief", () -> RuneCraftoryItems.NAPA_CABBAGE_GIANT.getKey(), () -> RuneCraftoryItems.NAPA_CABBAGE_SEEDS.getKey(), NAPA_CABBAGE);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> LEEK_GIANT = RuneCraftoryBlocks.giantCrop("legendary_leek", () -> RuneCraftoryItems.LEEK_GIANT.getKey(), () -> RuneCraftoryItems.LEEK_SEEDS.getKey(), LEEK);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> RADISH_GIANT = RuneCraftoryBlocks.giantCrop("noble_radish", () -> RuneCraftoryItems.RADISH_GIANT.getKey(), () -> RuneCraftoryItems.RADISH_SEEDS.getKey(), RADISH);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> SPINACH_GIANT = RuneCraftoryBlocks.giantCrop("sovereign_spinach", () -> RuneCraftoryItems.SPINACH_GIANT.getKey(), () -> RuneCraftoryItems.SPINACH_SEEDS.getKey(), SPINACH);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> GREEN_PEPPER_GIANT = RuneCraftoryBlocks.giantCrop("green_pepper_rex", () -> RuneCraftoryItems.GREEN_PEPPER_GIANT.getKey(), () -> RuneCraftoryItems.GREEN_PEPPER_SEEDS.getKey(), GREEN_PEPPER);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> YAM_GIANT = RuneCraftoryBlocks.giantCrop("lorldy_yam", () -> RuneCraftoryItems.YAM_GIANT.getKey(), () -> RuneCraftoryItems.YAM_SEEDS.getKey(), YAM);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> EGGPLANT_GIANT = RuneCraftoryBlocks.giantCrop("emperor_eggplant", () -> RuneCraftoryItems.EGGPLANT_GIANT.getKey(), () -> RuneCraftoryItems.EGGPLANT_SEEDS.getKey(), EGGPLANT);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> TOMATO_GIANT = RuneCraftoryBlocks.giantCrop("titan_tomato", () -> RuneCraftoryItems.TOMATO_GIANT.getKey(), () -> RuneCraftoryItems.TOMATO_SEEDS.getKey(), TOMATO);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> CORN_GIANT = RuneCraftoryBlocks.giantCrop("gigant_corn", () -> RuneCraftoryItems.CORN_GIANT.getKey(), () -> RuneCraftoryItems.CORN_SEEDS.getKey(), CORN);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> CUCUMBER_GIANT = RuneCraftoryBlocks.giantCrop("kaiser_cucumber", () -> RuneCraftoryItems.CUCUMBER_GIANT.getKey(), () -> RuneCraftoryItems.CUCUMBER_SEEDS.getKey(), CUCUMBER);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> PUMPKIN_GIANT = RuneCraftoryBlocks.giantCrop("doom_pumpkin", () -> RuneCraftoryItems.PUMPKIN_GIANT.getKey(), () -> RuneCraftoryItems.PUMPKIN_SEEDS.getKey(), PUMPKIN);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> ONION_GIANT = RuneCraftoryBlocks.giantCrop("ultra_onion", () -> RuneCraftoryItems.ONION_GIANT.getKey(), () -> RuneCraftoryItems.ONION_SEEDS.getKey(), ONION);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> POTATO_GIANT = RuneCraftoryBlocks.giantCrop("princely_potato", () -> RuneCraftoryItems.POTATO_GIANT.getKey(), () -> RuneCraftoryBlocks.ofVanilla(Items.POTATO));
    public static final RegistryEntrySupplier<Block, GiantCropBlock> CARROT_GIANT = RuneCraftoryBlocks.giantCrop("royal_carrot", () -> RuneCraftoryItems.CARROT_GIANT.getKey(), () -> RuneCraftoryBlocks.ofVanilla(Items.CARROT));
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> TOYHERB = RuneCraftoryBlocks.flower("toyherb", () -> RuneCraftoryItems.TOYHERB.getKey(), () -> RuneCraftoryItems.TOYHERB_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> MOONDROP_FLOWER = RuneCraftoryBlocks.flower("moondrop_flower", () -> RuneCraftoryItems.MOONDROP_FLOWER.getKey(), () -> RuneCraftoryItems.MOONDROP_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> PINK_CAT = RuneCraftoryBlocks.flower("pink_cat", () -> RuneCraftoryItems.PINK_CAT.getKey(), () -> RuneCraftoryItems.PINK_CAT_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> CHARM_BLUE = RuneCraftoryBlocks.flower("charm_blue", () -> RuneCraftoryItems.CHARM_BLUE.getKey(), () -> RuneCraftoryItems.CHARM_BLUE_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> LAMP_GRASS = RuneCraftoryBlocks.flower("lamp_grass", () -> RuneCraftoryItems.LAMP_GRASS.getKey(), () -> RuneCraftoryItems.LAMP_GRASS_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> CHERRY_GRASS = RuneCraftoryBlocks.flower("cherry_grass", () -> RuneCraftoryItems.CHERRY_GRASS.getKey(), () -> RuneCraftoryItems.CHERRY_GRASS_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> POM_POM_GRASS = RuneCraftoryBlocks.flower("pom_pom_grass", () -> RuneCraftoryItems.POM_POM_GRASS.getKey(), () -> RuneCraftoryItems.POM_POM_GRASS_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> AUTUMN_GRASS = RuneCraftoryBlocks.flower("autumn_grass", () -> RuneCraftoryItems.AUTUMN_GRASS.getKey(), () -> RuneCraftoryItems.AUTUMN_GRASS_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> NOEL_GRASS = RuneCraftoryBlocks.flower("noel_grass", () -> RuneCraftoryItems.NOEL_GRASS.getKey(), () -> RuneCraftoryItems.NOEL_GRASS_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> FIREFLOWER = RuneCraftoryBlocks.flower("fireflower", () -> RuneCraftoryItems.FIREFLOWER.getKey(), () -> RuneCraftoryItems.FIREFLOWER_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> FOUR_LEAF_CLOVER = RuneCraftoryBlocks.flower("four_leaf_clover", () -> RuneCraftoryItems.FOUR_LEAF_CLOVER.getKey(), () -> RuneCraftoryItems.FOUR_LEAF_CLOVER_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> IRONLEAF = RuneCraftoryBlocks.flower("ironleaf", () -> RuneCraftoryItems.IRONLEAF.getKey(), () -> RuneCraftoryItems.IRONLEAF_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> WHITE_CRYSTAL = RuneCraftoryBlocks.flower("white_crystal", () -> RuneCraftoryItems.WHITE_CRYSTAL.getKey(), () -> RuneCraftoryItems.WHITE_CRYSTAL_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> RED_CRYSTAL = RuneCraftoryBlocks.flower("red_crystal", () -> RuneCraftoryItems.RED_CRYSTAL.getKey(), () -> RuneCraftoryItems.RED_CRYSTAL_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> GREEN_CRYSTAL = RuneCraftoryBlocks.flower("green_crystal", () -> RuneCraftoryItems.GREEN_CRYSTAL.getKey(), () -> RuneCraftoryItems.GREEN_CRYSTAL_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> BLUE_CRYSTAL = RuneCraftoryBlocks.flower("blue_crystal", () -> RuneCraftoryItems.BLUE_CRYSTAL.getKey(), () -> RuneCraftoryItems.BLUE_CRYSTAL_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> EMERY_FLOWER = RuneCraftoryBlocks.flower("emery_flower", () -> RuneCraftoryItems.EMERY_FLOWER.getKey(), () -> RuneCraftoryItems.EMERY_FLOWER_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, GiantCropBlock> TOYHERB_GIANT = RuneCraftoryBlocks.giantFlower("ultra_toyherb", () -> RuneCraftoryItems.TOYHERB_GIANT.getKey(), () -> RuneCraftoryItems.TOYHERB_SEEDS.getKey(), TOYHERB);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> MOONDROP_FLOWER_GIANT = RuneCraftoryBlocks.giantFlower("ultra_moondrop_flower", () -> RuneCraftoryItems.MOONDROP_FLOWER_GIANT.getKey(), () -> RuneCraftoryItems.MOONDROP_SEEDS.getKey(), MOONDROP_FLOWER);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> PINK_CAT_GIANT = RuneCraftoryBlocks.giantFlower("king_pink_cat", () -> RuneCraftoryItems.PINK_CAT_GIANT.getKey(), () -> RuneCraftoryItems.PINK_CAT_SEEDS.getKey(), PINK_CAT);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> CHARM_BLUE_GIANT = RuneCraftoryBlocks.giantFlower("great_charm_blue", () -> RuneCraftoryItems.CHARM_BLUE_GIANT.getKey(), () -> RuneCraftoryItems.CHARM_BLUE_SEEDS.getKey(), CHARM_BLUE);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> LAMP_GRASS_GIANT = RuneCraftoryBlocks.giantFlower("kaiser_lamp_grass", () -> RuneCraftoryItems.LAMP_GRASS_GIANT.getKey(), () -> RuneCraftoryItems.LAMP_GRASS_SEEDS.getKey(), LAMP_GRASS);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> CHERRY_GRASS_GIANT = RuneCraftoryBlocks.giantFlower("king_cherry_grass", () -> RuneCraftoryItems.CHERRY_GRASS_GIANT.getKey(), () -> RuneCraftoryItems.CHERRY_GRASS_SEEDS.getKey(), CHERRY_GRASS);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> POM_POM_GRASS_GIANT = RuneCraftoryBlocks.giantFlower("king_pom_pom_grass", () -> RuneCraftoryItems.POM_POM_GRASS_GIANT.getKey(), () -> RuneCraftoryItems.POM_POM_GRASS_SEEDS.getKey(), POM_POM_GRASS);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> AUTUMN_GRASS_GIANT = RuneCraftoryBlocks.giantFlower("big_autumn_grass", () -> RuneCraftoryItems.AUTUMN_GRASS_GIANT.getKey(), () -> RuneCraftoryItems.AUTUMN_GRASS_SEEDS.getKey(), AUTUMN_GRASS);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> NOEL_GRASS_GIANT = RuneCraftoryBlocks.giantFlower("large_noel_grass", () -> RuneCraftoryItems.NOEL_GRASS_GIANT.getKey(), () -> RuneCraftoryItems.NOEL_GRASS_SEEDS.getKey(), NOEL_GRASS);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> FIREFLOWER_GIANT = RuneCraftoryBlocks.giantFlower("big_fireflower", () -> RuneCraftoryItems.FIREFLOWER_GIANT.getKey(), () -> RuneCraftoryItems.FIREFLOWER_SEEDS.getKey(), FIREFLOWER);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> FOUR_LEAF_CLOVER_GIANT = RuneCraftoryBlocks.giantFlower("great_four_leaf_clover", () -> RuneCraftoryItems.FOUR_LEAF_CLOVER_GIANT.getKey(), () -> RuneCraftoryItems.FOUR_LEAF_CLOVER_SEEDS.getKey(), FOUR_LEAF_CLOVER);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> IRONLEAF_GIANT = RuneCraftoryBlocks.giantFlower("super_ironleaf", () -> RuneCraftoryItems.IRONLEAF_GIANT.getKey(), () -> RuneCraftoryItems.IRONLEAF_SEEDS.getKey(), IRONLEAF);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> WHITE_CRYSTAL_GIANT = RuneCraftoryBlocks.giantFlower("big_white_crystal", () -> RuneCraftoryItems.WHITE_CRYSTAL_GIANT.getKey(), () -> RuneCraftoryItems.WHITE_CRYSTAL_SEEDS.getKey(), WHITE_CRYSTAL);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> RED_CRYSTAL_GIANT = RuneCraftoryBlocks.giantFlower("big_red_crystal", () -> RuneCraftoryItems.RED_CRYSTAL_GIANT.getKey(), () -> RuneCraftoryItems.RED_CRYSTAL_SEEDS.getKey(), RED_CRYSTAL);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> GREEN_CRYSTAL_GIANT = RuneCraftoryBlocks.giantFlower("big_green_crystal", () -> RuneCraftoryItems.GREEN_CRYSTAL_GIANT.getKey(), () -> RuneCraftoryItems.GREEN_CRYSTAL_SEEDS.getKey(), GREEN_CRYSTAL);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> BLUE_CRYSTAL_GIANT = RuneCraftoryBlocks.giantFlower("big_blue_crystal", () -> RuneCraftoryItems.BLUE_CRYSTAL_GIANT.getKey(), () -> RuneCraftoryItems.BLUE_CRYSTAL_SEEDS.getKey(), BLUE_CRYSTAL);
    public static final RegistryEntrySupplier<Block, GiantCropBlock> EMERY_FLOWER_GIANT = RuneCraftoryBlocks.giantFlower("great_emery_flower", () -> RuneCraftoryItems.EMERY_FLOWER_GIANT.getKey(), () -> RuneCraftoryItems.EMERY_FLOWER_SEEDS.getKey(), EMERY_FLOWER);
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> SHIELD_CROP = RuneCraftoryBlocks.flower("shield_flower", () -> RuneCraftoryItems.PLANT_SHIELD.getKey(), () -> RuneCraftoryItems.SHIELD_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> SWORD_CROP = RuneCraftoryBlocks.flower("sword_flower", () -> RuneCraftoryItems.PLANT_SWORD.getKey(), () -> RuneCraftoryItems.SWORD_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, ExtendedCropBlock> DUNGEON = RuneCraftoryBlocks.flower("dungeon_flower", () -> RuneCraftoryBlocks.ofVanilla(Items.STONE), () -> RuneCraftoryItems.DUNGEON_SEEDS.getKey());
    public static final RegistryEntrySupplier<Block, HerbBlock> WEEDS = RuneCraftoryBlocks.herb("weeds", List.of(RunecraftoryTags.Biomes.VANILLA_DIMENSIONS), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> WITHERED_GRASS = RuneCraftoryBlocks.herb("withered_grass", List.of(RunecraftoryTags.Biomes.VANILLA_DIMENSIONS), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), HerbBlock.GroundTypes.SANDY);
    public static final RegistryEntrySupplier<Block, HerbBlock> WHITE_GRASS = RuneCraftoryBlocks.herb("white_grass", List.of(RunecraftoryTags.Biomes.IS_SNOWY), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> INDIGO_GRASS = RuneCraftoryBlocks.herb("indigo_grass", List.of(RunecraftoryTags.Biomes.IS_WET, RunecraftoryTags.Biomes.IS_MAGICAL, RunecraftoryTags.Biomes.IS_LUSH), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> PURPLE_GRASS = RuneCraftoryBlocks.herb("purple_grass", List.of(RunecraftoryTags.Biomes.IS_WET, RunecraftoryTags.Biomes.IS_MAGICAL), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> GREEN_GRASS = RuneCraftoryBlocks.herb("green_grass", List.of(RunecraftoryTags.Biomes.GENERAL_HERBS), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> BLUE_GRASS = RuneCraftoryBlocks.herb("blue_grass", List.of(BiomeTags.IS_BEACH, RunecraftoryTags.Biomes.IS_MAGICAL, BiomeTags.IS_RIVER, RunecraftoryTags.Biomes.IS_SWAMP), List.of(BiomeTags.IS_NETHER, BiomeTags.IS_END), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> YELLOW_GRASS = RuneCraftoryBlocks.herb("yellow_grass", List.of(RunecraftoryTags.Biomes.IS_DRY_OVERWORLD, RunecraftoryTags.Biomes.IS_SANDY, BiomeTags.IS_NETHER), List.of(RunecraftoryTags.Biomes.IS_AQUATIC, BiomeTags.IS_END), HerbBlock.GroundTypes.SANDY, HerbBlock.GroundTypes.NETHER);
    public static final RegistryEntrySupplier<Block, HerbBlock> RED_GRASS = RuneCraftoryBlocks.herb("red_grass", List.of(BiomeTags.IS_NETHER), List.of(), HerbBlock.GroundTypes.NETHER);
    public static final RegistryEntrySupplier<Block, HerbBlock> ORANGE_GRASS = RuneCraftoryBlocks.herb("orange_grass", List.of(BiomeTags.IS_NETHER, RunecraftoryTags.Biomes.IS_HOT, BiomeTags.IS_SAVANNA), List.of(RunecraftoryTags.Biomes.IS_AQUATIC, BiomeTags.IS_END), HerbBlock.GroundTypes.SANDY, HerbBlock.GroundTypes.NETHER);
    public static final RegistryEntrySupplier<Block, HerbBlock> BLACK_GRASS = RuneCraftoryBlocks.herb("black_grass", List.of(BiomeTags.IS_END), List.of(), HerbBlock.GroundTypes.END);
    public static final RegistryEntrySupplier<Block, HerbBlock> ANTIDOTE_GRASS = RuneCraftoryBlocks.herb("antidote_grass", List.of(RunecraftoryTags.Biomes.GENERAL_HERBS), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> MEDICINAL_HERB = RuneCraftoryBlocks.herb("medicinal_herb", List.of(RunecraftoryTags.Biomes.GENERAL_HERBS), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> MUSHROOM = RuneCraftoryBlocks.herb("mushroom", List.of(BiomeTags.IS_FOREST, RunecraftoryTags.Biomes.IS_MUSHROOM, RunecraftoryTags.Biomes.IS_MAGICAL), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> MONARCH_MUSHROOM = RuneCraftoryBlocks.herb("monarch_mushroom", List.of(BiomeTags.IS_FOREST, RunecraftoryTags.Biomes.IS_MUSHROOM, RunecraftoryTags.Biomes.IS_MAGICAL), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, HerbBlock> ELLI_LEAVES = RuneCraftoryBlocks.herb("elli_leaves", List.of(BiomeTags.IS_END), List.of(), HerbBlock.GroundTypes.END);
    public static final RegistryEntrySupplier<Block, HerbBlock> BAMBOO_SPROUT = RuneCraftoryBlocks.herb("bamboo_sprout", List.of(BiomeTags.IS_JUNGLE, RunecraftoryTags.Biomes.IS_LUSH, RunecraftoryTags.Biomes.IS_DENSE_VEGETATION_OVERWORLD), List.of(RunecraftoryTags.Biomes.COMMON_GROUND_BLACKLIST), new HerbBlock.GroundTypes[0]);
    public static final RegistryEntrySupplier<Block, TreeRootBlock> TREE_SOIL = BLOCKS.register("tree_soil", () -> new TreeRootBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT).sound(SoundType.GRAVEL).strength(-1.0f, 99999.0f)));
    public static final RegistryEntrySupplier<Block, TreeBaseBlock> APPLE_TREE = BLOCKS.register("apple_tree", () -> new TreeBaseBlock(RuneCraftoryBlocks.logProps(), RuneCraftoryFeatures.APPLE_1, RuneCraftoryFeatures.APPLE_2, RuneCraftoryFeatures.APPLE_3, (ResourceKey<Item>)RuneCraftoryItems.APPLE_SAPLING.getKey()));
    public static final RegistryEntrySupplier<Block, TreeSaplingBlock> APPLE_SAPLING = BLOCKS.register("apple_sapling", () -> new TreeSaplingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING), (Supplier<? extends Block>)APPLE_TREE));
    public static final RegistryEntrySupplier<Block, TreeLogBlock> APPLE_WOOD = BLOCKS.register("apple_wood", () -> new TreeLogBlock(RuneCraftoryBlocks.logProps()));
    public static final RegistryEntrySupplier<Block, LeavesBlock> APPLE_LEAVES = BLOCKS.register("apple_leaves", () -> new TreeLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final RegistryEntrySupplier<Block, TreeFruitLeavesBlock> APPLE = BLOCKS.register("apple_leaves_fruit", () -> new TreeFruitLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), RuneCraftoryBlocks.ofVanilla(Items.APPLE)));
    public static final RegistryEntrySupplier<Block, TreeBaseBlock> ORANGE_TREE = BLOCKS.register("orange_tree", () -> new TreeBaseBlock(RuneCraftoryBlocks.logProps(), RuneCraftoryFeatures.ORANGE_1, RuneCraftoryFeatures.ORANGE_2, RuneCraftoryFeatures.ORANGE_3, (ResourceKey<Item>)RuneCraftoryItems.ORANGE_SAPLING.getKey()));
    public static final RegistryEntrySupplier<Block, TreeSaplingBlock> ORANGE_SAPLING = BLOCKS.register("orange_sapling", () -> new TreeSaplingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING), (Supplier<? extends Block>)ORANGE_TREE));
    public static final RegistryEntrySupplier<Block, TreeLogBlock> ORANGE_WOOD = BLOCKS.register("orange_wood", () -> new TreeLogBlock(RuneCraftoryBlocks.logProps()));
    public static final RegistryEntrySupplier<Block, LeavesBlock> ORANGE_LEAVES = BLOCKS.register("orange_leaves", () -> new TreeLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final RegistryEntrySupplier<Block, TreeFruitLeavesBlock> ORANGE = BLOCKS.register("orange_leaves_fruit", () -> new TreeFruitLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), (ResourceKey<Item>)RuneCraftoryItems.ORANGE.getKey()));
    public static final RegistryEntrySupplier<Block, TreeBaseBlock> GRAPE_TREE = BLOCKS.register("grape_tree", () -> new TreeBaseBlock(RuneCraftoryBlocks.logProps(), RuneCraftoryFeatures.GRAPE_1, RuneCraftoryFeatures.GRAPE_2, RuneCraftoryFeatures.GRAPE_3, (ResourceKey<Item>)RuneCraftoryItems.GRAPE_SAPLING.getKey()));
    public static final RegistryEntrySupplier<Block, TreeSaplingBlock> GRAPE_SAPLING = BLOCKS.register("grape_sapling", () -> new TreeSaplingBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING), (Supplier<? extends Block>)GRAPE_TREE));
    public static final RegistryEntrySupplier<Block, TreeLogBlock> GRAPE_WOOD = BLOCKS.register("grape_wood", () -> new TreeLogBlock(RuneCraftoryBlocks.logProps()));
    public static final RegistryEntrySupplier<Block, LeavesBlock> GRAPE_LEAVES = BLOCKS.register("grape_leaves", () -> new TreeLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)));
    public static final RegistryEntrySupplier<Block, TreeFruitLeavesBlock> GRAPE = BLOCKS.register("grape_leaves_fruit", () -> new TreeFruitLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES), (ResourceKey<Item>)RuneCraftoryItems.GRAPES.getKey()));
    public static final RegistryEntrySupplier<Block, LiquidBlock> HOT_SPRING_WATER = BLOCKS.register("hot_spring_water", () -> new LiquidBlock((FlowingFluid)RuneCraftoryFluids.FLOWING_HOT_SPRING_WATER.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<BrokenMineralBlockEntity>> BROKEN_MINERAL_TILE = RuneCraftoryBlocks.brokenMineralTile("broken_mineral_tile", BROKEN_MINERAL_MAP.values());
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<AccessoryBlockEntity>> ACCESSORY_TILE = BLOCK_ENTITY_TYPES.register("accessory_tile", () -> BlockEntityType.Builder.of(AccessoryBlockEntity::new, (Block[])new Block[]{(Block)ACCESSORY_WORKBENCH.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<ForgingBlockEntity>> FORGING_TILE = BLOCK_ENTITY_TYPES.register("forge_tile", () -> BlockEntityType.Builder.of(ForgingBlockEntity::new, (Block[])new Block[]{(Block)FORGE.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<ChemistryBlockEntity>> CHEMISTRY_TILE = BLOCK_ENTITY_TYPES.register("chemistry_tile", () -> BlockEntityType.Builder.of(ChemistryBlockEntity::new, (Block[])new Block[]{(Block)CHEMISTRY_SET.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<CookingBlockEntity>> COOKING_TILE = BLOCK_ENTITY_TYPES.register("cooking_tile", () -> BlockEntityType.Builder.of(CookingBlockEntity::new, (Block[])new Block[]{(Block)COOKING_TABLE.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<BossSpawnerBlockEntity>> BOSS_SPAWNER_TILE = BLOCK_ENTITY_TYPES.register("spawner_tile", () -> BlockEntityType.Builder.of(BossSpawnerBlockEntity::new, (Block[])new Block[]{(Block)BOSS_SPAWNER.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<SingleTimeSpawner>> SINGLE_SPAWNER_TILE = BLOCK_ENTITY_TYPES.register("single_spawner_tile", () -> BlockEntityType.Builder.of(SingleTimeSpawner::new, (Block[])new Block[]{(Block)SINGLE_SPAWN_BLOCK.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<MonsterBarnBlockEntity>> MONSTER_BARN_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("monster_barn_block_entity", () -> BlockEntityType.Builder.of(MonsterBarnBlockEntity::new, (Block[])new Block[]{(Block)MONSTER_BARN.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<TreeBlockEntity>> TREE_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("tree", () -> BlockEntityType.Builder.of(TreeBlockEntity::new, (Block[])new Block[]{(Block)APPLE_TREE.get(), (Block)ORANGE_TREE.get(), (Block)GRAPE_TREE.get()}).build(null));
    public static final RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<TreeLogBlockEntity>> TREE_LOG_ENTITY = BLOCK_ENTITY_TYPES.register("tree_log", () -> BlockEntityType.Builder.of(TreeLogBlockEntity::new, (Block[])new Block[]{(Block)APPLE_WOOD.get(), (Block)ORANGE_WOOD.get(), (Block)GRAPE_WOOD.get()}).build(null));

    public static RegistryEntrySupplier<Block, MineralBlock> mineral(MineralBlockTier name, List<TagKey<Biome>> whitelist, List<TagKey<Biome>> blacklist) {
        RegistryEntrySupplier reg = BLOCKS.register("ore_" + name.getSerializedName(), () -> new MineralBlock(name, BlockBehaviour.Properties.of().lightLevel(s -> 1).strength(5.0f, 10.0f).requiresCorrectToolForDrops()));
        MINERAL_MAP.put(name, reg);
        if (TenshiLibCrossPlat.INSTANCE.isDatagen()) {
            GENERATION_TAGS.put(reg, new RunecraftoryTags.Biomes.BiomeGenerationTags(whitelist, blacklist));
        }
        return reg;
    }

    public static RegistryEntrySupplier<Block, BrokenMineralBlock> brokenMineral(MineralBlockTier name) {
        RegistryEntrySupplier reg = BLOCKS.register("ore_broken_" + name.getSerializedName(), () -> new BrokenMineralBlock(name, BlockBehaviour.Properties.of().strength(30.0f, 15.0f)));
        BROKEN_MINERAL_MAP.put(name, reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block, ExtendedCropBlock> crop(String name, Supplier<ResourceKey<Item>> crop, Supplier<ResourceKey<Item>> seed) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new ExtendedCropBlock(RuneCraftoryBlocks.cropProps(), (ResourceKey<Item>)((ResourceKey)crop.get()), (ResourceKey<Item>)((ResourceKey)seed.get())));
        CROPS.add(reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block, GiantCropBlock> giantCrop(String name, Supplier<ResourceKey<Item>> giant, Supplier<ResourceKey<Item>> seed) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new GiantCropBlock(RuneCraftoryBlocks.cropProps(), (ResourceKey<Item>)((ResourceKey)giant.get()), (ResourceKey<Item>)((ResourceKey)seed.get())));
        CROPS.add(reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block, GiantCropBlock> giantCrop(String name, Supplier<ResourceKey<Item>> giant, Supplier<ResourceKey<Item>> seed, RegistryEntrySupplier<Block, ?> crop) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new GiantCropBlock(RuneCraftoryBlocks.cropProps(), (ResourceKey<Item>)((ResourceKey)giant.get()), (ResourceKey<Item>)((ResourceKey)seed.get())));
        CROPS.add(reg);
        if (TenshiLibCrossPlat.INSTANCE.isDatagen()) {
            GIANT_CROP_MAP.put(crop, reg);
        }
        return reg;
    }

    public static RegistryEntrySupplier<Block, ExtendedCropBlock> flower(String name, Supplier<ResourceKey<Item>> crop, Supplier<ResourceKey<Item>> seed) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new ExtendedCropBlock(RuneCraftoryBlocks.cropProps(), (ResourceKey<Item>)((ResourceKey)crop.get()), (ResourceKey<Item>)((ResourceKey)seed.get())));
        FLOWERS.add(reg);
        return reg;
    }

    public static RegistryEntrySupplier<Block, GiantCropBlock> giantFlower(String name, Supplier<ResourceKey<Item>> giant, Supplier<ResourceKey<Item>> seed, RegistryEntrySupplier<Block, ?> flower) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new GiantCropBlock(RuneCraftoryBlocks.cropProps(), (ResourceKey<Item>)((ResourceKey)giant.get()), (ResourceKey<Item>)((ResourceKey)seed.get()), true));
        FLOWERS.add(reg);
        if (TenshiLibCrossPlat.INSTANCE.isDatagen()) {
            GIANT_CROP_MAP.put(flower, reg);
        }
        return reg;
    }

    public static RegistryEntrySupplier<Block, HerbBlock> herb(String name, List<TagKey<Biome>> whitelist, List<TagKey<Biome>> blacklist, HerbBlock.GroundTypes ... types) {
        RegistryEntrySupplier reg = BLOCKS.register(name, () -> new HerbBlock(RuneCraftoryBlocks.plantProps(), types));
        HERBS.add(reg);
        if (TenshiLibCrossPlat.INSTANCE.isDatagen()) {
            GENERATION_TAGS.put(reg, new RunecraftoryTags.Biomes.BiomeGenerationTags(whitelist, blacklist));
        }
        return reg;
    }

    public static <T> Collection<T> combine(Collection<T> one, Collection<T> other) {
        one.addAll(other);
        return one;
    }

    public static RegistryEntrySupplier<BlockEntityType<?>, BlockEntityType<BrokenMineralBlockEntity>> brokenMineralTile(String name, Collection<RegistryEntrySupplier<Block, ?>> blocks) {
        return BLOCK_ENTITY_TYPES.register(name, () -> BlockEntityType.Builder.of(BrokenMineralBlockEntity::new, (Block[])((Block[])blocks.stream().map(Supplier::get).toArray(Block[]::new))).build(null));
    }

    private static BlockBehaviour.Properties logProps() {
        return BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASS).strength(2.0f).sound(SoundType.WOOD).strength(2.0f).sound(SoundType.WOOD);
    }

    private static BlockBehaviour.Properties plantProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties cropProps() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY);
    }

    private static ResourceKey<Item> ofVanilla(Item item) {
        return ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)item));
    }
}

