/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.registry;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.tenshilib.loader.LoaderRegistryAccess;
import io.github.flemmli97.tenshilib.loader.TenshiLibCrossPlat;
import io.github.flemmli97.tenshilib.loader.registry.LoaderRegister;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.Nullable;

public class RuneCraftorySounds {
    public static final LoaderRegister<SoundEvent> SOUND_EVENTS = LoaderRegistryAccess.INSTANCE.of(Registries.SOUND_EVENT, "runecraftory");
    public static final Map<ResourceLocation, SoundHolder> SOUND_DATA = new HashMap<ResourceLocation, SoundHolder>();
    public static final List<BGMHolder> BGM = new ArrayList<BGMHolder>();
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_AMBROSIA_ANGRY = RuneCraftorySounds.register("entity.ambrosia.angry", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_AMBROSIA_SPAWN = RuneCraftorySounds.register("entity.ambrosia.spawn");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_AMBROSIA_WAVE = RuneCraftorySounds.register("entity.ambrosia.wave", "Ambrosia humming");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_BUFFAMOO_DEATH = RuneCraftorySounds.register("entity.buffamoo.death", null, ResourceLocation.withDefaultNamespace((String)"mob/cow/hurt"), 3, 0.8f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_BUFFAMOO_HURT = RuneCraftorySounds.register("entity.buffamoo.hurt", null, ResourceLocation.withDefaultNamespace((String)"mob/cow/hurt"), 3, 0.8f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_BUFFAMOO_STEP = RuneCraftorySounds.register("entity.buffamoo.step", null, ResourceLocation.withDefaultNamespace((String)"mob/cow/step"), 4, 0.2f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_CHIMERA_AMBIENT = RuneCraftorySounds.register("entity.chimera.ambient", "Chimera growl", 2);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_CHIMERA_ROAR = RuneCraftorySounds.register("entity.chimera.roar", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_CHIPSQUEEK_HURT = RuneCraftorySounds.register("entity.chipsqueek.hurt", "Chipsqueek squeak", 2);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_CLUCKADOODLE_DEATH = RuneCraftorySounds.register("entity.cluckadoodle.death", null, ResourceLocation.withDefaultNamespace((String)"mob/chicken/hurt"), 2, 0.8f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_CLUCKADOODLE_HURT = RuneCraftorySounds.register("entity.cluckadoodle.hurt", null, ResourceLocation.withDefaultNamespace((String)"mob/chicken/hurt"), 2, 0.8f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_DEAD_TREE_DEATH = RuneCraftorySounds.register("entity.dead_tree.death", "Dead tree dies");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_DEAD_TREE_HURT = RuneCraftorySounds.register("entity.dead_tree.hurt", null, ResourceLocation.withDefaultNamespace((String)"mob/zombie/wood"), 4);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_DEAD_TREE_ROAR = RuneCraftorySounds.register("entity.dead_tree.roar", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_FAIRY_AMBIENT = RuneCraftorySounds.register("entity.fairy.ambient", "Fairy shimmer");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_FLOWER_LILY_STEP = RuneCraftorySounds.register("entity.flower_lily.step", "", 2);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_GENERIC_HEAVY_CHARGE = RuneCraftorySounds.register("entity.generic.heavy_charge", "Entity charge");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_GHOST_AMBIENT = RuneCraftorySounds.register("entity.ghost.ambient", null, 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_GOBLING_AMBIENT = RuneCraftorySounds.register("entity.goblin.ambient", null, 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_GOBLING_HURT = RuneCraftorySounds.register("entity.goblin.hurt", null);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_GOBLIN_DEATH = RuneCraftorySounds.register("entity.goblin.death", null);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_GRIMOIRE_ROAR = RuneCraftorySounds.register("entity.grimoire.roar", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_HANDONETTA_ROAR = RuneCraftorySounds.register("entity.handonetta.roar", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_HORNET_BUZZ = RuneCraftorySounds.register("entity.hornet.buzz", 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_HORNET_DEATH = RuneCraftorySounds.register("entity.hornet.death", null, ResourceLocation.withDefaultNamespace((String)"mob/bee/death"), 2, 0.7f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_HORNET_HURT = RuneCraftorySounds.register("entity.hornet.hurt", null, ResourceLocation.withDefaultNamespace((String)"mob/bee/hurt"), 3, 0.8f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_MARIONETTA_ROAR = RuneCraftorySounds.register("entity.marionetta.roar", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ORC_AMBIENT = RuneCraftorySounds.register("entity.orc.ambient", "Orc grunts", ResourceLocation.withDefaultNamespace((String)"mob/piglin_brute/idle"), 7);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ORC_BONK = RuneCraftorySounds.register("entity.orc.bonk", "Maze bonk");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ORC_DEATH = RuneCraftorySounds.register("entity.orc.death", null, ResourceLocation.withDefaultNamespace((String)"mob/piglin_brute/death"), 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ORC_HURT = RuneCraftorySounds.register("entity.orc.hurt", null, ResourceLocation.withDefaultNamespace((String)"mob/piglin_brute/hurt"), 4);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_PANTHER_AMBIENT = RuneCraftorySounds.register("entity.panther.ambient", null);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_PANTHER_HURT = RuneCraftorySounds.register("entity.panther.hurt", null);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_RACCOON_ROAR = RuneCraftorySounds.register("entity.raccoon.roar", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_RAFFLESIA_ANGRY = RuneCraftorySounds.register("entity.rafflesia.angry", "Rafflesia hiss");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_RAFFLESIA_DEATH = RuneCraftorySounds.register("entity.rafflesia.death", null);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_SARCOPHAGUS_ROAR = RuneCraftorySounds.register("entity.sarcophagus.roar", null, ResourceLocation.withDefaultNamespace((String)"mob/enderdragon/growl"), 2, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_SCORPION_DEATH = RuneCraftorySounds.register("entity.scorpion.death", null, ResourceLocation.withDefaultNamespace((String)"mob/spider/death"), 1, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_SCORPION_HURT = RuneCraftorySounds.register("entity.scorpion.hurt", null, ResourceLocation.withDefaultNamespace((String)"mob/spider/say"), 4, 1.5f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_SCORPION_STEP = RuneCraftorySounds.register("entity.scorpion.step", "Scorpion rustle");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_SKELEFANG_ROAR = RuneCraftorySounds.register("entity.skelefang.roar", null);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_SKELEFANG_SWEEP = RuneCraftorySounds.register("entity.skelefang.sweep", null, ResourceLocation.withDefaultNamespace((String)"entity/player/attack/sweep"), 7, 0.7f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_THUNDERBOLT_AMBIENT = RuneCraftorySounds.register("entity.thunderbolt.ambient", "Thunderbolt neighs", ResourceLocation.withDefaultNamespace((String)"mob/horse/idle"), 3, 0.8f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_THUNDERBOLT_GALLOP = RuneCraftorySounds.register("entity.thunderbolt.gallop", null, ResourceLocation.withDefaultNamespace((String)"mob/horse/gallop"), 4);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_THUNDERBOLT_HURT = RuneCraftorySounds.register("entity.thunderbolt.hurt", null, ResourceLocation.withDefaultNamespace((String)"mob/horse/hit"), 4, 0.8f);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_THUNDERBOLT_NEIGH = RuneCraftorySounds.register("entity.thunderbolt.neigh", null);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_WEAGLE_FLAP = RuneCraftorySounds.register("entity.weagle.flap");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_WISP_AMBIENT = RuneCraftorySounds.register("entity.wisp.ambient");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_BOSS_DEFEAT = RuneCraftorySounds.register("entity.boss.defeat", null, ResourceLocation.withDefaultNamespace((String)"mob/wither/death"));
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ATTACK_BLOCKED = RuneCraftorySounds.register("entity.generic.attack_blocked", "Attack blocked", ResourceLocation.withDefaultNamespace((String)"random/anvil_land"));
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_BIG_PLATE_LAND = RuneCraftorySounds.register("entity.big_plate.land", null, ResourceLocation.withDefaultNamespace((String)"random/anvil_land"));
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_EARTH_SPIKE_ATTACK = RuneCraftorySounds.register("entity.earth_spike.attack", null, ResourceLocation.withDefaultNamespace((String)"random/eat"), 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ELEMENTAL_TRAIL_EARTH = RuneCraftorySounds.register("entity.elemental_trail.earth.ambient", null, SoundEvents.ROOTED_DIRT_BREAK.getLocation(), 4);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ELEMENTAL_TRAIL_WATER = RuneCraftorySounds.register("entity.elemental_trail.water.ambient", null, ResourceLocation.withDefaultNamespace((String)"random/glass"), 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_ENERGY_ORB_AMBIENT = RuneCraftorySounds.register("entity.energy_orb.ambient", "Energy Orb", ResourceLocation.withDefaultNamespace((String)"mob/guardian/attack_loop"));
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_FIREWALL_SPAWN = RuneCraftorySounds.register("entity.fire_wall.spawn", null, ResourceLocation.withDefaultNamespace((String)"mob/ghast/fireball4"));
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_RUNEY_COLLECT = RuneCraftorySounds.register("entity.runey.collect", null, ResourceLocation.withDefaultNamespace((String)"random/glass"), 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> PLAYER_ARMOR_PIYO_CHIRP = RuneCraftorySounds.register("player.armor.piyo_chirp", "Piyo Sandal chirp", 4);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> PLAYER_ATTACK_SWOOSH = RuneCraftorySounds.register("player.attack.swoosh", 4);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> PLAYER_ATTACK_SWOOSH_HEAVY = RuneCraftorySounds.register("player.attack.swoosh_heavy");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> PLAYER_ATTACK_SWOOSH_LIGHT = RuneCraftorySounds.register("player.attack.swoosh_light", 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> PLAYER_BRUSH = RuneCraftorySounds.register("player.brush", "Player brushing", ResourceLocation.withDefaultNamespace((String)"mob/horse/leather"));
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_APPLE_RAIN = RuneCraftorySounds.register("spell.apple_rain");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_BUFF = RuneCraftorySounds.register("spell.generic.buff", "Spell buff");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_DARK = RuneCraftorySounds.register("spell.generic.dark");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_ELECTRIC_ZAP = RuneCraftorySounds.register("spell.generic.electric_zap");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_FIRE_BALL = RuneCraftorySounds.register("spell.generic.fireball");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_HEAL = RuneCraftorySounds.register("spell.generic.heal", 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_LEAP = RuneCraftorySounds.register("spell.generic.leap");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_LIGHT = RuneCraftorySounds.register("spell.generic.light");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_POOF = RuneCraftorySounds.register("spell.generic.poof");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_POP = RuneCraftorySounds.register("spell.generic.pop");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_ROCKS = RuneCraftorySounds.register("spell.generic.rocks");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_WATER = RuneCraftorySounds.register("spell.generic.wave");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_WATERBUBBLE = RuneCraftorySounds.register("spell.generic.water_bubble");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_WIND = RuneCraftorySounds.register("spell.generic.wind");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_GENERIC_WIND_LONG = RuneCraftorySounds.register("spell.generic.wind_long");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_NAIVE_BLADE = RuneCraftorySounds.register("spell.naive_blade");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SPELL_STRAIGHT_PUNCH = RuneCraftorySounds.register("spell.straight_punch");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> GENERIC_SUCCESS = RuneCraftorySounds.register("generic.success", "Action success", ResourceLocation.withDefaultNamespace((String)"mob/villager/yes"), 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> GENERIC_DENY = RuneCraftorySounds.register("generic.deny", "Action denied", ResourceLocation.withDefaultNamespace((String)"mob/villager/no"), 3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> GENERIC_TELEPORT = RuneCraftorySounds.register("generic.teleport", "Entity teleports", ResourceLocation.withDefaultNamespace((String)"mob/endermen/portal"));
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> GENERIC_FARM_LAND_WATER = RuneCraftorySounds.register("generic.farmland.water", "Watering Farmland", SoundEvents.BOAT_PADDLE_WATER.getLocation(), 8);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> GENERIC_ITEM_STAT_CONSUME = RuneCraftorySounds.register("generic.item_stat.consume", "Drinking", SoundEvents.BREWING_STAND_BREW.getLocation(), 2);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> ENTITY_NPC_CHANGE = RuneCraftorySounds.register("entity.npc.change", null, SPELL_GENERIC_WATERBUBBLE.getID(), 1, 1.5f);
    public static final ResourceKey<SoundEvent> BGM1 = RuneCraftorySounds.bgmKey("kesshi-no-tatakai-ni-idomu-monotachi");
    public static final ResourceKey<SoundEvent> BGM2 = RuneCraftorySounds.bgmKey("dragon");
    public static final ResourceKey<SoundEvent> BGM3 = RuneCraftorySounds.bgmKey("battle-determination");
    public static final ResourceKey<SoundEvent> BGM4 = RuneCraftorySounds.bgmKey("janguru-de-no-tatakai");
    public static final ResourceKey<SoundEvent> BGM5 = RuneCraftorySounds.bgmKey("escape");
    public static final ResourceKey<SoundEvent> BGM6 = RuneCraftorySounds.bgmKey("yami-no-sekai-no-tatakai");
    public static final ResourceKey<SoundEvent> BGM7 = RuneCraftorySounds.bgmKey("tatakai-no-tabiji-o-seiku");
    public static final ResourceKey<SoundEvent> BGM8 = RuneCraftorySounds.bgmKey("yurei");
    public static final ResourceKey<SoundEvent> BGM9 = RuneCraftorySounds.bgmKey("gokumon-oni-rasetsu");
    public static final ResourceKey<SoundEvent> BGM10 = RuneCraftorySounds.bgmKey("golem_battle");
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> CHIMERA_FIGHT = RuneCraftorySounds.registerBgm("bgm.chimera_fight", BGM1);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> RAFFLESIA_FIGHT = RuneCraftorySounds.registerBgm("bgm.rafflesia_fight", BGM2);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> GRIMOIRE_FIGHT = RuneCraftorySounds.registerBgm("bgm.grimoire_fight", BGM3);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> DEAD_TREE_FIGHT = RuneCraftorySounds.registerBgm("bgm.dead_tree_fight", BGM4);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> RACCOON_FIGHT = RuneCraftorySounds.registerBgm("bgm.raccoon_fight", BGM5);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SKELEFANG_FIGHT = RuneCraftorySounds.registerBgm("bgm.skelefang_fight", BGM6);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> AMBROSIA_FIGHT = RuneCraftorySounds.registerBgm("bgm.ambrosia_fight", BGM7);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> THUNDERBOLT_FIGHT = RuneCraftorySounds.registerBgm("bgm.thunderbolt_fight", BGM7);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> MARIONETTA_FIGHT = RuneCraftorySounds.registerBgm("bgm.marionetta_fight", BGM8);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> HANDONETTA_FIGHT = RuneCraftorySounds.registerBgm("bgm.handonetta_fight", BGM8);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SANO_UNO_FIGHT = RuneCraftorySounds.registerBgm("bgm.sano_uno_fight", BGM9);
    public static final RegistryEntrySupplier<SoundEvent, SoundEvent> SARCOPHAGUS_FIGHT = RuneCraftorySounds.registerBgm("bgm.sarcophagus_fight", BGM10);

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> register(String name) {
        return RuneCraftorySounds.register(name, null, 1);
    }

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> register(String name, String translation) {
        return RuneCraftorySounds.register(name, translation, 1);
    }

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> register(String name, int variations) {
        return RuneCraftorySounds.register(name, null, variations);
    }

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> register(String name, String translation, int variations) {
        RegistryEntrySupplier res = SOUND_EVENTS.register(name, SoundEvent::createVariableRangeEvent);
        if (TenshiLibCrossPlat.INSTANCE.isDatagen()) {
            SOUND_DATA.put(res.getID(), new SoundHolder(res.getID(), variations, 1.0f, translation));
        }
        return res;
    }

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> register(String name, String translation, ResourceLocation location) {
        return RuneCraftorySounds.register(name, translation, location, 1);
    }

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> register(String name, String translation, ResourceLocation location, int amount) {
        return RuneCraftorySounds.register(name, translation, location, amount, 1.0f);
    }

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> register(String name, String translation, ResourceLocation location, int amount, float pitch) {
        RegistryEntrySupplier res = SOUND_EVENTS.register(name, SoundEvent::createVariableRangeEvent);
        if (TenshiLibCrossPlat.INSTANCE.isDatagen()) {
            SOUND_DATA.put(res.getID(), new SoundHolder(location, amount, pitch, translation));
        }
        return res;
    }

    private static RegistryEntrySupplier<SoundEvent, SoundEvent> registerBgm(String name, ResourceKey<SoundEvent> bgm) {
        RegistryEntrySupplier res = SOUND_EVENTS.register(name, SoundEvent::createVariableRangeEvent);
        BGM.add(new BGMHolder((RegistryEntrySupplier<SoundEvent, SoundEvent>)res, bgm));
        return res;
    }

    private static ResourceKey<SoundEvent> bgmKey(String bgm) {
        return ResourceKey.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)RuneCraftory.modRes("bgm/" + bgm));
    }

    public record SoundHolder(ResourceLocation location, int amount, float pitch, @Nullable String defaultTranslation) {
    }

    public record BGMHolder(RegistryEntrySupplier<SoundEvent, SoundEvent> sound, ResourceKey<SoundEvent> bgm) {
    }
}

