/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.ElementalBallEntity;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.tenshilib.common.utils.math.MathUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BaseStaffSpell
extends Spell {
    private static final float[] OFFSET_TWO = new float[]{-0.5f, 0.5f};
    private static final float[] OFFSET_THREE = new float[]{-1.0f, 0.0f, 1.0f};

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack) {
        boolean bl;
        Item item = stack.getItem();
        if (item instanceof ItemStaffBase) {
            ItemStaffBase staff = (ItemStaffBase)item;
            if (staff.amount <= 1) {
                bl = true;
                return super.use(level, entity, stack, bl);
            }
        }
        bl = false;
        return super.use(level, entity, stack, bl);
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        Item item = stack.getItem();
        if (item instanceof ItemStaffBase) {
            ItemStaffBase staff = (ItemStaffBase)item;
            ItemElement element = ItemComponentUtils.getElement(stack);
            if (element == ItemElement.NONE) {
                return false;
            }
            if (staff.amount == 1) {
                ElementalBallEntity ball = new ElementalBallEntity((Level)level, entity, element);
                Vec3 look = entity.getViewVector(1.0f);
                ball.shoot(look.x, look.y, look.z, 1.0f, 0.0f);
                entity.level().addFreshEntity((Entity)ball);
            } else if (staff.amount == 2) {
                for (float offset : OFFSET_TWO) {
                    Vec3 side = MathUtils.NORMAL_X.yRot(-entity.getYRot() * ((float)Math.PI / 180));
                    Vec3 newPos = entity.position().add(side.scale((double)offset)).add(0.0, (double)entity.getEyeHeight() - 0.1, 0.0);
                    ElementalBallEntity ball = new ElementalBallEntity((Level)level, entity, element);
                    Vec3 look = entity.getViewVector(1.0f);
                    ball.shoot(look.x, look.y, look.z, 1.0f, 0.0f);
                    ball.setPos(newPos.x, newPos.y, newPos.z);
                    entity.level().addFreshEntity((Entity)ball);
                }
            } else {
                for (float offset : OFFSET_THREE) {
                    Vec3 side = MathUtils.NORMAL_X.yRot(-entity.getYRot() * ((float)Math.PI / 180));
                    Vec3 newPos = entity.position().add(side.scale((double)offset)).add(0.0, (double)entity.getEyeHeight() - 0.1, 0.0);
                    ElementalBallEntity ball = new ElementalBallEntity((Level)level, entity, element);
                    Vec3 look = entity.getViewVector(1.0f);
                    ball.shoot(look.x, look.y, look.z, 1.0f, 0.0f);
                    ball.setPos(newPos.x, newPos.y, newPos.z);
                    entity.level().addFreshEntity((Entity)ball);
                }
            }
            return true;
        }
        return false;
    }
}

