/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.spells.PoisonHealSpell;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ParaHealSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        Consumer<LivingEntity> apply = living -> {
            if (lvl >= 10) {
                entity.removeEffect(RuneCraftoryEffects.SEAL.asHolder());
            }
            if (lvl >= 5) {
                entity.removeEffect(RuneCraftoryEffects.POISON.asHolder());
                entity.removeEffect(MobEffects.DIG_SLOWDOWN);
            }
            entity.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
            entity.removeEffect(RuneCraftoryEffects.PARALYSIS.asHolder());
            PoisonHealSpell.spawnStatusHealParticles(living);
        };
        List entities = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(12.0), e -> {
            if (e == entity) {
                return true;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (e instanceof OwnableEntity) {
                    OwnableEntity ownable = (OwnableEntity)e;
                    if (player.getUUID().equals(ownable.getOwnerUUID())) return true;
                }
                if (e instanceof AbstractVillager) return true;
                if (e instanceof Animal) return true;
                if (!((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).party.isPartyMember((Entity)e)) return false;
                return true;
            }
            if (!(entity instanceof HealingPredicateEntity)) return false;
            HealingPredicateEntity healer = (HealingPredicateEntity)entity;
            return healer.healeableEntities().test((LivingEntity)e);
        });
        apply.accept(entity);
        entities.forEach(apply);
        ParaHealSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_HEAL.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

