/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.PollenPuffEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PollenPuffSpell
extends Spell {
    private static final Vec3[] DIRS = PollenPuffSpell.dirs(16);

    private static Vec3[] dirs(int amount) {
        Vec3[] arr = new Vec3[amount];
        Vec3 dir = new Vec3(2.0, 1.0, 0.0).normalize();
        float step = 360.0f / (float)amount;
        for (int i = 0; i < amount; ++i) {
            arr[i] = dir.yRot((float)i * step * ((float)Math.PI / 180));
        }
        return arr;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        for (Vec3 dir : DIRS) {
            PollenPuffEntity puff = new PollenPuffEntity((Level)level, entity);
            puff.setPos(puff.getX(), entity.getY() + (double)entity.getBbHeight() * 0.2, puff.getZ());
            puff.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
            puff.shoot(dir.x(), dir.y(), dir.z(), 0.23f, 0.0f);
            level.addFreshEntity((Entity)puff);
        }
        PollenPuffSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_POOF.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

