/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.LightBallEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PrismSpell
extends Spell {
    private final boolean longDuration;

    public PrismSpell(boolean longDuration) {
        this.longDuration = longDuration;
    }

    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        List lights = level.getEntities((Entity)entity, entity.getBoundingBox().inflate(4.0), e -> {
            LightBallEntity light;
            return e instanceof LightBallEntity && (light = (LightBallEntity)((Object)e)).getOwner() == entity;
        });
        lights.forEach(e -> e.remove(Entity.RemovalReason.KILLED));
        LightBallEntity.createLights((Level)level, entity, this.longDuration ? LightBallEntity.Type.PIERCING_LONG : LightBallEntity.Type.PIERCING_SHORT, CombatUtils.getAbilityDamageBonus(lvl, this), 4);
        PrismSpell.playSound(entity, (SoundEvent)RuneCraftorySounds.SPELL_GENERIC_LIGHT.get(), 1.0f, (entity.getRandom().nextFloat() - entity.getRandom().nextFloat()) * 0.2f + 1.0f);
        return true;
    }
}

