/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.spells;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.misc.SlashResidueEntity;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ProjectileUtils;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SlashSpell
extends Spell {
    @Override
    public boolean use(ServerLevel level, LivingEntity entity, ItemStack stack, float rpUseMultiplier, int amount, int lvl) {
        if (!Spell.tryUseWithCost(entity, stack, this)) {
            return false;
        }
        SlashResidueEntity slash = new SlashResidueEntity((Level)level, entity);
        slash.setSize(1.7f);
        Vec3 pos = entity.position();
        Vec3 target = ProjectileUtils.getAimTarget(entity);
        Vec3 dir = target != null ? target.subtract(pos).normalize().scale(1.0 + (double)entity.getBbWidth() * 0.5) : entity.getViewVector(1.0f).scale(1.0 + (double)entity.getBbWidth() * 0.5);
        slash.setPos(pos.x + dir.x, pos.y + Mth.clamp((double)dir.y, (double)-0.3, (double)0.8), pos.z + dir.z);
        slash.setDamageMultiplier(CombatUtils.getAbilityDamageBonus(lvl, this));
        slash.lookAt(EntityAnchorArgument.Anchor.FEET, entity.position());
        level.addFreshEntity((Entity)slash);
        return true;
    }
}

