/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.ImmutableList;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import io.github.flemmli97.runecraftory.common.entities.misc.TreasureChestEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.items.creative.TreasureChestSpawnegg;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.network.S2CUpdateAttributesWithAdditional;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEffects;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityUtils {
    private static final List<WeightedChestTier> CHEST_TIERS = ImmutableList.of((Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.COMMON, 150, 0.4f, 550), (Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.UNCOMMON, 40, 0.3f, 200), (Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.RARE, 1, 0.3f, 60), (Object)new WeightedChestTier(TreasureChestSpawnegg.ChestTier.EPIC, 0, 0.0f, 20));

    public static double tryGetAttribute(LivingEntity entity, Holder<Attribute> attribute) {
        AttributeInstance inst = entity.getAttribute(attribute);
        if (inst == null) {
            return ((Attribute)attribute.value()).getDefaultValue();
        }
        return inst.getValue();
    }

    public static double attackSpeedModifier(LivingEntity entity) {
        return EntityUtils.tryGetAttribute(entity, (Holder<Attribute>)RuneCraftoryAttributes.ATTACK_SPEED.asHolder());
    }

    public static Rotation fromDirection(Direction direction) {
        return switch (direction) {
            case Direction.EAST -> Rotation.CLOCKWISE_90;
            case Direction.SOUTH -> Rotation.CLOCKWISE_180;
            case Direction.WEST -> Rotation.COUNTERCLOCKWISE_90;
            default -> Rotation.NONE;
        };
    }

    public static void applyPermanentEffect(LivingEntity entity, Holder<MobEffect> effect, int amplifier) {
        if (!entity.hasEffect(effect)) {
            entity.addEffect(new MobEffectInstance(effect, -1, amplifier, true, false));
        }
    }

    public static boolean sealed(LivingEntity entity) {
        return entity.hasEffect(RuneCraftoryEffects.SEAL.asHolder());
    }

    public static boolean canMonsterTargetNPC(Entity e) {
        NPCEntity npc;
        if (e instanceof NPCEntity && (npc = (NPCEntity)e).getEntityToFollowUUID() != null) {
            return true;
        }
        return MobConfig.mobAttackNpc && e instanceof Npc;
    }

    public static void sendAttributesTo(LivingEntity entity, ServerPlayer player) {
        AttributeInstance att = entity.getAttribute(Attributes.ATTACK_DAMAGE);
        if (att != null) {
            entity.getAttributes().getAttributesToUpdate().add(att);
        }
        if (entity == player) {
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CUpdateAttributesWithAdditional(entity.getAttributes().getAttributesToUpdate()), player);
        } else {
            player.connection.send((Packet)new ClientboundUpdateAttributesPacket(entity.getId(), (Collection)entity.getAttributes().getAttributesToUpdate()));
        }
    }

    public static void foodHealing(LivingEntity entity, float amount) {
        if (amount > 0.0f) {
            entity.heal(amount);
        } else if (!entity.getType().is(RunecraftoryTags.EntityTypes.BOSS_MONSTERS)) {
            entity.setHealth(entity.getHealth() + amount);
        }
    }

    public static float playerLuck(Player player) {
        return player.getLuck();
    }

    public static boolean isDisabled(LivingEntity entity) {
        return entity.hasEffect(RuneCraftoryEffects.SLEEP.asHolder()) || entity.hasEffect(RuneCraftoryEffects.STUNNED.asHolder());
    }

    @Nullable
    public static UUID tryGetOwner(LivingEntity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            return ownableEntity.getOwnerUUID();
        }
        return null;
    }

    public static boolean canAttackOwned(LivingEntity entity, boolean allowUuidOnly, boolean otherwise, Predicate<LivingEntity> pred) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            if (entity.getUUID().equals(ownableEntity.getOwnerUUID())) {
                return false;
            }
            LivingEntity owner = ownableEntity.getOwner();
            if (owner instanceof LivingEntity) {
                LivingEntity living = owner;
                return pred.test(living);
            }
            return allowUuidOnly && ownableEntity.getOwnerUUID() != null || otherwise;
        }
        return otherwise;
    }

    public static float tamingChance(BaseMonster monster, Player player, float itemMultiplier, int brushCount, int loveAttackCount) {
        if (itemMultiplier == 0.0f || GeneralConfig.tamingMultiplier == 0.0f) {
            return 0.0f;
        }
        int lvl = ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getPlayerLevel().getLevel() + 1;
        float lvlPenalty = Math.max(0.0f, (float)(monster.xpLevel().getLevel() - lvl) * 0.02f);
        float brushBonus = (float)brushCount * 0.05f;
        float loveAttackBonus = (float)loveAttackCount * 0.002f;
        float tamingLvlBonus = (float)(((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getSkillLevel(Skills.TAMING).getLevel() - 1) * 0.005f;
        float tamingBonus = 1.0f + brushBonus + loveAttackBonus + tamingLvlBonus;
        return monster.tamingChance() * GeneralConfig.tamingMultiplier * tamingBonus - lvlPenalty;
    }

    public static EntityType<?> trySpawnTreasureChest(GateEntity spawner) {
        if (spawner.getRandom().nextFloat() < MobConfig.treasureChance) {
            if (spawner.getRandom().nextFloat() < MobConfig.mimicChance) {
                if (spawner.getRandom().nextFloat() < MobConfig.mimicStrongChance) {
                    return (EntityType)RuneCraftoryEntities.GOBBLE_BOX.get();
                }
                return (EntityType)RuneCraftoryEntities.MONSTER_BOX.get();
            }
            return (EntityType)RuneCraftoryEntities.TREASURE_CHEST.get();
        }
        return null;
    }

    public static void tieredTreasureChest(GateEntity spawner, TreasureChestEntity chest) {
        int max = 0;
        for (WeightedChestTier tier : CHEST_TIERS) {
            max += tier.getModifiedWeight(spawner.xpLevel().getLevel());
        }
        int rand = spawner.getRandom().nextInt(max);
        for (WeightedChestTier tier : CHEST_TIERS) {
            if ((rand -= tier.getModifiedWeight(spawner.xpLevel().getLevel())) >= 0) continue;
            chest.setTier(tier.tier);
        }
    }

    public static int getRPFromVanillaFood(ItemStack stack) {
        FoodProperties prop = (FoodProperties)stack.get(DataComponents.FOOD);
        if (prop != null) {
            return (int)((double)prop.nutrition() * 1.5 * (1.0 + 1.8 * (double)prop.saturation()));
        }
        return 0;
    }

    public static Vec3 horizontalLookAngle(Entity entity) {
        Vec3 look = entity.getViewVector(1.0f);
        return new Vec3(look.x(), 0.0, look.z()).normalize();
    }

    public static Vec3 getStraightProjectileTarget(Vec3 from, Entity target) {
        AABB aabb = target.getBoundingBox().inflate((double)(-target.getBbHeight()) * 0.1);
        return EntityUtils.getStraightProjectileTarget(from, target.position(), aabb.minY, aabb.maxY);
    }

    public static Vec3 getStraightProjectileTarget(Vec3 from, Vec3 target, double minY, double maxY) {
        return new Vec3(target.x(), Mth.clamp((double)from.y(), (double)minY, (double)maxY), target.z());
    }

    public static Vec3 getTargetDirection(Mob mob, EntityAnchorArgument.Anchor anchor) {
        return EntityUtils.getTargetDirection(mob, anchor, false);
    }

    public static Vec3 getTargetDirection(Mob mob, EntityAnchorArgument.Anchor anchor, boolean horizontalOnly) {
        Vec3 dir;
        Vec3 pos = anchor.apply((Entity)mob);
        if (mob.getControllingPassenger() != null) {
            dir = mob.getControllingPassenger().getViewVector(1.0f);
        } else if (mob.getTarget() != null) {
            LivingEntity target = mob.getTarget();
            dir = anchor.apply((Entity)target).subtract(pos);
        } else {
            dir = mob.getViewVector(1.0f);
        }
        if (horizontalOnly) {
            dir = new Vec3(dir.x(), 0.0, dir.z());
        }
        return dir.normalize();
    }

    public static LivingEntity ownedProjectileTarget(Entity owner, int range) {
        Mob mob;
        if (owner instanceof Mob && (mob = (Mob)owner).getTarget() != null) {
            return mob.getTarget();
        }
        if (owner instanceof LivingEntity) {
            Predicate predicate;
            LivingEntity livingOwner = (LivingEntity)owner;
            Function<LivingEntity, Predicate> generator = ownerEntity -> {
                Predicate<LivingEntity> predicate;
                if (ownerEntity instanceof BaseMonster) {
                    BaseMonster monster = (BaseMonster)ownerEntity;
                    predicate = monster.targetPred;
                } else {
                    predicate = e -> {
                        if (ownerEntity instanceof Player) {
                            if (e instanceof Animal) return false;
                            if (e instanceof Npc) return false;
                            if (!(e instanceof OwnableEntity)) return true;
                            OwnableEntity ownable = (OwnableEntity)e;
                            if (ownerEntity.getUUID().equals(ownable.getOwnerUUID())) return false;
                            return true;
                        }
                        if (!(ownerEntity instanceof Mob)) return false;
                        Mob mob = (Mob)ownerEntity;
                        if (e != mob.getTarget()) return false;
                        return true;
                    };
                }
                return predicate;
            };
            LivingEntity livingEntity = owner.getControllingPassenger();
            if (livingEntity instanceof LivingEntity) {
                LivingEntity controller = livingEntity;
                predicate = generator.apply(controller);
            } else {
                predicate = generator.apply(livingOwner);
            }
            Predicate pred = predicate;
            return owner.level().getNearestEntity(LivingEntity.class, TargetingConditions.forCombat().ignoreLineOfSight().range((double)range).selector(pred), livingOwner, livingOwner.getX(), livingOwner.getY(), livingOwner.getZ(), new AABB(-10.0, -10.0, -10.0, 10.0, 10.0, 10.0).move(livingOwner.position()));
        }
        return null;
    }

    public static void playSoundForPlayer(ServerPlayer player, SoundEvent event, float volume, float pitch) {
        EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)event), player.getSoundSource(), volume, pitch);
    }

    public static void playSoundForPlayer(ServerPlayer player, SoundEvent event, SoundSource source, float volume, float pitch) {
        EntityUtils.playSoundForPlayer(player, (Holder<SoundEvent>)BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)event), source, volume, pitch);
    }

    public static void playSoundForPlayer(ServerPlayer player, Holder<SoundEvent> event, float volume, float pitch) {
        player.connection.send((Packet)new ClientboundSoundPacket(event, player.getSoundSource(), player.getX(), player.getY(), player.getZ(), volume, pitch, player.getRandom().nextLong()));
    }

    public static void playSoundForPlayer(ServerPlayer player, Holder<SoundEvent> event, SoundSource source, float volume, float pitch) {
        player.connection.send((Packet)new ClientboundSoundPacket(event, source, player.getX(), player.getY(), player.getZ(), volume, pitch, player.getRandom().nextLong()));
    }

    record WeightedChestTier(TreasureChestSpawnegg.ChestTier tier, int weight, float modifier, int max) {
        int getModifiedWeight(int mod) {
            return Math.min(this.max, (int)((float)this.weight + this.modifier * (float)mod));
        }
    }
}

