/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.advancements.ShopTrigger;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.profession.ShopResult;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    public static void starterItems(Player player) {
        ItemStack broadSword = new ItemStack((ItemLike)RuneCraftoryItems.BROAD_SWORD.get());
        ItemStack hammer = new ItemStack((ItemLike)RuneCraftoryItems.HAMMER_SCRAP.get());
        ItemUtils.spawnItemAtEntity((LivingEntity)player, broadSword);
        ItemUtils.spawnItemAtEntity((LivingEntity)player, hammer);
    }

    public static void spawnItemAtEntity(LivingEntity entity, ItemStack stack) {
        ItemUtils.spawnItemAt(entity.level(), entity.blockPosition(), stack, entity);
    }

    public static void spawnItemAt(Level level, BlockPos pos, ItemStack stack, @Nullable LivingEntity entity) {
        if (!level.isClientSide) {
            ItemEntity item = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            item.setPickUpDelay(0);
            if (entity != null) {
                item.setThrower((Entity)entity);
            }
            level.addFreshEntity((Entity)item);
        }
    }

    public static void spawnLeveledItem(LivingEntity entity, ItemStack stack, int level) {
        if (!entity.level().isClientSide) {
            ItemEntity item = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), ItemComponentUtils.getLeveledItem(stack, level));
            item.setPickUpDelay(0);
            entity.level().addFreshEntity((Entity)item);
        }
    }

    public static int getSellPrice(ItemStack stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).map(stat -> ItemUtils.getSellPrice(stack, stat)).orElse(0);
    }

    public static int getSellPrice(ItemStack stack, ItemStat stat) {
        return stat.getSell() * ItemComponentUtils.itemLevel(stack);
    }

    public static int getBuyPrice(ItemStack stack) {
        return DataPackHandler.INSTANCE.itemStatManager().get(stack.getItem()).map(stat -> ItemUtils.getBuyPrice(stack, stat)).orElse(0);
    }

    public static ShopResult buyItem(Player player, NPCEntity npc, ItemStack stack) {
        if (ItemUtils.sizeInv(player.getInventory(), stack) < stack.getCount()) {
            player.playSound((SoundEvent)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
            return ShopResult.NOSPACE;
        }
        int price = ItemUtils.getBuyPrice(stack) * stack.getCount();
        if (((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).useMoney(price)) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((ShopTrigger)((Object)RuneCraftoryCriteria.SHOP_TRIGGER.get())).trigger(serverPlayer, npc, stack);
            }
            player.playSound((SoundEvent)RuneCraftorySounds.GENERIC_SUCCESS.get(), 1.0f, 1.0f);
            while (stack.getCount() > 0) {
                ItemStack copy = stack.copy();
                int count = Math.min(stack.getCount(), stack.getMaxStackSize());
                copy.setCount(count);
                ItemUtils.spawnItemAtEntity((LivingEntity)player, copy);
                stack.setCount(stack.getCount() - count);
            }
            return ShopResult.SUCCESS;
        }
        player.playSound((SoundEvent)RuneCraftorySounds.GENERIC_DENY.get(), 1.0f, 1.0f);
        return ShopResult.NOMONEY;
    }

    private static int sizeInv(Inventory playerInv, ItemStack stack) {
        int amount = 0;
        for (ItemStack iStack : playerInv.items) {
            if (iStack.isEmpty()) {
                amount += stack.getMaxStackSize();
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)iStack)) continue;
            amount += stack.getMaxStackSize() - iStack.getCount();
        }
        return amount;
    }

    public static int getBuyPrice(ItemStack stack, ItemStat stat) {
        return stat.getBuy();
    }
}

