/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import com.google.common.collect.Lists;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.config.DistanceZoningConfig;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class LevelCalc {
    public static int getMoney(int base, int level) {
        return base;
    }

    public static void addXP(LivingEntity attacker, int base, int money, int level) {
        LevelCalc.addXP(attacker, base, money, level, true);
    }

    public static void addXP(LivingEntity attacker, int base, int money, int level, boolean adjustOnLevel) {
        NPCEntity npc;
        OwnableEntity ownable;
        LivingEntity livingEntity;
        if (GeneralConfig.xpMultiplier == 0.0f) {
            return;
        }
        ServerPlayer player = null;
        if (attacker instanceof ServerPlayer) {
            ServerPlayer sP;
            player = sP = (ServerPlayer)attacker;
        } else if (attacker instanceof OwnableEntity && (livingEntity = (ownable = (OwnableEntity)attacker).getOwner()) instanceof ServerPlayer) {
            ServerPlayer sP;
            player = sP = (ServerPlayer)livingEntity;
        } else if (attacker instanceof NPCEntity && (livingEntity = (npc = (NPCEntity)attacker).followEntity()) instanceof ServerPlayer) {
            ServerPlayer sP;
            player = sP = (ServerPlayer)livingEntity;
        }
        if (player != null) {
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            data.addXp(adjustOnLevel ? LevelCalc.levelXpWith(base, data.getPlayerLevel().getLevel(), level) : (float)base);
            data.setMoney(data.getMoney() + LevelCalc.getMoney(money, level));
            if (!(attacker instanceof Player)) {
                LevelCalc.tryAddXPTo(attacker, player, base, level, adjustOnLevel);
            }
            for (Mob e2 : player.level().getEntities(EntityTypeTest.forClass(Mob.class), player.getBoundingBox().inflate(32.0, 32.0, 32.0), e -> true)) {
                if (e2 == attacker) continue;
                LevelCalc.tryAddXPTo((LivingEntity)e2, player, base, level, adjustOnLevel);
            }
        }
    }

    private static void tryAddXPTo(LivingEntity entity, ServerPlayer player, int base, int level, boolean adjustOnLevel) {
        if (entity instanceof IBaseMob) {
            IBaseMob mob = (IBaseMob)entity;
            Consumer<Float> cons = null;
            if (entity instanceof BaseMonster) {
                BaseMonster monster = (BaseMonster)entity;
                if (player.getUUID().equals(monster.getOwnerUUID()) && monster.behaviourState() == BaseMonster.Behaviour.FOLLOW) {
                    cons = monster::addXp;
                }
            }
            if (entity instanceof NPCEntity) {
                NPCEntity npc = (NPCEntity)entity;
                if (player.getUUID().equals(npc.getEntityToFollowUUID())) {
                    cons = npc::addXp;
                }
            }
            if (cons == null) {
                return;
            }
            cons.accept(Float.valueOf(adjustOnLevel ? LevelCalc.levelXpWith(base, mob.xpLevel().getLevel(), level) : (float)base));
        }
    }

    private static float levelXpWith(int base, int level, int targetLevel) {
        float xp = ((float)base + (float)(base * (level - 1)) * 0.5f) * GeneralConfig.xpMultiplier;
        if (level <= targetLevel) {
            return xp;
        }
        int diff = level - targetLevel;
        return xp * Math.max(0.01f, 1.0f - (float)diff * 0.075f) * GeneralConfig.xpMultiplier;
    }

    public static void levelSkill(PlayerData data, Skills skill, float amount) {
        if (GeneralConfig.skillXpMultiplier == 0.0f) {
            return;
        }
        data.increaseSkill(skill, skill.getProperties().xpMultiplier() * amount * GeneralConfig.skillXpMultiplier);
    }

    public static GateLevelResult levelFromPos(ServerLevel level, Vec3 pos) {
        List<ServerPlayer> nearby = LevelCalc.playersAround((EntityGetter)level, pos, 256.0);
        return new GateLevelResult(LevelCalc.levelFromPos(level, pos, nearby), nearby);
    }

    public static int levelFromPos(ServerLevel level, Vec3 pos, List<ServerPlayer> list) {
        return Math.max(1, switch (MobConfig.gateLevelType) {
            default -> throw new MatchException(null, null);
            case MobConfig.GateLevelType.CONSTANT -> LevelCalc.randomizedLevel(level.random, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, null));
            case MobConfig.GateLevelType.DISTANCESPAWN -> LevelCalc.randomizedLevel(level.random, LevelCalc.getLevelFor(MobConfig.baseGateLevel + LevelCalc.distanceLevelFrom((Level)level, pos, level.getSharedSpawnPos()), list, null));
            case MobConfig.GateLevelType.DISTANCESPAWNPLAYER -> LevelCalc.randomizedLevel(level.random, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, (player, d) -> {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BlockPos center = serverPlayer.getRespawnDimension() != level.dimension() || serverPlayer.getRespawnPosition() == null ? level.getSharedSpawnPos() : serverPlayer.getRespawnPosition();
                return LevelCalc.distanceLevelFrom((Level)level, pos, center);
            }));
            case MobConfig.GateLevelType.PLAYERLEVEL -> LevelCalc.randomizedLevel(level.random, LevelCalc.getLevelFor(MobConfig.baseGateLevel, list, (p, d) -> d.getPlayerLevel().getLevel()));
        });
    }

    private static int getLevelFor(int base, List<ServerPlayer> list, ToIntBiFunction<Player, PlayerData> levelFunc) {
        if (levelFunc == null && !MobConfig.playerLevelType.increased) {
            return base;
        }
        if (list.isEmpty()) {
            return base;
        }
        int lvl = 0;
        boolean mean = MobConfig.playerLevelType.mean;
        for (Player player : list) {
            int pL;
            PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
            int n = pL = levelFunc != null ? levelFunc.applyAsInt(player, data) : 0;
            if (MobConfig.playerLevelType.increased) {
                pL += data.getMobLevelIncrease();
            }
            if (mean) {
                lvl += pL;
                continue;
            }
            if (pL <= lvl) continue;
            lvl = pL;
        }
        lvl = mean ? lvl / list.size() : lvl;
        return base + lvl;
    }

    private static int distanceLevelFrom(Level level, Vec3 pos, BlockPos center) {
        Vec3 spawn = Vec3.atCenterOf((Vec3i)center);
        double dX = spawn.x - pos.x;
        double dZ = spawn.z - pos.z;
        double dist = Math.sqrt(dX * dX + dZ * dZ);
        Pair<Float, DistanceZoningConfig.Zone> zone = MobConfig.levelZones.get((float)dist);
        return LevelCalc.randomizedLevel(level.random, (int)((double)((DistanceZoningConfig.Zone)zone.getRight()).start() + (dist - (double)((Float)zone.getLeft()).floatValue()) * (double)((DistanceZoningConfig.Zone)zone.getRight()).increasePerBlock()));
    }

    public static List<ServerPlayer> playersAround(EntityGetter getter, Vec3 pos, double radius) {
        ArrayList list = Lists.newArrayList();
        for (Player player : getter.players()) {
            if (!EntitySelector.NO_SPECTATORS.test(player) || !EntitySelector.LIVING_ENTITY_STILL_ALIVE.test(player) || !(player instanceof ServerPlayer)) continue;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!player.position().closerThan((Position)pos, radius)) continue;
            list.add(serverPlayer);
        }
        return list;
    }

    public static int randomizedLevel(RandomSource random, int level) {
        return level + Math.round((float)((random.nextDouble() * 2.0 - 1.0) * Math.ceil((double)level * 0.15)));
    }

    public static boolean useRP(PlayerData data, float amount, boolean hurt, float percent, boolean mean, Skills ... skills) {
        int skillVal = 0;
        if (skills.length == 0) {
            skillVal = 1;
        } else if (skills.length == 1) {
            skillVal = data.getSkillLevel(skills[0]).getLevel();
        } else if (mean) {
            float l = skills.length;
            float sLvl = 0.0f;
            for (Skills skill : skills) {
                sLvl += (float)data.getSkillLevel(skill).getLevel();
            }
            skillVal = (int)(sLvl / l);
        } else {
            for (Skills skill : skills) {
                int lvl = data.getSkillLevel(skill).getLevel();
                if (lvl <= skillVal) continue;
                skillVal = lvl;
            }
        }
        float skillReduction = Math.max(1.0f - (float)(skillVal - 1) * 0.0065f, 0.3f);
        float val = amount * skillReduction;
        float percentAmount = percent > 0.0f ? (float)data.getMaxRunePoints() * percent * skillReduction : 0.0f;
        val = Math.max(percentAmount, val);
        int usage = Mth.ceil((float)val);
        return data.useRunePoints(usage, hurt);
    }

    public static float getIntervalledMultiplier(int level, int interval, float max, float increase) {
        if ((level -= interval) <= 0 || increase == 0.0f) {
            return 0.0f;
        }
        int full = level / interval;
        int rest = level % interval;
        float multiplier = 0.0f;
        for (int i = 1; i <= full; ++i) {
            multiplier += (float)interval * Math.min(max, (float)i * increase);
        }
        return multiplier += (float)rest * Math.min(max, (float)(1 + full) * increase);
    }

    @Nullable
    public static Skills getSkillFromElement(ItemElement element) {
        return switch (element) {
            case ItemElement.WATER -> Skills.WATER;
            case ItemElement.EARTH -> Skills.EARTH;
            case ItemElement.WIND -> Skills.WIND;
            case ItemElement.FIRE -> Skills.FIRE;
            case ItemElement.LIGHT -> Skills.LIGHT;
            case ItemElement.DARK -> Skills.DARK;
            case ItemElement.LOVE -> Skills.LOVE;
            default -> null;
        };
    }

    public record GateLevelResult(int level, List<ServerPlayer> nearby) {
    }
}

