/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.utils;

import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.AdvancedProjectile;
import io.github.flemmli97.tenshilib.common.entity.BeamEntity;
import io.github.flemmli97.tenshilib.common.entity.ai.TargetPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class ProjectileUtils {
    public static void shoot(LivingEntity shooter, AdvancedProjectile projectile, float velocity, float inaccuracy) {
        Vec3 target = ProjectileUtils.getAimTarget(shooter, projectile.position());
        if (target != null) {
            projectile.shootAtPosition(target.x(), target.y(), target.z(), velocity, inaccuracy);
        } else {
            projectile.shoot((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, velocity, inaccuracy);
        }
    }

    public static void shoot(LivingEntity shooter, BeamEntity beam, float inaccuracy) {
        Mob mob;
        MobAttackExt ext;
        TargetPosition target;
        if (shooter instanceof MobAttackExt && (target = (ext = (MobAttackExt)shooter).getTargetPosition()) != null) {
            Vec3 v = target.asVec(beam.position());
            beam.setRotationTo(v.x(), v.y(), v.z(), inaccuracy);
        } else if (shooter instanceof Mob && (mob = (Mob)shooter).getTarget() != null) {
            beam.setRotationTo((Entity)mob.getTarget(), inaccuracy);
        } else {
            beam.setYRot((shooter.yHeadRot - 180.0f) % 360.0f);
            beam.setXRot(shooter.getXRot() % 360.0f);
        }
    }

    public static Vec3 getAimTarget(LivingEntity shooter) {
        return ProjectileUtils.getAimTarget(shooter, (double)shooter.getEyeHeight() - 0.1);
    }

    public static Vec3 getAimTarget(LivingEntity shooter, Vec3 from) {
        return ProjectileUtils.getAimTarget(shooter, from.y() - shooter.getY());
    }

    public static Vec3 getAimTarget(LivingEntity shooter, double offset) {
        Mob mob;
        MobAttackExt ext;
        TargetPosition target;
        if (shooter instanceof MobAttackExt && (target = (ext = (MobAttackExt)shooter).getTargetPosition()) != null) {
            return target.asVec(shooter.position().add(0.0, offset, 0.0));
        }
        if (shooter instanceof Mob && (mob = (Mob)shooter).getTarget() != null) {
            return EntityUtils.getStraightProjectileTarget(shooter.position(), (Entity)mob.getTarget());
        }
        return null;
    }
}

