/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.datapack.ReloadableHolder;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class NPCHandler {
    private final Map<UUID, Component> npcs = new HashMap<UUID, Component>();
    private final Map<ResourceLocation, Set<UUID>> uniqueNPCS = new HashMap<ResourceLocation, Set<UUID>>();
    private final Map<UUID, Set<Pair<UUID, ResourceLocation>>> resetQuestNPCS = new HashMap<UUID, Set<Pair<UUID, ResourceLocation>>>();

    public boolean doesNPCExist(UUID uuid) {
        return this.npcs.containsKey(uuid);
    }

    public void addNPC(NPCEntity npc) {
        this.npcs.put(npc.getUUID(), npc.getName());
    }

    public Component getName(UUID uuid) {
        return this.npcs.get(uuid);
    }

    public void removeNPC(NPCEntity npc, Entity.RemovalReason reason) {
        if (reason.shouldDestroy()) {
            npc.getServer().getPlayerList().getPlayers().forEach(p -> QuestHandler.removeQuestFor(p, npc));
            npc.getFamily().markAsDead();
            this.npcs.remove(npc.getUUID());
        } else {
            this.npcs.put(npc.getUUID(), npc.getName());
        }
    }

    public boolean canAssignNPC(ReloadableHolder<NPCData> data) {
        if (data.value().unique() == 0) {
            return true;
        }
        Set<UUID> uuids = this.uniqueNPCS.get(data.id());
        return uuids == null || uuids.size() < data.value().unique();
    }

    public boolean addUniqueNPC(UUID uuid, ReloadableHolder<NPCData> data) {
        if (data.value().unique() == 0) {
            return false;
        }
        return this.uniqueNPCS.computeIfAbsent(data.id(), key -> new HashSet()).add(uuid);
    }

    public boolean removeUniqueNPC(UUID uuid, ReloadableHolder<NPCData> data) {
        if (data.value().unique() == 0) {
            return false;
        }
        return this.uniqueNPCS.computeIfAbsent(data.id(), key -> new HashSet()).remove(uuid);
    }

    public void scheduleQuestTrackerReset(UUID npc, UUID player, ResourceLocation quest) {
        this.resetQuestNPCS.computeIfAbsent(npc, key -> new HashSet()).add(Pair.of((Object)player, (Object)quest));
    }

    public Set<Pair<UUID, ResourceLocation>> playersToReset(UUID npc) {
        return this.resetQuestNPCS.getOrDefault(npc, new HashSet());
    }

    public CompoundTag save(HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag tag = new CompoundTag();
        CompoundTag npcs = new CompoundTag();
        this.npcs.forEach((arg_0, arg_1) -> NPCHandler.lambda$save$4(npcs, (DynamicOps)ops, arg_0, arg_1));
        tag.put("NPCs", (Tag)npcs);
        CompoundTag uniques = new CompoundTag();
        this.uniqueNPCS.forEach((res, ids) -> {
            ListTag idTag = new ListTag();
            ids.forEach(uuid -> idTag.add((Object)StringTag.valueOf((String)uuid.toString())));
            uniques.put(res.toString(), (Tag)idTag);
        });
        tag.put("UniqueNPCs", (Tag)uniques);
        CompoundTag resetQuestTracker = new CompoundTag();
        this.resetQuestNPCS.forEach((uuid, ids) -> {
            CompoundTag pairs = new CompoundTag();
            ids.forEach(pair -> pairs.putString(((UUID)pair.getFirst()).toString(), ((ResourceLocation)pair.getSecond()).toString()));
            resetQuestTracker.put(uuid.toString(), (Tag)pairs);
        });
        tag.put("ResetQuestNPCs", (Tag)resetQuestTracker);
        return tag;
    }

    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag npcs = tag.getCompound("NPCs");
        npcs.getAllKeys().forEach(arg_0 -> this.lambda$load$9((DynamicOps)ops, npcs, arg_0));
        CompoundTag uniques = tag.getCompound("UniqueNPCs");
        uniques.getAllKeys().forEach(key -> {
            ListTag idTag = uniques.getList(key, 8);
            this.uniqueNPCS.put(ResourceLocation.parse((String)key), idTag.stream().map(t -> UUID.fromString(t.getAsString())).collect(Collectors.toSet()));
        });
        CompoundTag resetQuestTracker = tag.getCompound("ResetQuestNPCs");
        resetQuestTracker.getAllKeys().forEach(key -> {
            CompoundTag pairs = resetQuestTracker.getCompound(key);
            this.resetQuestNPCS.put(UUID.fromString(key), pairs.getAllKeys().stream().map(t -> Pair.of((Object)UUID.fromString(t), (Object)ResourceLocation.parse((String)pairs.getString(t)))).collect(Collectors.toSet()));
        });
    }

    private /* synthetic */ void lambda$load$9(DynamicOps ops, CompoundTag npcs, String key) {
        this.npcs.put(UUID.fromString(key), (Component)ComponentSerialization.CODEC.parse(ops, (Object)npcs.get(key)).getOrThrow());
    }

    private static /* synthetic */ void lambda$save$4(CompoundTag npcs, DynamicOps ops, UUID uuid, Component comp) {
        npcs.put(uuid.toString(), (Tag)ComponentSerialization.CODEC.encodeStart(ops, (Object)comp).getOrThrow());
    }
}

