/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data;

import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NPCSpawner
implements CustomSpawner {
    private int cooldown = 1200;

    public int tick(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!level.getServer().isSpawningAnimals() || !level.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            return 0;
        }
        if (--this.cooldown > 0) {
            return 0;
        }
        int cooldown = level.getRandom().nextInt(MobConfig.npcSpawnRateMax - MobConfig.npcSpawnRateMin) + MobConfig.npcSpawnRateMin;
        if (this.doSpawning(level)) {
            this.cooldown = cooldown;
            return 1;
        }
        this.cooldown = (int)((double)cooldown * 0.5);
        return 0;
    }

    private boolean doSpawning(ServerLevel level) {
        ServerPlayer player = level.getRandomPlayer();
        if (player == null || player.isSpectator()) {
            return false;
        }
        BlockPos blockPos = player.blockPosition();
        for (int i = 0; i < 10; ++i) {
            float f = level.random.nextFloat() * (float)Math.PI * 2.0f;
            int x = blockPos.getX() + Mth.floor((float)(Mth.cos((float)f) * 32.0f));
            int z = blockPos.getZ() + Mth.floor((float)(Mth.sin((float)f) * 32.0f));
            Vec3 pos = this.findRandomSpawnPos(level, new BlockPos(x, blockPos.getY(), z));
            if (pos == null) continue;
            this.trySpawn(level, pos.x, pos.y, pos.z);
            return true;
        }
        return false;
    }

    private void trySpawn(ServerLevel level, double x, double y, double z) {
        NPCEntity npc = new NPCEntity((EntityType<? extends NPCEntity>)((EntityType)RuneCraftoryEntities.NPC.get()), (Level)level);
        npc.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(npc.blockPosition()), MobSpawnType.EVENT, null);
        npc.moveTo(x, y, z, level.random.nextFloat() * 360.0f, 0.0f);
        level.addFreshEntityWithPassengers((Entity)npc);
    }

    @Nullable
    private Vec3 findRandomSpawnPos(ServerLevel level, BlockPos pos) {
        for (int i = 0; i < 10; ++i) {
            int z;
            int x = pos.getX() + level.random.nextInt(16) - 8;
            BlockPos blockPos = new BlockPos(x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = pos.getZ() + level.random.nextInt(16) - 8), z);
            if (!level.isVillage(blockPos) || level.getEntities(EntityTypeTest.forClass(NPCEntity.class), new AABB(blockPos).inflate(64.0), e -> true).size() > 3 || level.getEntities(EntityTypeTest.forClass(Villager.class), new AABB(blockPos).inflate(48.0), e -> true).size() < 5) continue;
            return Vec3.atBottomCenterOf((Vec3i)blockPos);
        }
        return null;
    }
}

