/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.data.farming;

import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.blocks.HerbBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.Growable;
import io.github.flemmli97.runecraftory.common.blocks.util.GrowableCrop;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.utils.GrassRegrowUtil;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandDataContainer;
import io.github.flemmli97.runecraftory.common.world.data.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FarmlandData {
    public static final float DEFAULT_SPEED = 1.0f;
    public static final float DEFAULT_QUALITY = 0.0f;
    public static final float DEFAULT_SIZE = 0.0f;
    public static final int DEFAULT_DEFENCE = 0;
    public static final int DEFAULT_HEALTH = 64;
    public static final float MAX_SPEED = 5.0f;
    public static final float MAX_QUALITY = 2.0f;
    public static final float MAX_SIZE = 2.0f;
    public static final int MAX_DEFENCE = 64;
    public static final int MAX_HEALTH = 255;
    public final BlockPos pos;
    private float growth = 1.0f;
    private float quality = 0.0f;
    private float size = 0.0f;
    private int health = 64;
    private int defence = 0;
    private float cropAge;
    private float cropSize;
    private float cropLevel = 1.0f;
    private int cropProgress;
    private int lastUpdateDay;
    private int scheduledStormTicks;
    private int scheduledWatering;
    private int lastWeatherDay;
    private final List<ExternalModifiers> scheduledData = new ArrayList<ExternalModifiers>();
    private boolean isLoaded;
    private boolean isFarmBlock;
    private boolean isGrowing;

    public FarmlandData(BlockPos pos) {
        this.pos = pos;
    }

    public static FarmlandData fromTag(CompoundTag tag, BlockPos pos) {
        FarmlandData data = new FarmlandData(pos);
        data.load(tag);
        return data;
    }

    public float getGrowth() {
        return this.growth;
    }

    public void applyGrowthFertilizer(@Nullable ServerLevel level, float amount) {
        this.growth = Mth.clamp((float)(this.growth + amount), (float)0.1f, (float)5.0f);
        if (level != null) {
            FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        }
    }

    public boolean canUseBonemeal() {
        return (double)this.growth < 2.25;
    }

    public void applyBonemeal(@Nullable ServerLevel level) {
        if ((double)this.growth < 2.25) {
            this.applyGrowthFertilizer(level, Math.min(2.25f - this.growth, 0.15f));
        }
    }

    public float getQuality() {
        return this.quality;
    }

    public void modifyQuality(@Nullable ServerLevel level, float amount) {
        this.quality = Mth.clamp((float)(this.quality + amount), (float)0.0f, (float)2.0f);
        if (level != null) {
            FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        }
    }

    public float getSize() {
        return this.size;
    }

    public void applySizeFertilizer(@Nullable ServerLevel level, boolean growGiant) {
        float mod = growGiant ? 1 : -1;
        this.size = Mth.clamp((float)(this.size + mod), (float)-2.0f, (float)2.0f);
        if (level != null) {
            FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        }
    }

    public int getHealth() {
        return this.health;
    }

    public void modifyHealth(@Nullable ServerLevel level, int amount) {
        this.health = Mth.clamp((int)(this.health + amount), (int)0, (int)255);
        if (level != null) {
            FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        }
    }

    public int getDefence() {
        return this.defence;
    }

    public void modifyDefence(@Nullable ServerLevel level, int amount) {
        this.defence = Mth.clamp((int)(this.defence + amount), (int)0, (int)64);
        if (level != null) {
            FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        }
    }

    public float getCropAge() {
        return (int)this.cropAge;
    }

    private int growthPercent(ServerLevel level, BlockState crop) {
        if (!(crop.getBlock() instanceof Growable)) {
            return 0;
        }
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(crop.getBlock());
        if (props != null) {
            return Math.min((int)(this.cropAge / (float)props.growth() * 100.0f), 100);
        }
        return 0;
    }

    public float getCropSize() {
        return this.cropSize;
    }

    public int getCropLevel() {
        return (int)this.cropLevel;
    }

    public boolean hasDefaultStats() {
        return this.growth == 1.0f && this.quality == 0.0f && this.size == 0.0f && this.health == 64;
    }

    protected void updateFarmBlock(boolean isFarmBlock) {
        this.isFarmBlock = isFarmBlock;
    }

    public boolean isFarmBlock() {
        return this.isFarmBlock;
    }

    public boolean shouldBeRemoved() {
        if (this.isFarmBlock) {
            return false;
        }
        return this.hasDefaultStats();
    }

    public void onRegrowableHarvest(ServerLevel level, BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (!(block instanceof Growable)) {
            this.resetCrop();
            return;
        }
        Growable crop = (Growable)block;
        CropProperties props = DataPackHandler.INSTANCE.cropManager().get(state.getBlock());
        if (props == null || !props.regrowable() || this.getHealth() <= 0) {
            this.resetCrop();
            return;
        }
        float max = props.growth();
        this.cropAge = max * 0.5f;
        int maxAge = crop.runecraftory$getGrowableMaxAge();
        int stage = Math.round(this.cropAge * (float)maxAge) / props.growth();
        BlockState newState = crop.runecraftory$getGrowableStateForAge(state, Math.min(stage, maxAge));
        level.getServer().tell((Runnable)new TickTask(1, () -> {
            this.isGrowing = true;
            level.setBlock(pos, newState, 3);
            this.isGrowing = false;
        }));
        this.cropProgress = this.growthPercent(level, state);
        this.modifyHealth(null, -3);
        FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
    }

    public void onCropRemove(ServerLevel level, BlockPos pos, BlockState state) {
        if (!this.isGrowing) {
            this.resetCrop();
            FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        }
    }

    public void onWatering(ServerLevel level, int currentDay) {
        if (!this.isFarmBlock || this.lastWeatherDay == currentDay) {
            return;
        }
        this.lastWeatherDay = currentDay;
        if (!this.isLoaded) {
            ++this.scheduledWatering;
            return;
        }
        BlockState farm = level.getBlockState(this.pos);
        if ((Integer)farm.getValue((Property)FarmBlock.MOISTURE) < 7) {
            level.setBlock(this.pos, (BlockState)farm.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7)), 3);
        }
    }

    public void onStorming(ServerLevel level, int currentDay) {
        if (!this.isFarmBlock || this.lastWeatherDay == currentDay) {
            return;
        }
        if (!this.isLoaded) {
            this.onWatering(level, currentDay);
            ++this.scheduledStormTicks;
            return;
        }
        this.onWatering(level, currentDay);
        this.doStormingLogic(level, 1);
    }

    private void doStormingLogic(ServerLevel level, int amount) {
        if (!this.isFarmBlock) {
            return;
        }
        BlockState state = null;
        BlockPos cropPos = this.pos.above();
        for (int i = 0; i < amount; ++i) {
            boolean destroyChance;
            --this.defence;
            if (this.defence > 0) continue;
            state = state == null ? level.getBlockState(cropPos) : state;
            boolean bl = destroyChance = level.random.nextFloat() < 0.4f;
            if (!destroyChance) continue;
            if (state.getBlock() instanceof Growable) {
                if (level.random.nextFloat() < 0.6f) {
                    state = Blocks.AIR.defaultBlockState();
                    level.destroyBlock(cropPos, true);
                    continue;
                }
                state = ((HerbBlock)((Object)RuneCraftoryBlocks.WITHERED_GRASS.get())).defaultBlockState();
                continue;
            }
            state = Blocks.DIRT.defaultBlockState();
            break;
        }
        FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        if (state != null) {
            if (state.getBlock() == Blocks.DIRT) {
                level.setBlock(this.pos, state, 3);
            } else if (state.getBlock() == Blocks.AIR) {
                level.destroyBlock(cropPos, true);
            } else {
                level.setBlock(cropPos, state, 3);
            }
        }
    }

    public void tick(ServerLevel level, boolean onLoad) {
        Block block;
        if (!this.isLoaded && !GeneralConfig.tickUnloadedFarmland) {
            return;
        }
        if (!this.isFarmBlock) {
            this.lastUpdateDay = WorldUtils.day((Level)level);
            this.handleNotFarmblock(level);
            return;
        }
        Calendar handler = Calendar.get((Level)level);
        ExternalModifiers ext = new ExternalModifiers(handler.currentSeason(), handler.currentWeather());
        if (!this.isLoaded) {
            this.scheduledData.add(ext);
            return;
        }
        this.lastUpdateDay = WorldUtils.day((Level)level);
        BlockState farm = level.getBlockState(this.pos);
        this.isFarmBlock = FarmlandHandler.isFarmBlock(farm);
        boolean isWet = this.isFarmBlock && (Integer)farm.getValue((Property)FarmBlock.MOISTURE) > 0;
        boolean canRainAt = FarmlandHandler.canRainingAt((Level)level, this.pos);
        if (!onLoad) {
            this.scheduledData.add(ext);
        } else {
            this.doStormingLogic(level, this.scheduledStormTicks);
            if (!this.isFarmBlock) {
                this.handleNotFarmblock(level);
                return;
            }
            if (!isWet && canRainAt && this.scheduledWatering > 0 && farm.getBlock() instanceof FarmBlock) {
                --this.scheduledWatering;
                isWet = true;
            }
        }
        boolean ignoreWater = FarmlandHandler.get(level.getServer()).hasWater(level, this.pos);
        if (ignoreWater) {
            isWet = true;
        }
        BlockPos cropPos = this.pos.above();
        BlockState cropState = level.getBlockState(cropPos);
        ArrayList<Runnable> run = new ArrayList<Runnable>();
        if (isWet) {
            run.add(() -> level.setBlock(this.pos, (BlockState)farm.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(0)), 3));
        }
        boolean growHerb = false;
        boolean cropRecalc = false;
        CropProperties props = cropState.getBlock() instanceof Growable ? DataPackHandler.INSTANCE.cropManager().get(cropState.getBlock()) : null;
        int wiltStage = 0;
        for (ExternalModifiers modifiers : this.scheduledData) {
            boolean hasGiantVersion;
            Block block2 = cropState.getBlock();
            if (!(block2 instanceof Growable)) {
                this.normalizeLand();
                this.resetCrop();
                if (!growHerb && cropState.isAir()) {
                    if ((double)level.random.nextFloat() < 0.02) {
                        run.add(() -> GrassRegrowUtil.tryGrowHerb(level, cropPos));
                        growHerb = true;
                    } else {
                        growHerb = true;
                    }
                }
                if (!growHerb || !this.hasDefaultStats()) continue;
                break;
            }
            Growable crop = (Growable)block2;
            boolean bl = hasGiantVersion = props != null && props.getGiantVersion().map(g -> !cropState.is(g)).orElse(false) != false;
            if (!crop.canGrow(level, cropPos, cropState) && (!hasGiantVersion || this.size == 0.0f || this.size < 0.0f && this.cropSize <= 0.0f)) break;
            boolean didCropGrow = false;
            boolean maxAgeStop = false;
            if (props != null) {
                if (!cropRecalc) {
                    cropRecalc = true;
                    if (crop.canGrow(level, cropPos, cropState)) {
                        run.add(() -> {
                            int maxAge = crop.runecraftory$getGrowableMaxAge();
                            int stage = Mth.floor((float)(this.cropAge * (float)maxAge / (float)props.growth()));
                            BlockState newState = crop.runecraftory$getGrowableStateForAge(cropState, Math.min(stage, maxAge));
                            this.isGrowing = true;
                            Block patt0$temp = newState.getBlock();
                            if (patt0$temp instanceof Growable) {
                                Growable newGrowable = (Growable)patt0$temp;
                                newGrowable.onGrow(level, cropPos, newState, cropState);
                            } else {
                                level.setBlock(cropPos, newState, 3);
                            }
                            this.isGrowing = false;
                            Platform.INSTANCE.cropGrowEventPost((Level)level, cropPos, level.getBlockState(cropPos));
                        });
                    } else {
                        run.add(() -> CropUtils.attemptGiantize(level, cropPos, crop, cropState, this.cropSize, props));
                    }
                }
                if (!isWet) {
                    float mod = (255.0f - (float)this.getHealth()) / 255.0f + 0.2f;
                    float chance = mod * GeneralConfig.witherChance;
                    if (level.random.nextFloat() < chance && !(cropState.getBlock() instanceof GrowableCrop) && ++wiltStage > 1) break;
                }
                float season = props.seasonMultiplier(modifiers.season);
                float runeyBonus = modifiers.weather == Weather.RUNEY ? 5.0f : 1.0f;
                float speed = this.growth * season * runeyBonus;
                if (!isWet) {
                    speed *= 0.5f;
                }
                this.cropAge += Math.min((float)props.growth(), speed);
                this.cropLevel += this.quality * (level.getRandom().nextFloat() * 0.5f + 0.5f);
                if (crop.runecraftory$isAtMaxAge(cropState) && hasGiantVersion) {
                    if (this.size != 0.0f) {
                        this.cropSize += this.size * (level.getRandom().nextFloat() * 0.2f + 0.1f);
                        didCropGrow = this.size > 0.0f ? this.cropSize < 1.0f : this.cropSize > 0.0f;
                    }
                } else {
                    didCropGrow = true;
                }
                if (!didCropGrow) {
                    maxAgeStop = true;
                }
            }
            if (!ignoreWater && canRainAt) {
                isWet = this.scheduledWatering > 0;
            }
            this.scheduledWatering = Math.max(0, --this.scheduledWatering);
            if (didCropGrow) {
                if (level.random.nextInt(3) != 0) {
                    this.modifyHealth(null, -1);
                }
                if (level.random.nextBoolean()) {
                    this.applyGrowthFertilizer(null, this.growth > 1.0f ? -0.1f : -0.05f);
                }
                if (level.random.nextBoolean()) {
                    this.modifyQuality(null, -0.05f);
                }
            } else {
                this.normalizeLand();
            }
            if (!maxAgeStop) continue;
            break;
        }
        this.resetScheduledData();
        run.forEach(Runnable::run);
        if (wiltStage > 0 && (block = cropState.getBlock()) instanceof GrowableCrop) {
            GrowableCrop blockCrop = (GrowableCrop)block;
            blockCrop.onWither(wiltStage, (Level)level, cropState, cropPos);
        }
        this.cropProgress = this.growthPercent(level, cropState);
        FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
    }

    private void handleNotFarmblock(ServerLevel level) {
        this.normalizeLand();
        this.resetCrop();
        FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
        this.resetScheduledData();
    }

    private void resetScheduledData() {
        this.scheduledData.clear();
        this.scheduledWatering = 0;
        this.scheduledStormTicks = 0;
    }

    private void normalizeLand() {
        this.growth = this.growth > 1.0f ? Math.max(this.growth - 0.1f, 1.0f) : Math.min(this.growth + 0.1f, 1.0f);
        this.modifyQuality(null, -0.1f);
        this.size = Mth.clamp((float)(this.size - 0.05f), (float)0.0f, (float)2.0f);
        this.health = this.health > 64 ? Math.max(this.health - 1, 64) : Math.min(this.health + 1, 64);
    }

    private void resetCrop() {
        this.cropAge = 0.0f;
        this.cropLevel = 1.0f;
        this.cropSize = 0.0f;
        this.cropProgress = 0;
    }

    public void onLoad(ServerLevel level, boolean tick) {
        if (tick && this.lastUpdateDay != WorldUtils.day((Level)level)) {
            level.getServer().tell((Runnable)new TickTask(1, () -> this.tick(level, true)));
        }
        this.isLoaded = true;
    }

    public void onUnload(ServerLevel level) {
        this.isLoaded = false;
        FarmlandHandler.get(level.getServer()).scheduleUpdate(level, this);
    }

    public void load(CompoundTag nbt) {
        this.growth = nbt.getFloat("Growth");
        this.quality = nbt.getFloat("Quality");
        this.size = nbt.getFloat("Size");
        this.defence = nbt.getInt("Defence");
        this.health = nbt.getInt("Health");
        this.cropAge = nbt.getFloat("CropAge");
        this.cropLevel = nbt.getFloat("CropLevel");
        this.cropSize = nbt.getFloat("CropSize");
        this.cropProgress = nbt.getInt("CropProgress");
        this.lastUpdateDay = nbt.getInt("LastUpdate");
        this.lastWeatherDay = nbt.getInt("LastWeatherDay");
        this.scheduledStormTicks = nbt.getInt("ScheduledStormTicks");
        this.scheduledWatering = nbt.getInt("ScheduledWaterAmount");
        ListTag scheduledDataTag = nbt.getList("ScheduledData", 10);
        scheduledDataTag.forEach(t -> {
            CompoundTag lT = (CompoundTag)t;
            this.scheduledData.add(new ExternalModifiers(Season.valueOf(lT.getString("Season")), Weather.valueOf(lT.getString("Weather"))));
        });
        this.isLoaded = nbt.getBoolean("IsLoaded");
        this.isFarmBlock = nbt.getBoolean("IsFarmBlock");
    }

    public CompoundTag save() {
        CompoundTag nbt = new CompoundTag();
        nbt.putFloat("Growth", this.growth);
        nbt.putFloat("Quality", this.quality);
        nbt.putFloat("Size", this.size);
        nbt.putInt("Health", this.health);
        nbt.putInt("Defence", this.defence);
        nbt.putFloat("CropAge", this.cropAge);
        nbt.putFloat("CropLevel", this.cropLevel);
        nbt.putFloat("CropSize", this.cropSize);
        nbt.putInt("CropProgress", this.cropProgress);
        nbt.putInt("LastUpdate", this.lastUpdateDay);
        nbt.putInt("LastWeatherDay", this.lastWeatherDay);
        nbt.putInt("ScheduledStormTicks", this.scheduledStormTicks);
        nbt.putInt("ScheduledWaterAmount", this.scheduledWatering);
        ListTag scheduledDataTag = new ListTag();
        this.scheduledData.forEach(mod -> {
            CompoundTag lT = new CompoundTag();
            lT.putString("Season", mod.season.name());
            lT.putString("Weather", mod.weather.name());
            scheduledDataTag.add((Object)lT);
        });
        nbt.put("ScheduledData", (Tag)scheduledDataTag);
        nbt.putBoolean("IsLoaded", this.isLoaded);
        nbt.putBoolean("IsFarmBlock", this.isFarmBlock);
        return nbt;
    }

    public FarmlandDataContainer forSync() {
        return new FarmlandDataContainer(this.pos, this.growth, this.quality, this.size, this.health, this.defence, this.cropProgress, Math.min(100, (int)this.cropSize * 100), this.cropLevel);
    }

    public String toString() {
        return String.format("Farmland[%s, Loaded:%s, IsFarm:%s]", this.pos, this.isLoaded, this.isFarmBlock);
    }

    public String toStringFull() {
        return String.format("Farmland[%s, Loaded:%s, IsFarm:%s]: Growth:%s;Quality:%s;Size:%s;Health:%s;Defence:%s - Schedules:[StormTicks:%s;Watering:%s], Data: %s", this.pos, this.isLoaded, this.isFarmBlock, Float.valueOf(this.growth), Float.valueOf(this.quality), Float.valueOf(this.size), this.health, this.defence, this.scheduledStormTicks, this.scheduledWatering, this.scheduledData);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FarmlandData) {
            FarmlandData data = (FarmlandData)obj;
            return data.pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    protected record ExternalModifiers(Season season, Weather weather) {
    }
}

