/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.features;

import com.mojang.serialization.Codec;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.world.features.config.ChancedBlockClusterConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluids;

public class MineralFeature
extends Feature<ChancedBlockClusterConfig> {
    public MineralFeature(Codec<ChancedBlockClusterConfig> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<ChancedBlockClusterConfig> ctx) {
        if (((ChancedBlockClusterConfig)ctx.config()).amount().getMaxValue() == 0) {
            return false;
        }
        Holder biome = ctx.level().getBiome(ctx.origin());
        if (!((ChancedBlockClusterConfig)ctx.config()).biomes().test((Holder<Biome>)biome)) {
            return false;
        }
        BlockState state = ((ChancedBlockClusterConfig)ctx.config()).stateProvider().getState(ctx.random(), ctx.origin());
        int amount = ((ChancedBlockClusterConfig)ctx.config()).amount().sample(ctx.random());
        if (amount <= 0) {
            return false;
        }
        for (int i = 0; i < ((ChancedBlockClusterConfig)ctx.config()).tries(); ++i) {
            BlockPos pos = ctx.origin().offset(ctx.random().nextInt(((ChancedBlockClusterConfig)ctx.config()).radius()) - ctx.random().nextInt(((ChancedBlockClusterConfig)ctx.config()).radius()), ctx.random().nextInt(((ChancedBlockClusterConfig)ctx.config()).radius()) - ctx.random().nextInt(((ChancedBlockClusterConfig)ctx.config()).radius()), ctx.random().nextInt(((ChancedBlockClusterConfig)ctx.config()).radius()) - ctx.random().nextInt(((ChancedBlockClusterConfig)ctx.config()).radius()));
            if (!ctx.level().getBlockState(pos).is(BlockTags.REPLACEABLE) || !ctx.level().getBlockState(pos.below()).is(RunecraftoryTags.Blocks.MINERAL_GEN_PLACE) || !state.canSurvive((LevelReader)ctx.level(), pos)) continue;
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(ctx.random()));
            }
            if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(ctx.level().getFluidState(pos).getType() == Fluids.WATER));
            }
            ctx.level().setBlock(pos, state, 3);
            if (--amount == 0) break;
        }
        return true;
    }
}

