/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.world.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryStructures;
import io.github.flemmli97.runecraftory.common.world.structure.FilterHolderSet;
import io.github.flemmli97.runecraftory.common.world.structure.JigsawStructureData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public class ExtendedJigsawStructure
extends Structure {
    public static final MapCodec<ExtendedJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FilterHolderSet.FILTERED_CODEC.forGetter(d -> d.settings), (App)JigsawStructureData.CODEC.forGetter(d -> d.data)).apply((Applicative)instance, ExtendedJigsawStructure::new));
    protected final Structure.StructureSettings settings;
    protected final JigsawStructureData data;

    public ExtendedJigsawStructure(Structure.StructureSettings settings, JigsawStructureData data) {
        super(settings);
        this.settings = settings;
        this.data = data;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        BlockPos blockPos = this.calculatePosition(context);
        if (blockPos == null) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.data.startPool(), this.data.startJigsawName(), (int)this.data.maxDepth(), (BlockPos)blockPos, (boolean)false, this.data.projectStartToHeightmap(), (int)this.data.maxDistanceFromCenter(), (PoolAliasLookup)PoolAliasLookup.create(this.data.poolAliases(), (BlockPos)blockPos, (long)context.seed()), (DimensionPadding)this.data.dimensionPadding(), (LiquidSettings)this.data.liquidSettings());
    }

    protected BlockPos calculatePosition(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        int i = this.data.startHeight().sample((RandomSource)context.random(), new WorldGenerationContext(context.chunkGenerator(), context.heightAccessor()));
        return new BlockPos(chunkPos.getMinBlockX(), i, chunkPos.getMinBlockZ());
    }

    public StructureType<?> type() {
        return (StructureType)RuneCraftoryStructures.EXTENDED_STRUCTURE.get();
    }
}

