/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jei;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.gui.CraftingGui;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.integration.jei.CraftingIdentifier;
import io.github.flemmli97.runecraftory.integration.jei.SextupleRecipeCategory;
import io.github.flemmli97.runecraftory.integration.jei.SextupleRecipeTransfer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEI
implements IModPlugin {
    private static final ResourceLocation ID = RuneCraftory.modRes("jei_integration");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), CraftingIdentifier.FORGING.identifier(), (Item)RuneCraftoryItems.FORGE.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), CraftingIdentifier.COOKING.identifier(), (Item)RuneCraftoryItems.COOKING_TABLE.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), CraftingIdentifier.ARMOR.identifier(), (Item)RuneCraftoryItems.ACCESSORY_WORKBENCH.get()), new SextupleRecipeCategory<SextupleRecipe>(registration.getJeiHelpers().getGuiHelper(), CraftingIdentifier.CHEMISTRY.identifier(), (Item)RuneCraftoryItems.CHEMISTRY_SET.get())});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        reg.addRecipes(CraftingIdentifier.FORGING.identifier(), JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)RuneCraftoryCrafting.FORGE.get()));
        reg.addRecipes(CraftingIdentifier.ARMOR.identifier(), JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)RuneCraftoryCrafting.ARMOR.get()));
        reg.addRecipes(CraftingIdentifier.COOKING.identifier(), JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)RuneCraftoryCrafting.COOKING.get()));
        reg.addRecipes(CraftingIdentifier.CHEMISTRY.identifier(), JEI.sorted(manager, (net.minecraft.world.item.crafting.RecipeType)RuneCraftoryCrafting.CHEMISTRY.get()));
    }

    private static <T extends SextupleRecipe> List<RecipeHolder<T>> sorted(RecipeManager manager, net.minecraft.world.item.crafting.RecipeType<T> type) {
        ArrayList<RecipeHolder<T>> l = new ArrayList<RecipeHolder<T>>(manager.getAllRecipesFor(type));
        l.sort(Comparator.comparingInt(h -> ((SextupleRecipe)h.value()).getCraftingLevel()));
        return l;
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(CraftingIdentifier.FORGING));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(CraftingIdentifier.COOKING));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(CraftingIdentifier.ARMOR));
        registration.addRecipeTransferHandler((IRecipeTransferInfo)new SextupleRecipeTransfer(CraftingIdentifier.CHEMISTRY));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RuneCraftoryItems.FORGE.get()), new RecipeType[]{CraftingIdentifier.FORGING.identifier()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RuneCraftoryItems.ACCESSORY_WORKBENCH.get()), new RecipeType[]{CraftingIdentifier.ARMOR.identifier()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RuneCraftoryItems.COOKING_TABLE.get()), new RecipeType[]{CraftingIdentifier.COOKING.identifier()});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RuneCraftoryItems.CHEMISTRY_SET.get()), new RecipeType[]{CraftingIdentifier.CHEMISTRY.identifier()});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CraftingGui.class, (IGuiContainerHandler)new IGuiContainerHandler<CraftingGui>(this){

            public Collection<IGuiClickableArea> getGuiClickableAreas(CraftingGui gui, double mouseX, double mouseY) {
                RecipeType<RecipeHolder<SextupleRecipe>> type = CraftingIdentifier.get(gui.type()).identifier();
                IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)80, (int)30, (int)26, (int)26, (RecipeType[])new RecipeType[]{type});
                return List.of(clickableArea);
            }
        });
    }

    public static <T> Stream<T> filterLocked(Stream<T> recipes, IRecipeCategory<T> recipeTypeData, IFocusGroup focusGroup) {
        if (CraftingIdentifier.has(recipeTypeData.getRecipeType())) {
            LocalPlayer player = Minecraft.getInstance().player;
            boolean ingredient = focusGroup.getFocuses(RecipeIngredientRole.INPUT).findAny().isPresent();
            Predicate<Object> keep = arg_0 -> JEI.lambda$filterLocked$1((Player)player, ingredient, arg_0);
            return recipes.filter(keep);
        }
        return recipes;
    }

    private static /* synthetic */ boolean lambda$filterLocked$1(Player player, boolean ingredient, Object recipe) {
        if (player == null) {
            return true;
        }
        PlayerData data = (PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player);
        if (ingredient) {
            return data.getRecipeKeeper().isUnlocked((RecipeHolder)recipe);
        }
        return data.getRecipeKeeper().isUnlockedForCrafting((RecipeHolder)recipe);
    }
}

