/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.jei;

import com.mojang.serialization.Codec;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.ICodecHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class SextupleRecipeCategory<T extends SextupleRecipe>
implements IRecipeCategory<RecipeHolder<T>> {
    public static final RecipeType<RecipeHolder<SextupleRecipe>> FORGING = SextupleRecipeCategory.createHolder("runecraftory", CraftingType.FORGE.getId() + "_category");
    public static final RecipeType<RecipeHolder<SextupleRecipe>> COOKING = SextupleRecipeCategory.createHolder("runecraftory", CraftingType.COOKING_TABLE.getId() + "_category");
    public static final RecipeType<RecipeHolder<SextupleRecipe>> ARMOR = SextupleRecipeCategory.createHolder("runecraftory", CraftingType.ACCESSORY_WORKBENCH.getId() + "_category");
    public static final RecipeType<RecipeHolder<SextupleRecipe>> CHEMISTRY = SextupleRecipeCategory.createHolder("runecraftory", CraftingType.CHEMISTRY_SET.getId() + "_category");
    public static final ResourceLocation GUI = RuneCraftory.modRes("textures/gui/container/crafting.png");
    private final IDrawable icon;
    private final IDrawable background;
    private final RecipeType<RecipeHolder<T>> recipeType;
    private final Component title;

    public static <R extends Recipe<?>> RecipeType<RecipeHolder<R>> createHolder(String nameSpace, String path) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)path);
        Class<RecipeHolder> holderClass = RecipeHolder.class;
        return new RecipeType(id, holderClass);
    }

    public SextupleRecipeCategory(IGuiHelper guiHelper, RecipeType<RecipeHolder<T>> recipeType, Item icon) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)icon));
        this.recipeType = recipeType;
        this.title = Component.translatable((String)("runecraftory.container.crafting." + this.recipeType.getUid().getPath().replace("_category", "")));
        this.background = guiHelper.createDrawable(GUI, 19, 20, 119, 42);
    }

    public RecipeType<RecipeHolder<T>> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<T> holder, IFocusGroup focuses) {
        LocalPlayer player = Minecraft.getInstance().player;
        builder.setShapeless();
        SextupleRecipe recipe = (SextupleRecipe)holder.value();
        if (((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getRecipeKeeper().isUnlocked(holder)) {
            for (int i = 0; i < recipe.getIngredients().size(); ++i) {
                int x = i % 3;
                int y = i / 3;
                builder.addSlot(RecipeIngredientRole.INPUT, 1 + x * 18, 6 + y * 18).addIngredients((Ingredient)recipe.getIngredients().get(i));
            }
        } else {
            for (Ingredient ing : recipe.getIngredients()) {
                builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addIngredients(ing);
            }
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 65, 15).addItemStack(new ItemStack((ItemLike)RuneCraftoryItems.UNKNOWN.get()))).addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"runecraftory.recipe_integration.locked")));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 97, 15).addItemStack(recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
    }

    public void draw(RecipeHolder<T> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipeSlotsView.getSlotViews(RecipeIngredientRole.RENDER_ONLY).isEmpty()) {
            this.drawLevel((SextupleRecipe)recipe.value(), guiGraphics);
        }
    }

    protected void drawLevel(T recipe, GuiGraphics guiGraphics) {
        MutableComponent level = Component.translatable((String)"runecraftory.recipe_integration.crafting_level", (Object[])new Object[]{((SextupleRecipe)recipe).getCraftingLevel()});
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        int width = font.width((FormattedText)level);
        guiGraphics.drawString(font, (Component)level, this.background.getWidth() - width - 10, 0, -8355712);
    }

    public Codec<RecipeHolder<T>> getCodec(ICodecHelper codecHelper, IRecipeManager recipeManager) {
        return codecHelper.getRecipeHolderCodec();
    }
}

