/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.rei;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.recipes.CraftingType;
import io.github.flemmli97.runecraftory.common.recipes.SextupleRecipe;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RunecraftoryAttachments;
import io.github.flemmli97.runecraftory.integration.rei.CraftingIdentifier;
import io.github.flemmli97.runecraftory.integration.rei.SextupleDisplay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SextupleCategory
implements DisplayCategory<SextupleDisplay> {
    public static final ResourceLocation GUI = RuneCraftory.modRes("textures/gui/crafting.png");
    private final CraftingIdentifier identifier;
    private static final int X_SIZE = 119;
    private static final int Y_SIZE = 42;

    public SextupleCategory(CraftingIdentifier identifier) {
        this.identifier = identifier;
    }

    public Renderer getIcon() {
        return switch (this.identifier.craftingType()) {
            default -> throw new MatchException(null, null);
            case CraftingType.FORGE -> EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.FORGE.get()));
            case CraftingType.ACCESSORY_WORKBENCH -> EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.ACCESSORY_WORKBENCH.get()));
            case CraftingType.CHEMISTRY_SET -> EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.CHEMISTRY_SET.get()));
            case CraftingType.COOKING_TABLE -> EntryStacks.of((ItemLike)((ItemLike)RuneCraftoryItems.COOKING_TABLE.get()));
        };
    }

    public Component getTitle() {
        return Component.translatable((String)("runecraftory.container.crafting." + this.identifier.craftingType().getId()));
    }

    public List<Widget> setupDisplay(SextupleDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createTexturedWidget((ResourceLocation)GUI, (int)bounds.getX(), (int)bounds.getY(), (float)19.0f, (float)20.0f, (int)119, (int)42));
        LocalPlayer player = Minecraft.getInstance().player;
        if (display.recipe() != null && ((PlayerData)RunecraftoryAttachments.PLAYER_DATA.get().get((Object)player)).getRecipeKeeper().isUnlocked(display.recipe())) {
            for (int y = 0; y < 2; ++y) {
                for (int x = 0; x < 3; ++x) {
                    int ind = x + y * 3;
                    if (ind >= display.getInputEntries().size()) continue;
                    widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 1 + x * 18, bounds.getY() + 6 + y * 18)).entries((Collection)display.getInputEntries().get(ind)));
                }
            }
            MutableComponent level = Component.translatable((String)"runecraftory.recipe_integration.crafting_level", (Object[])new Object[]{((SextupleRecipe)display.recipe().value()).getCraftingLevel()});
            widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getX() + bounds.getWidth(), bounds.getY()), (Component)level).noShadow().rightAligned().color(-12566464, -4473925));
        } else {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 64, bounds.getY() + 14)).entry(EntryStacks.of((ItemStack)new ItemStack((ItemLike)RuneCraftoryItems.UNKNOWN.get())).tooltip(new Component[]{Component.translatable((String)"runecraftory.recipe_integration.locked")})));
        }
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getX() + 97, bounds.getY() + 15)).backgroundEnabled(false).entries((Collection)display.getOutputEntries().getFirst()));
        return widgets;
    }

    public int getDisplayHeight() {
        return 42;
    }

    public int getDisplayWidth(SextupleDisplay display) {
        return 119;
    }

    public CategoryIdentifier<? extends SextupleDisplay> getCategoryIdentifier() {
        return this.identifier.identifier();
    }
}

