/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.integration.sereneseasons;

import io.github.flemmli97.runecraftory.api.calendar.Season;
import io.github.flemmli97.runecraftory.common.config.GeneralConfig;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;

public class SeasonsAccess {
    @Nullable
    public static SeasonData getDate(Level level) {
        if (!GeneralConfig.SERENE_SEASONS.get().booleanValue()) {
            return null;
        }
        ISeasonState helper = SeasonHelper.getSeasonState((Level)level);
        int seasonDays = helper.getSeasonDuration() / helper.getDayDuration();
        int n = helper.getDay() + 1;
        int n2 = helper.getCycleDuration() / helper.getDayDuration();
        int n3 = helper.getDay() % seasonDays + 1;
        return new SeasonData(n, n2, n3, switch (helper.getSeason()) {
            default -> throw new MatchException(null, null);
            case sereneseasons.api.season.Season.SPRING -> Season.SPRING;
            case sereneseasons.api.season.Season.SUMMER -> Season.SUMMER;
            case sereneseasons.api.season.Season.AUTUMN -> Season.AUTUMN;
            case sereneseasons.api.season.Season.WINTER -> Season.WINTER;
        });
    }

    public record SeasonData(int dayOfYear, int daysPerYear, int dayOfSeason, Season season) {
    }
}

