/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.mixin;

import io.github.flemmli97.runecraftory.api.datapack.ItemStat;
import io.github.flemmli97.runecraftory.common.events.EntityCalls;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin {
    @Inject(method={"mineBlock"}, at={@At(value="HEAD")})
    private void onBlockMine(Level level, BlockState state, BlockPos pos, Player player, CallbackInfo info) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EntityCalls.onBlockBreak(serverPlayer, state, pos);
        }
    }

    @Inject(method={"addModifierTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private void noTooltipRender(Consumer<Component> tooltipAdder, Player player, Holder<Attribute> attribute, AttributeModifier modifier, CallbackInfo info) {
        if (attribute.is(RunecraftoryTags.Attributes.DISPLAY_IGNORED)) {
            info.cancel();
        }
    }

    @ModifyVariable(method={"addModifierTooltip"}, at=@At(value="HEAD"), argsOnly=true)
    private AttributeModifier updateTooltip(AttributeModifier original, Consumer<Component> tooltipAdder, @Nullable Player player, Holder<Attribute> attribute) {
        return ItemStat.adjustModifier(attribute, original);
    }
}

