/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.neoforge.data;

import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.common.blocks.CraftingBlock;
import io.github.flemmli97.runecraftory.common.blocks.ExtendedCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.GiantCropBlock;
import io.github.flemmli97.runecraftory.common.blocks.QuestboardBlock;
import io.github.flemmli97.runecraftory.common.blocks.util.MineralBlockTier;
import io.github.flemmli97.runecraftory.common.entities.GateEntity;
import io.github.flemmli97.runecraftory.common.entities.monster.KingWooly;
import io.github.flemmli97.runecraftory.common.entities.monster.MineralSqueek;
import io.github.flemmli97.runecraftory.common.entities.monster.Wooly;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.lib.LootTableResources;
import io.github.flemmli97.runecraftory.common.loot.CropWeaponLootFunction;
import io.github.flemmli97.runecraftory.common.loot.FirstKillCondition;
import io.github.flemmli97.runecraftory.common.loot.FriendPointCondition;
import io.github.flemmli97.runecraftory.common.loot.ItemLevelLootFunction;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.loot.LootingAndLuckLootFunction;
import io.github.flemmli97.runecraftory.common.loot.LuckBonusNumberProvider;
import io.github.flemmli97.runecraftory.common.loot.SkillLevelCondition;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.neoforge.data.QuestGen;
import io.github.flemmli97.tenshilib.loader.registry.RegistryEntrySupplier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class Loottables
extends LootTableProvider {
    private static final float COMMON_LUCK_BONUS = 0.05f;
    private static final float RARE_LUCK_BONUS = 0.01f;
    private static final float VERY_RARE_LUCK_BONUS = 0.005f;
    private static final float SUPER_RARE_LUCK_BONUS = 0.001f;
    private static final float LOOTING_BONUS = 0.2f;
    private static final float RARE_LOOTING_BONUS = 0.1f;

    public Loottables(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, QuestGen questGen) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(EntityLoot::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry(BlockLootData::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(ChestLoots::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(WoolyShearedEntityLoot::new, LootCtxParameters.MONSTER_INTERACTION), new LootTableProvider.SubProviderEntry(provider -> new QuestLootData((HolderLookup.Provider)provider, questGen), LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(FishingLootData::new, LootContextParamSets.FISHING)), registries);
    }

    protected void validate(WritableRegistry<LootTable> writableregistry, ValidationContext validationcontext, ProblemReporter.Collector problemreporter$collector) {
    }

    static class QuestLootData
    implements LootTableSubProvider {
        private final HolderLookup.Provider provider;
        private final QuestGen questGen;

        QuestLootData(HolderLookup.Provider provider, QuestGen questGen) {
            this.provider = provider;
            this.questGen = questGen;
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            this.questGen.loot.forEach(output);
        }
    }

    static class FishingLootData
    implements LootTableSubProvider {
        private final HolderLookup.Provider provider;

        FishingLootData(HolderLookup.Provider provider) {
            this.provider = provider;
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            output.accept(LootTableResources.FISHING, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)BuiltInLootTables.FISHING))));
            output.accept(LootTableResources.SAND_FISHING, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND))));
        }
    }

    static class BlockLootData
    extends BlockLootSubProvider {
        private final Map<ResourceKey<LootTable>, LootTable.Builder> loots = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();

        protected BlockLootData(HolderLookup.Provider registries) {
            super(Set.of(), FeatureFlagSet.of(), registries);
        }

        protected static LootPool.Builder herbLoot(ItemLike item) {
            LootPool.Builder build = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)ItemLevelLootFunction.defaultFunc()));
            return build;
        }

        protected static LootPool.Builder cropLoot(HolderLookup.Provider provider, ExtendedCropBlock block) {
            LootPool.Builder build = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            if (block instanceof GiantCropBlock) {
                build.add(LootItem.lootTableItem((ItemLike)block.getCrop(provider)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(GiantCropBlock.DIRECTION, (Comparable)Direction.NORTH).hasProperty(GiantCropBlock.HALF, (Comparable)Half.BOTTOM).hasProperty((Property)GiantCropBlock.AGE, block.getMaxAge()))));
            } else {
                build.add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block.getCrop(provider)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)GiantCropBlock.AGE, block.getMaxAge())))).otherwise(LootItem.lootTableItem((ItemLike)block.getCrop(provider)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)GiantCropBlock.AGE, block.getGiantAge())))));
            }
            return build;
        }

        protected static LootPool.Builder cropWeaponLoot(HolderLookup.Provider provider, ExtendedCropBlock block) {
            LootPool.Builder build = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            build.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block.getCrop(provider)).apply((LootItemFunction.Builder)new CropWeaponLootFunction.Builder()));
            return build;
        }

        protected static LootPool.Builder oreLootPool(MineralBlockTier tier) {
            LootPool.Builder build = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            switch (tier) {
                case IRON: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(40, 17, (ItemLike)Items.IRON_INGOT));
                    build.add(BlockLootData.ore(5, 5, (ItemLike)RuneCraftoryItems.INVIS_STONE.get()));
                    build.add(BlockLootData.ore(10, 3, (ItemLike)RuneCraftoryItems.INVIS_STONE.get(), 10));
                    build.add(BlockLootData.ore(1, 7, (ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case TIN: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(40, 15, (ItemLike)Items.IRON_INGOT));
                    build.add(BlockLootData.ore(25, 24, (ItemLike)Items.COPPER_INGOT));
                    build.add(BlockLootData.ore(4, 3, (ItemLike)RuneCraftoryItems.INVIS_STONE.get(), 5));
                    build.add(BlockLootData.ore(5, 3, (ItemLike)RuneCraftoryItems.INVIS_STONE.get(), 20));
                    build.add(BlockLootData.ore(3, 8, (ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case SILVER: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(40, 12, (ItemLike)Items.IRON_INGOT));
                    build.add(BlockLootData.ore(20, 31, (ItemLike)RuneCraftoryItems.RAW_SILVER.get()));
                    build.add(BlockLootData.ore(2, 2, (ItemLike)RuneCraftoryItems.INVIS_STONE.get(), 5));
                    build.add(BlockLootData.ore(3, 2, (ItemLike)RuneCraftoryItems.INVIS_STONE.get(), 10));
                    build.add(BlockLootData.ore(3, 2, (ItemLike)RuneCraftoryItems.INVIS_STONE.get(), 15));
                    build.add(BlockLootData.ore(3, 8, (ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case GOLD: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(50, 8, (ItemLike)Items.IRON_INGOT));
                    build.add(BlockLootData.ore(20, 31, (ItemLike)Items.GOLD_INGOT));
                    build.add(BlockLootData.ore(3, 8, (ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case DIAMOND: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(5, 7, (ItemLike)Items.DIAMOND));
                    build.add(BlockLootData.ore(15, 27, (ItemLike)Items.DIAMOND, 20));
                    build.add(BlockLootData.ore(3, 8, (ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case PLATINUM: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(4, 12, (ItemLike)RuneCraftoryItems.RAW_PLATINUM.get()));
                    build.add(BlockLootData.ore(20, 29, (ItemLike)RuneCraftoryItems.RAW_PLATINUM.get(), 30));
                    build.add(BlockLootData.ore(3, 8, (ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case ORICHALCUM: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(4, 8, (ItemLike)RuneCraftoryItems.ORICHALCUM.get(), 20));
                    build.add(BlockLootData.ore(10, 27, (ItemLike)RuneCraftoryItems.ORICHALCUM.get(), 40));
                    build.add(BlockLootData.ore(5, 11, (ItemLike)RuneCraftoryItems.CRYSTAL_BIG.get(), 40));
                    break;
                }
                case DRAGONIC: {
                    build.add(BlockLootData.ore(100, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(6, 9, (ItemLike)RuneCraftoryItems.DRAGONIC.get(), 20));
                    build.add(BlockLootData.ore(10, 26, (ItemLike)RuneCraftoryItems.DRAGONIC.get(), 50));
                    build.add(BlockLootData.ore(3, 9, (ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 40));
                    break;
                }
                case AMETHYST: {
                    build.add(BlockLootData.ore(130, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(40, 15, (ItemLike)RuneCraftoryItems.AMETHYST.get()));
                    build.add(BlockLootData.ore(15, 17, (ItemLike)RuneCraftoryItems.CRYSTAL_EARTH.get()));
                    build.add(BlockLootData.ore(1, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get()));
                    build.add(BlockLootData.ore(5, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 5));
                    build.add(BlockLootData.ore(7, 5, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case AQUAMARINE: {
                    build.add(BlockLootData.ore(130, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(40, 15, (ItemLike)RuneCraftoryItems.AQUAMARINE.get()));
                    build.add(BlockLootData.ore(15, 17, (ItemLike)RuneCraftoryItems.CRYSTAL_WATER.get()));
                    build.add(BlockLootData.ore(1, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get()));
                    build.add(BlockLootData.ore(5, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 5));
                    build.add(BlockLootData.ore(7, 5, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case RUBY: {
                    build.add(BlockLootData.ore(130, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(40, 15, (ItemLike)RuneCraftoryItems.RUBY.get()));
                    build.add(BlockLootData.ore(15, 17, (ItemLike)RuneCraftoryItems.CRYSTAL_FIRE.get()));
                    build.add(BlockLootData.ore(1, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get()));
                    build.add(BlockLootData.ore(5, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 5));
                    build.add(BlockLootData.ore(7, 5, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case EMERALD: {
                    build.add(BlockLootData.ore(130, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(40, 15, (ItemLike)Items.EMERALD));
                    build.add(BlockLootData.ore(15, 17, (ItemLike)RuneCraftoryItems.CRYSTAL_WIND.get()));
                    build.add(BlockLootData.ore(1, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get()));
                    build.add(BlockLootData.ore(5, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 5));
                    build.add(BlockLootData.ore(7, 5, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 15));
                    break;
                }
                case SAPPHIRE: {
                    build.add(BlockLootData.ore(130, 3, (ItemLike)RuneCraftoryItems.SCRAP.get()));
                    build.add(BlockLootData.ore(50, 15, (ItemLike)RuneCraftoryItems.SAPPHIRE.get()));
                    build.add(BlockLootData.ore(3, 17, (ItemLike)RuneCraftoryItems.CRYSTAL_LOVE.get()));
                    build.add(BlockLootData.ore(1, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get()));
                    build.add(BlockLootData.ore(5, 3, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 5));
                    build.add(BlockLootData.ore(7, 5, (ItemLike)RuneCraftoryItems.LIGHT_ORE.get(), 15));
                }
            }
            build.apply((LootItemFunction.Builder)ItemLevelLootFunction.defaultFunc());
            return build;
        }

        private static LootPoolSingletonContainer.Builder<?> ore(int weight, int quality, ItemLike item) {
            return LootItem.lootTableItem((ItemLike)item).setWeight(weight).setQuality(quality);
        }

        private static LootPoolSingletonContainer.Builder<?> ore(int weight, int quality, ItemLike item, int minMiningLevel) {
            return (LootPoolSingletonContainer.Builder)BlockLootData.ore(weight, quality, item).when(SkillLevelCondition.get(Skills.MINING, minMiningLevel));
        }

        protected void generate() {
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
            Block block2;
            this.add((Block)RuneCraftoryBlocks.MUSHROOM.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.MUSHROOM.get())));
            this.add((Block)RuneCraftoryBlocks.MONARCH_MUSHROOM.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.MONARCH_MUSHROOM.get())));
            this.add((Block)RuneCraftoryBlocks.ELLI_LEAVES.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.ELLI_LEAVES.get())));
            this.add((Block)RuneCraftoryBlocks.WITHERED_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.WITHERED_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.WEEDS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.WEEDS.get())));
            this.add((Block)RuneCraftoryBlocks.WHITE_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.WHITE_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.INDIGO_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.INDIGO_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.PURPLE_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.PURPLE_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.GREEN_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.GREEN_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.BLUE_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.BLUE_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.YELLOW_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.YELLOW_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.RED_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.RED_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.ORANGE_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.ORANGE_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.BLACK_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.BLACK_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.ANTIDOTE_GRASS.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.ANTIDOTE_GRASS.get())));
            this.add((Block)RuneCraftoryBlocks.MEDICINAL_HERB.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.MEDICINAL_HERB.get())));
            this.add((Block)RuneCraftoryBlocks.BAMBOO_SPROUT.get(), LootTable.lootTable().withPool(BlockLootData.herbLoot((ItemLike)RuneCraftoryItems.BAMBOO_SPROUT.get())));
            this.add((Block)RuneCraftoryBlocks.FORGE.get(), (Block block) -> this.createSinglePropConditionTable((Block)block, (Property)CraftingBlock.PART, (Comparable)((Object)CraftingBlock.EnumPart.LEFT)));
            this.add((Block)RuneCraftoryBlocks.COOKING_TABLE.get(), (Block block) -> this.createSinglePropConditionTable((Block)block, (Property)CraftingBlock.PART, (Comparable)((Object)CraftingBlock.EnumPart.LEFT)));
            this.add((Block)RuneCraftoryBlocks.CHEMISTRY_SET.get(), (Block block) -> this.createSinglePropConditionTable((Block)block, (Property)CraftingBlock.PART, (Comparable)((Object)CraftingBlock.EnumPart.LEFT)));
            this.add((Block)RuneCraftoryBlocks.ACCESSORY_WORKBENCH.get(), (Block block) -> this.createSinglePropConditionTable((Block)block, (Property)CraftingBlock.PART, (Comparable)((Object)CraftingBlock.EnumPart.LEFT)));
            this.dropSelf((Block)RuneCraftoryBlocks.SHIPPING.get());
            this.dropSelf((Block)RuneCraftoryBlocks.CASH_REGISTER.get());
            this.dropSelf((Block)RuneCraftoryBlocks.MONSTER_BARN.get());
            this.add((Block)RuneCraftoryBlocks.QUEST_BOARD.get(), (Block block) -> this.createSinglePropConditionTable((Block)block, (Property)QuestboardBlock.PART, (Comparable)((Object)QuestboardBlock.Part.BOTTOM_LEFT)));
            for (RegistryEntrySupplier<Block, ?> reg2 : RuneCraftoryBlocks.CROPS) {
                block2 = (Block)reg2.get();
                if (!(block2 instanceof ExtendedCropBlock)) continue;
                this.add((Block)reg2.get(), LootTable.lootTable().withPool(BlockLootData.cropLoot(this.registries, (ExtendedCropBlock)block2)));
            }
            for (RegistryEntrySupplier<Block, ?> reg2 : RuneCraftoryBlocks.FLOWERS) {
                if (reg2 == RuneCraftoryBlocks.SWORD_CROP || reg2 == RuneCraftoryBlocks.SHIELD_CROP) {
                    block2 = (Block)reg2.get();
                    if (!(block2 instanceof ExtendedCropBlock)) continue;
                    this.add((Block)reg2.get(), LootTable.lootTable().withPool(BlockLootData.cropWeaponLoot(this.registries, (ExtendedCropBlock)block2)));
                    continue;
                }
                block2 = (Block)reg2.get();
                if (!(block2 instanceof ExtendedCropBlock)) continue;
                this.add((Block)reg2.get(), LootTable.lootTable().withPool(BlockLootData.cropLoot(this.registries, (ExtendedCropBlock)block2)));
            }
            RuneCraftoryBlocks.MINERAL_MAP.forEach((tier, reg) -> this.add((Block)reg.get(), LootTable.lootTable().withPool(BlockLootData.oreLootPool(tier))));
            this.add((Block)RuneCraftoryBlocks.ACCESSORY_WORKBENCH.get(), (Block block) -> this.createSinglePropConditionTable((Block)block, (Property)CraftingBlock.PART, (Comparable)((Object)CraftingBlock.EnumPart.LEFT)));
            this.dropOther((Block)RuneCraftoryBlocks.APPLE_TREE.get(), (ItemLike)Blocks.OAK_LOG);
            this.dropOther((Block)RuneCraftoryBlocks.ORANGE_TREE.get(), (ItemLike)Blocks.BIRCH_LOG);
            this.dropOther((Block)RuneCraftoryBlocks.GRAPE_TREE.get(), (ItemLike)Blocks.SPRUCE_LOG);
            this.dropOther((Block)RuneCraftoryBlocks.APPLE_WOOD.get(), (ItemLike)Blocks.OAK_LOG);
            this.dropOther((Block)RuneCraftoryBlocks.ORANGE_WOOD.get(), (ItemLike)Blocks.BIRCH_LOG);
            this.dropOther((Block)RuneCraftoryBlocks.GRAPE_WOOD.get(), (ItemLike)Blocks.SPRUCE_LOG);
            this.add((Block)RuneCraftoryBlocks.APPLE_LEAVES.get(), this.simpleLeaves(Blocks.OAK_LEAVES));
            this.add((Block)RuneCraftoryBlocks.ORANGE_LEAVES.get(), this.simpleLeaves(Blocks.BIRCH_LEAVES));
            this.add((Block)RuneCraftoryBlocks.GRAPE_LEAVES.get(), this.simpleLeaves(Blocks.DARK_OAK_LEAVES));
            this.add((Block)RuneCraftoryBlocks.APPLE.get(), this.simpleLeaves(Blocks.OAK_LEAVES));
            this.add((Block)RuneCraftoryBlocks.ORANGE.get(), this.simpleLeaves(Blocks.BIRCH_LEAVES));
            this.add((Block)RuneCraftoryBlocks.GRAPE.get(), this.simpleLeaves(Blocks.DARK_OAK_LEAVES));
            this.loots.forEach(biConsumer);
        }

        private LootTable.Builder simpleLeaves(Block leaveBlock) {
            return new LootTable.Builder().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS.or(this.hasSilkTouch()).invert()).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)Blocks.OAK_LEAVES, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})));
        }

        public void add(Block block, Function<Block, LootTable.Builder> function) {
            this.add(block, function.apply(block));
        }

        public void add(Block block, LootTable.Builder builder) {
            this.loots.put((ResourceKey<LootTable>)block.getLootTable(), builder);
        }
    }

    static class ChestLoots
    implements LootTableSubProvider {
        private final HolderLookup.Provider provider;

        ChestLoots(HolderLookup.Provider provider) {
            this.provider = provider;
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            LootPool.Builder tier1 = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f));
            for (RegistryEntrySupplier<Item, ?> registryEntrySupplier : RuneCraftoryItems.TIER_1_CHEST) {
                tier1.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            tier1.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FORGING_BREAD.get())));
            tier1.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.ACCESSORY_BREAD.get())));
            tier1.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.MEDICINE_BREAD.get())));
            tier1.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.COOKING_BREAD.get())));
            output.accept(LootTableResources.TIER_1_LOOT, LootTable.lootTable().withPool(tier1));
            LootPool.Builder tier2 = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f));
            for (RegistryEntrySupplier<Item, ?> registryEntrySupplier : RuneCraftoryItems.TIER_2_CHEST) {
                tier2.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            tier2.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FORGING_BREAD.get())));
            tier2.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.ACCESSORY_BREAD.get())));
            tier2.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.MEDICINE_BREAD.get())));
            tier2.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.COOKING_BREAD.get())));
            output.accept(LootTableResources.TIER_2_LOOT, LootTable.lootTable().withPool(tier2));
            LootPool.Builder builder = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f));
            for (RegistryEntrySupplier<Item, ?> registryEntrySupplier : RuneCraftoryItems.TIER_3_CHEST) {
                builder.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            output.accept(LootTableResources.TIER_3_LOOT, LootTable.lootTable().withPool(builder));
            LootPool.Builder builder2 = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f));
            for (RegistryEntrySupplier<Item, ?> registryEntrySupplier : RuneCraftoryItems.TIER_4_CHEST) {
                builder2.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)registryEntrySupplier.get())));
            }
            output.accept(LootTableResources.TIER_4_LOOT, LootTable.lootTable().withPool(builder2));
            LootPool.Builder builder3 = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)-2.0f, (float)1.0f));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FIRE_BALL_SMALL.get())).setWeight(140));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FIRE_BALL_BIG.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.EXPLOSION.get())).setWeight(20));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.WATER_LASER.get())).setWeight(110));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.PARALLEL_LASER.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DELTA_LASER.get())).setWeight(20));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.SCREW_ROCK.get())).setWeight(110));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.EARTH_SPIKE.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.AVENGER_ROCK.get())).setWeight(20));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.SONIC_WIND.get())).setWeight(110));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DOUBLE_SONIC.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.PENETRATE_SONIC.get())).setWeight(20));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.LIGHT_BARRIER.get())).setWeight(90));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.SHINE.get())).setWeight(50));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.PRISM.get())).setWeight(15));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DARK_SNAKE.get())).setWeight(100));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DARK_BALL.get())).setWeight(50));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DARKNESS.get())).setWeight(15));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.CURE.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.CURE_ALL.get())).setWeight(30));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.CURE_MASTER.get())).setWeight(10));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.MEDI_POISON.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.MEDI_PARA.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.MEDI_SEAL.get())).setWeight(10));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.POWER_WAVE.get())).setWeight(100));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DASH_SLASH.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.RUSH_ATTACK.get())).setWeight(85));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.ROUND_BREAK.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.MIND_THRUST.get())).setWeight(85));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.GUST.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.STORM.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.BLITZ.get())).setWeight(30));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.TWIN_ATTACK.get())).setWeight(90));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.RAIL_STRIKE.get())).setWeight(50));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.WIND_SLASH.get())).setWeight(70));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FLASH_STRIKE.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.NAIVE_BLADE.get())).setWeight(70));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.STEEL_HEART.get())).setWeight(40));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DELTA_STRIKE.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.HURRICANE.get())).setWeight(90));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.REAPER_SLASH.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.MILLION_STRIKE.get())).setWeight(50));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.AXEL_DISASTER.get())).setWeight(50));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.STARDUST_UPPER.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.TORNADO_SWING.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.GRAND_IMPACT.get())).setWeight(70));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.GIGA_SWING.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.UPPER_CUT.get())).setWeight(100));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.DOUBLE_KICK.get())).setWeight(90));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.STRAIGHT_PUNCH.get())).setWeight(80));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.NEKO_DAMASHI.get())).setWeight(100));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.RUSH_PUNCH.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.CYCLONE.get())).setWeight(60));
            builder3.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.RAPID_MOVE.get())).setWeight(90));
            output.accept(LootTableResources.CHEST_LOOT_SPELLS, LootTable.lootTable().withPool(builder3));
        }
    }

    static class WoolyShearedEntityLoot
    extends EntityLoot {
        WoolyShearedEntityLoot(HolderLookup.Provider provider) {
            super(provider);
        }

        @Override
        protected void init() {
            AlternativesEntry.Builder b = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]);
            b.otherwise((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FUR_LARGE.get())).when(FriendPointCondition.of(8))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))));
            b.otherwise((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FUR_MEDIUM.get())).when(FriendPointCondition.of(5))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))));
            b.otherwise((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.FUR_SMALL.get())).when(FriendPointCondition.of(0))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE))));
            this.lootTables.put(Wooly.shearedLootTable(LootTableResources.WOOLY_WHITE), LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)b)));
        }
    }

    static class EntityLoot
    implements LootTableSubProvider {
        protected final Map<ResourceKey<LootTable>, LootTable.Builder> lootTables = new HashMap<ResourceKey<LootTable>, LootTable.Builder>();
        protected final HolderLookup.Provider provider;

        EntityLoot(HolderLookup.Provider provider) {
            this.provider = provider;
        }

        protected void init() {
            this.lootTables.put(LootTableResources.WOOLY_WHITE, this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FUR_SMALL.get(), 0.6f, 0.05f, 0.2f, 2)).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)((EntityType)RuneCraftoryEntities.WOOLY.get()).getDefaultLootTable()))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.WOOLY.get(), this.table(new ItemLootData((ItemLike)Items.SHEARS, 0.05f, 0.01f, 0.2f, 1)).withPool(this.create().add(this.addWithCount((ItemLike)Items.MUTTON, -3.0f, 1.0f, 1.0f))), new TamedItemLootData((ItemLike)RuneCraftoryItems.FUR_SMALL.get(), 1.0f, 0), new TamedItemLootData((ItemLike)RuneCraftoryItems.FUR_MEDIUM.get(), 1.0f, 5), new TamedItemLootData((ItemLike)RuneCraftoryItems.FUR_LARGE.get(), 1.0f, 8));
            this.registerLootTable((EntityType)RuneCraftoryEntities.ANT.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_INSECT.get(), 0.5f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_PRETTY.get(), 0.01f, 0.005f, 0.2f, 2), new ItemLootData((ItemLike)RuneCraftoryItems.JAW_INSECT.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.OAK_LOG, 0.7f, 0.05f, 0.6f, 0, true)), new TamedItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_INSECT.get(), 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.ORC_ARCHER.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.RECOVERY_POTION.get(), 0.03f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)Items.GUNPOWDER, 0.6f, 0.05f, 0.7f, 0, true), new ItemLootData((ItemLike)RuneCraftoryItems.ARROW_HEAD.get(), 0.5f, 0.05f, 0.2f, 0)).withPool(this.create().add(this.addWithCount((ItemLike)Items.ARROW, -1.0f, 1.0f, 1.0f))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.ORC.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CHEAP_BRACELET.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.CLOTH_CHEAP.get(), 0.5f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.GLUE.get(), 0.4f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.BEETLE.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_INSECT.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_PRETTY.get(), 0.01f, 0.005f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.HORN_INSECT.get(), 0.3f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.HORN_INSECT.get(), 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.BIG_MUCK.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.SPORE.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.POWDER_POISON.get(), 0.05f, 0.005f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.MUSHROOM.get(), 0.4f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.SPORE.get(), 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.BUFFAMOO.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.MILK_S.get(), 0.4f, 0.05f, 0.2f, 0)).withPool(this.create().add(this.addWithCount((ItemLike)Items.LEATHER, -4.0f, 1.0f, 1.0f))).withPool(this.create().add(this.addWithCount((ItemLike)Items.BEEF, -5.0f, 2.0f, 1.0f))), new TamedItemLootData((ItemLike)RuneCraftoryItems.MILK_S.get(), 1.0f, 0), new TamedItemLootData((ItemLike)RuneCraftoryItems.MILK_M.get(), 1.0f, 5), new TamedItemLootData((ItemLike)RuneCraftoryItems.MILK_L.get(), 1.0f, 8));
            this.registerLootTable((EntityType)RuneCraftoryEntities.CHIPSQUEEK.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_QUALITY.get(), 0.02f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.CLUCKADOODLE.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.EGG_S.get(), 0.45f, 0.05f, 0.2f, 0)).withPool(this.create().add(this.addWithCount((ItemLike)Items.CHICKEN, -4.0f, 1.0f, 0.5f))).withPool(this.create().add(this.addWithCount((ItemLike)Items.FEATHER, -3.0f, 2.0f, 1.0f))), new TamedItemLootData((ItemLike)RuneCraftoryItems.EGG_S.get(), 1.0f, 0), new TamedItemLootData((ItemLike)RuneCraftoryItems.EGG_M.get(), 1.0f, 5), new TamedItemLootData((ItemLike)RuneCraftoryItems.EGG_L.get(), 1.0f, 8));
            this.registerLootTable((EntityType)RuneCraftoryEntities.POMME_POMME.get(), this.table(new ItemLootData((ItemLike)Items.APPLE, 0.7f, 0.05f, 0.7f, 2, true), new ItemLootData((ItemLike)RuneCraftoryItems.BAKED_APPLE.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.APPLE_SAPLING.get(), 0.05f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)Items.APPLE, 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.TORTAS.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.TURTLE_SHELL.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.IRON_INGOT, 0.65f, 0.05f, 0.5f, 0), new ItemLootData((ItemLike)Items.COPPER_INGOT, 0.45f, 0.05f, 0.5f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SKY_FISH.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FISH_FOSSIL.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CAN.get(), 0.03f, 0.005f, 0.1f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.RARE_CAN.get(), 0.005f, 0.001f, 0.1f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.WEAGLE.get(), this.table(new ItemLootData((ItemLike)Items.FEATHER, 0.5f, 0.05f, 0.55f, 0, true)), new TamedItemLootData((ItemLike)Items.FEATHER, 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GOBLIN.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.BLADE_SHARD.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.GLUE.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.OLD_BANDAGE.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.ONIGIRI.get(), 0.07f, 0.05f, 0.2f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GOBLIN_ARCHER.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.ARROW_HEAD.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.OLD_BANDAGE.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.GUNPOWDER, 0.7f, 0.05f, 0.7f, 0, true), new ItemLootData((ItemLike)RuneCraftoryItems.RECOVERY_POTION.get(), 0.08f, 0.05f, 0.2f, 2)).withPool(this.create().add(this.addWithCount((ItemLike)Items.ARROW, -2.0f, 2.0f, 1.0f))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.DUCK.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.DOWN_YELLOW.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.FEATHER, 0.8f, 0.05f, 0.6f, 0, true), new ItemLootData((ItemLike)RuneCraftoryItems.FEATHER_YELLOW.get(), 0.01f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.DOWN_YELLOW.get(), 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.FAIRY.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FAIRY_DUST.get(), 0.5f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.FAIRY_DUST.get(), 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GHOST.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.GHOST_HOOD.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.SKULL.get(), 0.05f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)Items.SKELETON_SKULL, 0.03f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SPIRIT.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_DARK.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_MAGIC.get(), 0.33f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GHOST_RAY.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.GHOST_HOOD.get(), 0.5f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.SKULL.get(), 0.075f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.STICK_THICK.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)Items.SKELETON_SKULL, 0.05f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SPIDER.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.JAW_INSECT.get(), 0.45f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.THREAD_PRETTY.get(), 0.01f, 0.005f, 0.2f, 0), new ItemLootData((ItemLike)Items.STRING, 0.7f, 0.05f, 0.75f, 0, true)), new TamedItemLootData((ItemLike)Items.STRING, 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SHADOW_PANTHER.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CLAW_PANTHER.get(), 0.45f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_QUALITY.get(), 0.35f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.MONSTER_BOX.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.BROKEN_HILT.get(), 0.45f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.BROKEN_BOX.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FAILED_DISH.get(), 0.25f, 0.05f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.DISASTROUS_DISH.get(), 0.05f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GOBBLE_BOX.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.BROKEN_HILT.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.BROKEN_BOX.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FAILED_DISH.get(), 0.15f, 0.05f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.DISASTROUS_DISH.get(), 0.1f, 0.005f, 0.2f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.KILLER_ANT.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_INSECT.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_PRETTY.get(), 0.15f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.JAW_INSECT.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.OAK_LOG, 0.75f, 0.05f, 0.8f, 0, true)), new TamedItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_PRETTY.get(), 0.5f, 4));
            this.registerLootTable((EntityType)RuneCraftoryEntities.ORC_HUNTER.get(), this.table(new ItemLootData((ItemLike)Items.GUNPOWDER, 0.6f, 0.05f, 1.0f, 0, true), new ItemLootData((ItemLike)RuneCraftoryItems.ARROW_HEAD.get(), 0.4f, 0.05f, 0.2f, 0)).withPool(this.create().add(this.addWithCount((ItemLike)Items.ARROW, -1.0f, 1.0f, 1.0f)).add(this.addWithCount((ItemLike)Items.STICK, 0.0f, 4.0f, 0.5f))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.HIGH_ORC.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CHEAP_BRACELET.get(), 0.09f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.CLOTH_CHEAP.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.GLUE.get(), 0.3f, 0.05f, 0.2f, 0)).withPool(this.create().add(this.addWithCount((ItemLike)Items.STICK, 0.0f, 4.0f, 0.5f))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.HORNET.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_INSECT.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_PRETTY.get(), 0.1f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.JAW_INSECT.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)Items.HONEY_BOTTLE, 0.6f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)Items.HONEY_BOTTLE, 1.0f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SILVER_WOLF.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 0.55f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_QUALITY.get(), 0.15f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FANG_WOLF.get(), 0.25f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.FANG_WOLF.get(), 0.5f, 4));
            this.registerLootTable((EntityType)RuneCraftoryEntities.LEAF_BALL.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.PLANT_STEM.get(), 0.4f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.FURPY.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_QUALITY.get(), 0.2f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.PALM_CAT.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CLAW_PALM.get(), 0.4f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.MINO.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.GRAPES.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.GRAPE_JUICE.get(), 0.05f, 0.01f, 0.2f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.TRICKY_MUCK.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.SPORE.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.POWDER_POISON.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.MUSHROOM.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.MONARCH_MUSHROOM.get(), 0.008f, 0.01f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.POWDER_POISON.get(), 0.7f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.FLOWER_LILY.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.PLANT_STEM.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.VINE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.lootTables.put(KingWooly.KING_WOOLY_WOOLED_LOOT, this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FUR_SMALL.get(), 0.4f, 0.05f, 0.2f, 2), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_MEDIUM.get(), 0.2f, 0.05f, 0.2f, 2), new ItemLootData((ItemLike)RuneCraftoryItems.FURBALL.get(), 0.05f, 0.01f, 0.2f, 2), new ItemLootData((ItemLike)Items.SHEARS, 0.01f, 0.01f, 0.0f, 0)).withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)((EntityType)RuneCraftoryEntities.WOOLY.get()).getDefaultLootTable()))));
            this.tamedDropTable((EntityType)RuneCraftoryEntities.KING_WOOLY.get(), new TamedItemLootData((ItemLike)RuneCraftoryItems.FUR_SMALL.get(), 1.0f, 0), new TamedItemLootData((ItemLike)RuneCraftoryItems.FUR_MEDIUM.get(), 1.0f, 5), new TamedItemLootData((ItemLike)RuneCraftoryItems.FUR_LARGE.get(), 1.0f, 8));
            this.registerLootTable((EntityType)RuneCraftoryEntities.BUFFALOO.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.HORN_BULL.get(), 0.27f, 0.05f, 0.2f, 0)).withPool(this.create().add(this.addWithCount((ItemLike)Items.LEATHER, -4.0f, 2.0f, 1.0f))).withPool(this.create().add(this.addWithCount((ItemLike)Items.BEEF, -5.0f, 3.0f, 1.0f))), new TamedItemLootData((ItemLike)RuneCraftoryItems.HORN_BULL.get(), 0.5f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GOBLIN_PIRATE.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CLOTH_QUALITY.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.OIL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.OLD_BANDAGE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GOBLIN_GANGSTER.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CLOTH_QUALITY.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.OIL.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.OLD_BANDAGE.get(), 0.35f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.IGNIS.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_MAGIC.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_FIRE.get(), 0.1f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_FIRE.get(), 0.4f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SCORPION.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.TAIL_SCORPION.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CARAPACE_INSECT.get(), 0.3f, 0.05f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.TAIL_SCORPION.get(), 0.6f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.TROLL.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.GIANTS_NAIL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.GLOVE_GIANT.get(), 0.05f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.FLOWER_LION.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.PLANT_STEM.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.VINE.get(), 0.25f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.TOMATO_GHOST.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.TOMATO_SEEDS.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.TOMATO.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.GHOST_HOOD.get(), 0.2f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GOBLIN_CAPTAIN.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CLOTH_QUALITY.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.WARRIORS_PROOF.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.SKULL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CLOTH_SILK.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.WINE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GOBLIN_DON.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.OLD_BANDAGE.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.PROOF_OF_RANK.get(), 0.1f, 0.01f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.SKULL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.WINE.get(), 0.3f, 0.05f, 0.2f, 0)));
            this.lootTables.put(MineralSqueek.MINERAL_SQUEEK_HURT, new LootTable.Builder().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.STEEL_DOUBLE.get())).setWeight(40)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)RuneCraftoryItems.STEEL_TEN.get())).setWeight(1))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.NAPPIE.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE.get(), 0.6f, 0.05f, 0.5f, 2, true), new ItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE_JUICE.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE_SEEDS.get(), 0.05f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE.get(), 0.5f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.MALM_TIGER.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE.get(), 0.6f, 0.05f, 0.5f, 2, true), new ItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE_JUICE.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE_SEEDS.get(), 0.05f, 0.005f, 0.2f, 0)), new TamedItemLootData((ItemLike)RuneCraftoryItems.PINEAPPLE.get(), 0.5f, 0));
            this.registerLootTable((EntityType)RuneCraftoryEntities.MALM_TIGER.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_QUALITY.get(), 0.2f, 0.1f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CLAW_MALM.get(), 0.3f, 0.1f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.LITTLE_EMPEROR.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_MAGIC.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.POWDER_MAGIC.get(), 0.2f, 0.1f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 0.05f, 0.005f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.DEMON.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.DEVIL_BLOOD.get(), 0.25f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.ARCH_DEMON.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.DEVIL_BLOOD.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.HORN_DEVIL.get(), 0.2f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.MINOTAUR.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.HORN_DEVIL.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.HAMMER_PIECE.get(), 0.3f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.PROTEIN.get(), 0.01f, 0.005f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.MINOTAUR_KING.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.HAMMER_PIECE.get(), 0.25f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.PROTEIN.get(), 0.01f, 0.005f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.AMBROSIA.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.AMBROSIAS_THORNS.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)RuneCraftoryItems.TOYHERB.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.PLANT_STEM.get(), 0.2f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.THUNDERBOLT.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.LIGHTNING_MANE.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)RuneCraftoryItems.FUR.get(), 0.4f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_QUALITY.get(), 0.15f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.MARIONETTA.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CURSED_DOLL.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_SMALL.get(), 0.8f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_MEDIUM.get(), 0.25f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.HANDONETTA.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.PUPPETRY_STRINGS.get(), 0.4f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_SMALL.get(), 0.8f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.FUR_MEDIUM.get(), 0.25f, 0.01f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.DEAD_TREE.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.MOVING_BRANCH.get(), 0.6f, 0.05f, 0.1f, 2, true, false), new ItemLootData((ItemLike)Items.APPLE, 0.8f, 0.05f, 1.0f, 0, true), new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_SMALL.get(), 0.05f, 0.01f, 0.2f, 2)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.CHIMERA.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CLAW_CHIMERA.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)RuneCraftoryItems.TAIL_CHIMERA.get(), 0.05f, 0.01f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.DEVIL_BLOOD.get(), 0.6f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.RACCOON.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.RACCOON_LEAF.get(), 0.65f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)RuneCraftoryItems.UDON.get(), 0.05f, 0.005f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.CURRY_UDON.get(), 0.02f, 0.005f, 0.2f, 1), new ItemLootData((ItemLike)RuneCraftoryItems.TEMPURA_UDON.get(), 0.02f, 0.005f, 0.2f, 1)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SKELEFANG.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.DRAGON_BONES.get(), 0.4f, 0.05f, 0.2f, 2, true, false), new ItemLootData((ItemLike)RuneCraftoryItems.FISH_FOSSIL.get(), 0.7f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.SKULL.get(), 0.55f, 0.05f, 0.2f, 0)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.RAFFLESIA.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.ROOT.get(), 0.65f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.RAFFLESIA_PETAL.get(), 0.6f, 0.05f, 0.2f, 2, true, false)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.GRIMOIRE.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.FANG_DRAGON.get(), 0.2f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.SCALE_GRIMOIRE.get(), 0.6f, 0.05f, 0.2f, 2, true, false)));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SANO.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.ROCK_SHARD_LEFT.get(), 0.5f, 0.05f, 0.2f, 1, true, false)).withPool(this.create().add(this.addWithCount((ItemLike)Items.STONE, 0.0f, 5.0f, 1.0f))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.UNO.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.ROCK_SHARD_RIGHT.get(), 0.5f, 0.05f, 0.2f, 1, true, false)).withPool(this.create().add(this.addWithCount((ItemLike)Items.STONE, 0.0f, 5.0f, 1.0f))));
            this.registerLootTable((EntityType)RuneCraftoryEntities.SARCOPHAGUS.get(), this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_MAGIC.get(), 0.6f, 0.05f, 0.2f, 0), new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_SKULL.get(), 0.5f, 0.05f, 0.2f, 1, true, false)));
            this.registerGateLoot();
        }

        private void registerGateLoot() {
            for (ItemElement element : ItemElement.values()) {
                this.lootTables.put(GateEntity.getGateLootLocation(element), this.gateLoot(element));
            }
        }

        private LootTable.Builder gateLoot(ItemElement element) {
            return switch (element) {
                case ItemElement.WATER -> this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_WATER.get(), 0.25f, 0.05f, 0.2f, 2));
                case ItemElement.EARTH -> this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_EARTH.get(), 0.25f, 0.05f, 0.2f, 2));
                case ItemElement.WIND -> this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_WIND.get(), 0.25f, 0.05f, 0.2f, 2));
                case ItemElement.FIRE -> this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_FIRE.get(), 0.25f, 0.05f, 0.2f, 2));
                case ItemElement.LIGHT -> this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_LIGHT.get(), 0.1f, 0.05f, 0.2f, 2));
                case ItemElement.DARK -> this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_DARK.get(), 0.1f, 0.05f, 0.2f, 2));
                case ItemElement.LOVE -> this.table(new ItemLootData((ItemLike)RuneCraftoryItems.CRYSTAL_LOVE.get(), 0.05f, 0.05f, 0.2f, 2));
                default -> this.table(new ItemLootData[0]);
            };
        }

        private LootPool.Builder create() {
            return LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        }

        protected void registerLootTable(EntityType<?> type, LootTable.Builder builder) {
            this.lootTables.put((ResourceKey<LootTable>)type.getDefaultLootTable(), builder);
        }

        protected void registerLootTable(EntityType<?> type, LootTable.Builder builder, TamedItemLootData ... datas) {
            this.lootTables.put((ResourceKey<LootTable>)type.getDefaultLootTable(), builder);
            this.tamedDropTable(type, datas);
        }

        private LootTable.Builder table(ItemLootData ... datas) {
            LootTable.Builder builder = new LootTable.Builder();
            for (ItemLootData data : datas) {
                LootPoolSingletonContainer.Builder b = LootItem.lootTableItem((ItemLike)data.item);
                if (data.defaultLooting) {
                    ((LootPoolSingletonContainer.Builder)b.when(LootItemRandomChanceCondition.randomChance((NumberProvider)new LuckBonusNumberProvider((NumberProvider)ConstantValue.exactly((float)data.chance), data.luckBonus)))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)data.lootingBonus)).setLimit(data.max));
                } else {
                    b.apply((LootItemFunction.Builder)new LootingAndLuckLootFunction.Builder((NumberProvider)ConstantValue.exactly((float)data.chance)).withLuckBonus((NumberProvider)ConstantValue.exactly((float)data.luckBonus)).withLootingBonus(this.provider, (NumberProvider)ConstantValue.exactly((float)data.lootingBonus)).limit(data.max));
                }
                if (data.guaranteeFirst) {
                    builder.withPool(this.create().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)data.item).when(() -> FirstKillCondition.INSTANCE)).otherwise((LootPoolEntryContainer.Builder)b)));
                    continue;
                }
                builder.withPool(this.create().add((LootPoolEntryContainer.Builder)b));
            }
            return builder;
        }

        private LootPoolSingletonContainer.Builder<?> guaranteeOnFirstKill(ItemLike item, float min, float max, float lootingCountBonus) {
            return LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)lootingCountBonus)));
        }

        private LootPoolSingletonContainer.Builder<?> addWithCount(ItemLike item, float min, float max, float lootingCountBonus) {
            return LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.provider, (NumberProvider)UniformGenerator.between((float)0.0f, (float)lootingCountBonus)));
        }

        private void tamedDropTable(EntityType<?> entity, TamedItemLootData ... datas) {
            ResourceKey def = entity.getDefaultLootTable();
            this.tamedDropTable((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)def.location().getNamespace(), (String)(def.location().getPath() + "_tamed_drops"))), datas);
        }

        private void tamedDropTable(ResourceKey<LootTable> res, TamedItemLootData ... datas) {
            if (datas.length > 1) {
                AlternativesEntry.Builder builder = AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[0]);
                List<TamedItemLootData> sorted = Arrays.stream(datas).sorted((f, s) -> Integer.compare(s.friendPoints, f.friendPoints)).toList();
                for (TamedItemLootData data : sorted) {
                    LootPoolSingletonContainer.Builder b = (LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)data.item()).when(FriendPointCondition.of(data.friendPoints()));
                    if (data.chance != 1.0f) {
                        b.when(LootItemRandomChanceCondition.randomChance((float)data.chance()));
                    }
                    builder.otherwise((LootPoolEntryContainer.Builder)b);
                }
                this.lootTables.put(res, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)builder)));
            } else if (datas.length == 1) {
                TamedItemLootData data = datas[0];
                LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)data.item()).when(FriendPointCondition.of(data.friendPoints()));
                if (data.chance != 1.0f) {
                    builder.when(LootItemRandomChanceCondition.randomChance((float)data.chance()));
                }
                this.lootTables.put(res, LootTable.lootTable().withPool(LootPool.lootPool().add(builder)));
            }
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
            this.init();
            this.lootTables.forEach(output);
        }

        record ItemLootData(ItemLike item, float chance, float luckBonus, float lootingBonus, int max, boolean guaranteeFirst, boolean defaultLooting) {
            public ItemLootData(ItemLike item, float chance, float lootingBonus, float lootingCountBonus, int lootingCountMax, boolean defaultLooting) {
                this(item, chance, lootingBonus, lootingCountBonus, lootingCountMax, false, defaultLooting);
            }

            public ItemLootData(ItemLike item, float chance, float lootingBonus, float lootingCountBonus, int lootingCountMax) {
                this(item, chance, lootingBonus, lootingCountBonus, lootingCountMax, false);
            }
        }

        record TamedItemLootData(ItemLike item, float chance, int friendPoints) {
        }
    }
}

