/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.neoforge.data.worldgen.structures;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.events.WorldRegistrationCalls;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCProfessions;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryStructures;
import io.github.flemmli97.runecraftory.common.world.structure.processors.NPCDataProcessor;
import io.github.flemmli97.runecraftory.neoforge.data.worldgen.StructureWorldGen;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class TemplatePoolGen {
    public static void bootStrap(BootstrapContext<StructureTemplatePool> ctx) {
        ctx.register(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)RuneCraftory.modRes("npc/bath_house_under")), (Object)new StructureTemplatePool(StructureWorldGen.create(ctx, Registries.TEMPLATE_POOL, RuneCraftory.modRes("npc/bath_house_under")), (List)ImmutableList.of((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/bath_house_under").apply(StructureTemplatePool.Projection.RIGID)), (Object)1))));
        ctx.register(RuneCraftoryStructures.NPC_BIG_HOUSES, (Object)new StructureTemplatePool(TemplatePoolGen.empty(ctx), (List)ImmutableList.of((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/bath_house", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.BATHHOUSE_ATTENDANT.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2), (Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/restaurant", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.CHEF.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2))));
        ctx.register(RuneCraftoryStructures.NPC_HOUSES, (Object)new StructureTemplatePool(TemplatePoolGen.empty(ctx), (List)ImmutableList.of((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/npc_house_generic", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.GENERAL_STORE.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), (Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/npc_house_generic", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.FLORIST.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), (Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/npc_house_smith", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.BLACKSMITH.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), (Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/npc_house_clinic", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.DOCTOR.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)4), (Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/npc_house_single", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.SPELL_MERCHANT.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2), (Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.single((String)"runecraftory:npc/npc_house_single", TemplatePoolGen.npcProcessor((Holder<NPCProfession>)RuneCraftoryNPCProfessions.RUNE_ABILITIES_MERCHANT.asHolder())).apply(StructureTemplatePool.Projection.RIGID)), (Object)2))));
        for (String s : WorldRegistrationCalls.VANILLA_VILLAGES) {
            ctx.register(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)RuneCraftory.modRes("npc/streets/big_street_" + s)), (Object)new StructureTemplatePool(TemplatePoolGen.empty(ctx), (List)ImmutableList.of((Object)Pair.of((Object)((StructurePoolElement)StructurePoolElement.legacy((String)("runecraftory:npc/streets/big_street_" + s), StructureWorldGen.create(ctx, TemplatePoolGen.fromVillage(s))).apply(StructureTemplatePool.Projection.TERRAIN_MATCHING)), (Object)2))));
        }
    }

    private static Holder<StructureTemplatePool> empty(BootstrapContext<?> ctx) {
        return ctx.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
    }

    private static ResourceKey<StructureProcessorList> fromVillage(String villageType) {
        return switch (villageType) {
            case "plains" -> ProcessorLists.STREET_PLAINS;
            case "savanna" -> ProcessorLists.STREET_SAVANNA;
            case "snowy", "taiga" -> ProcessorLists.STREET_SNOWY_OR_TAIGA;
            default -> ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"empty"));
        };
    }

    private static Holder<StructureProcessorList> npcProcessor(Holder<NPCProfession> shop) {
        return Holder.direct((Object)new StructureProcessorList(List.of(new NPCDataProcessor(((ResourceKey)shop.unwrapKey().orElseThrow()).location()))));
    }
}

