/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.CropProperties;
import io.github.flemmli97.runecraftory.common.datapack.manager.CropManager;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public abstract class CropProvider
implements DataProvider {
    private final Map<ResourceLocation, CropProperties.Builder> data = new HashMap<ResourceLocation, CropProperties.Builder>();
    private final Map<ResourceLocation, Consumer<JsonObject>> item = new HashMap<ResourceLocation, Consumer<JsonObject>>();
    private final PackOutput packOutput;
    private final String modid;
    protected final CompletableFuture<HolderLookup.Provider> provider;
    private final Function<Item, ResourceLocation> keyExtractor;

    public CropProvider(PackOutput packOutput, String modid, CompletableFuture<HolderLookup.Provider> provider) {
        this(packOutput, modid, provider, item -> item.builtInRegistryHolder().key().location());
    }

    public CropProvider(PackOutput packOutput, String modid, CompletableFuture<HolderLookup.Provider> provider, Function<Item, ResourceLocation> keyExtractor) {
        this.packOutput = packOutput;
        this.modid = modid;
        this.provider = provider;
        this.keyExtractor = keyExtractor;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            ImmutableList.Builder futures = new ImmutableList.Builder();
            this.data.forEach((arg_0, arg_1) -> this.lambda$run$2((DynamicOps)ops, futures, cache, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futures.build().toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "CropProps for " + this.modid;
    }

    public void addStat(ItemLike item, int growth, int maxDrops, boolean regrowable) {
        this.addStat(item, new CropProperties.Builder(growth, maxDrops, regrowable));
    }

    public void addStat(String id, ItemLike item, int growth, int maxDrops, boolean regrowable) {
        this.addStat(id, item, new CropProperties.Builder(growth, maxDrops, regrowable));
    }

    public void addStat(ItemLike item, CropProperties.Builder builder) {
        this.addStat(this.keyExtractor.apply(item.asItem()).getPath(), item, builder);
    }

    public void addStat(String id, ItemLike item, CropProperties.Builder builder) {
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", this.keyExtractor.apply(item.asItem()).toString()));
    }

    public void addStat(String id, TagKey<Item> tag, int growth, int maxDrops, boolean regrowable) {
        this.addStat(id, tag, new CropProperties.Builder(growth, maxDrops, regrowable));
    }

    public void addStat(String id, TagKey<Item> tag, CropProperties.Builder builder) {
        ResourceLocation res = ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)id);
        this.data.put(res, builder);
        this.item.put(res, obj -> obj.addProperty("item", "#" + String.valueOf(tag.location())));
    }

    private /* synthetic */ void lambda$run$2(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, CropProperties.Builder builder) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + CropManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonElement obj = (JsonElement)CropProperties.CODEC.encodeStart(ops, (Object)builder.build()).getOrThrow();
        if (obj.isJsonObject()) {
            this.item.get(res).accept(obj.getAsJsonObject());
        }
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }
}

