/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.api.datapack.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.api.datapack.ShopItemProperties;
import io.github.flemmli97.runecraftory.api.registry.NPCProfession;
import io.github.flemmli97.runecraftory.common.datapack.manager.ShopItemsManager;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class ShopItemProvider
implements DataProvider {
    private final Map<ResourceLocation, Collection<ShopItemProperties.IntermediaryShopItem>> props = new HashMap<ResourceLocation, Collection<ShopItemProperties.IntermediaryShopItem>>();
    private final Map<ResourceLocation, Boolean> overwrite = new HashMap<ResourceLocation, Boolean>();
    private final PackOutput packOutput;
    protected final String modid;
    protected final CompletableFuture<HolderLookup.Provider> provider;

    public ShopItemProvider(PackOutput packOutput, String modid, CompletableFuture<HolderLookup.Provider> provider) {
        this.packOutput = packOutput;
        this.modid = modid;
        this.provider = provider;
    }

    protected abstract void add(HolderLookup.Provider var1);

    public CompletableFuture<?> run(CachedOutput cache) {
        return ((CompletableFuture)this.provider.thenApply(provider -> {
            this.add((HolderLookup.Provider)provider);
            return provider;
        })).thenCompose(provider -> {
            RegistryOps ops = provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            ImmutableList.Builder futures = new ImmutableList.Builder();
            this.props.forEach((arg_0, arg_1) -> this.lambda$run$2((DynamicOps)ops, futures, cache, arg_0, arg_1));
            return CompletableFuture.allOf((CompletableFuture[])futures.build().toArray(CompletableFuture[]::new));
        });
    }

    public String getName() {
        return "ShopItems for " + this.modid;
    }

    public void addItem(Holder<NPCProfession> shop, ItemLike item) {
        this.addItem(shop, item, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(Holder<NPCProfession> shop, ItemLike item, ShopItemProperties.UnlockType unlockType) {
        this.props.computeIfAbsent(((ResourceKey)shop.unwrapKey().get()).location(), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(ShopItemProperties.MultiItemValue.of(item.asItem()), unlockType, Optional.empty()));
    }

    public void addItem(Holder<NPCProfession> shop, ItemLike item, ShopItemProperties.UnlockType unlockType, EntityPredicate predicate) {
        this.props.computeIfAbsent(((ResourceKey)shop.unwrapKey().get()).location(), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(ShopItemProperties.MultiItemValue.of(item.asItem()), unlockType, Optional.of(predicate)));
    }

    public void addItem(Holder<NPCProfession> shop, ItemStack item) {
        this.addItem(shop, item, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(Holder<NPCProfession> shop, ItemStack item, ShopItemProperties.UnlockType unlockType) {
        this.props.computeIfAbsent(((ResourceKey)shop.unwrapKey().get()).location(), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(List.of(item)), unlockType, Optional.empty()));
    }

    public void addItem(Holder<NPCProfession> shop, ItemStack item, ShopItemProperties.UnlockType unlockType, EntityPredicate predicate) {
        this.props.computeIfAbsent(((ResourceKey)shop.unwrapKey().get()).location(), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(List.of(item)), unlockType, Optional.of(predicate)));
    }

    public void addItem(Holder<NPCProfession> shop, TagKey<Item> tag) {
        this.addItem(shop, tag, ShopItemProperties.UnlockType.NEEDS_SHIPPING);
    }

    public void addItem(Holder<NPCProfession> shop, TagKey<Item> tag, ShopItemProperties.UnlockType unlockType) {
        this.props.computeIfAbsent(((ResourceKey)shop.unwrapKey().get()).location(), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(tag), unlockType, Optional.empty()));
    }

    public void addItem(Holder<NPCProfession> shop, TagKey<Item> tag, ShopItemProperties.UnlockType unlockType, EntityPredicate predicate) {
        this.props.computeIfAbsent(((ResourceKey)shop.unwrapKey().get()).location(), r -> new ArrayList()).add(new ShopItemProperties.IntermediaryShopItem(new ShopItemProperties.MultiItemValue(tag), unlockType, Optional.of(predicate)));
    }

    public void overwrite(Holder<NPCProfession> shop, boolean defaults) {
        ResourceLocation res = ((ResourceKey)shop.unwrapKey().get()).location();
        this.overwrite.put(ResourceLocation.fromNamespaceAndPath((String)res.getNamespace(), (String)(res.getPath() + (defaults ? "_defaults" : ""))), true);
    }

    private /* synthetic */ void lambda$run$2(DynamicOps ops, ImmutableList.Builder futures, CachedOutput cache, ResourceLocation res, Collection builder) {
        Path path = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(res.getNamespace() + "/" + ShopItemsManager.DIRECTORY + "/" + res.getPath() + ".json");
        JsonObject obj = new JsonObject();
        if (this.overwrite.getOrDefault(res, false).booleanValue()) {
            obj.addProperty("replace", Boolean.valueOf(true));
        }
        JsonArray arr = new JsonArray();
        builder.forEach(prop -> arr.add((JsonElement)ShopItemProperties.CODEC.encodeStart(ops, prop).getOrThrow()));
        obj.add("values", (JsonElement)arr);
        futures.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path));
    }
}

