/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class AttackAABBRender {
    private static final float[] ATTACK_RGB = new float[]{0.07058824f, 0.70980394f, 0.2f};
    private static final float[] ATTEMPT_RGB = new float[]{0.07450981f, 0.21960784f, 0.7490196f};
    private static final float[] PLAYER_RGB = new float[]{1.0f, 0.8784314f, 0.8392157f};
    public static final AttackAABBRender INST = new AttackAABBRender();
    private final List<RenderBB> list = new ArrayList<RenderBB>();
    private final List<RenderBB> toAdd = new ArrayList<RenderBB>();

    public void addNewAABB(OrientedBoundingBox obb, int duration, S2CAttackDebug.EnumAABBType type) {
        this.toAdd.add(new RenderBB(obb, duration, type));
    }

    public void render(PoseStack stack, MultiBufferSource.BufferSource buffer) {
        this.list.addAll(this.toAdd);
        this.toAdd.clear();
        this.list.removeIf(r -> r.render(stack, (MultiBufferSource)buffer));
        buffer.endBatch((RenderType)RenderType.LINES);
    }

    private static class RenderBB {
        private final OrientedBoundingBox obb;
        private final S2CAttackDebug.EnumAABBType type;
        private int duration;

        public RenderBB(OrientedBoundingBox obb, int duration, S2CAttackDebug.EnumAABBType type) {
            this.obb = obb;
            this.duration = duration;
            this.type = type;
        }

        public boolean render(PoseStack stack, MultiBufferSource buffer) {
            if (this.type == S2CAttackDebug.EnumAABBType.PLAYER && !Minecraft.getInstance().getEntityRenderDispatcher().shouldRenderHitBoxes()) {
                return true;
            }
            float[] color = switch (this.type) {
                default -> throw new MatchException(null, null);
                case S2CAttackDebug.EnumAABBType.ATTEMPT -> ATTEMPT_RGB;
                case S2CAttackDebug.EnumAABBType.ATTACK -> ATTACK_RGB;
                case S2CAttackDebug.EnumAABBType.PLAYER -> PLAYER_RGB;
            };
            RenderUtils.renderOBB((PoseStack)stack, (MultiBufferSource)buffer, (OrientedBoundingBox)this.obb, (float)color[0], (float)color[1], (float)color[2], (float)1.0f, (boolean)false);
            return this.duration-- < 0;
        }
    }
}

