/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.network.C2SOpenInfo;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemComponentUtils;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class InfoScreen
extends EffectRenderingInventoryScreen<AbstractContainerMenu> {
    public static final ResourceLocation INVENTORY = RuneCraftory.modRes("textures/gui/container/info_inventory.png");
    public static final ResourceLocation SKILLS = RuneCraftory.modRes("textures/gui/container/info_skills.png");
    public static final ResourceLocation HEALTH = RuneCraftory.modRes("widget/health_bar");
    public static final ResourceLocation RUNEPOINTS = RuneCraftory.modRes("widget/runepoints_bar");
    public static final ResourceLocation EXPERIENCE = RuneCraftory.modRes("widget/experience_bar");
    protected final PlayerData data;
    private final Component levelTxt = Component.translatable((String)"runecraftory.gui.level");

    public InfoScreen(AbstractContainerMenu container, Inventory inv, Component name) {
        super(container, inv, name);
        this.imageWidth = 213;
        this.imageHeight = 202;
        this.data = Platform.INSTANCE.getPlayerData(inv.player);
    }

    protected void init() {
        super.init();
        this.buttons();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(this.texture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int iconX = 110;
        int iconY = 64;
        graphics.blitSprite(SpriteResources.ATTACK_ICON, this.leftPos + iconX, this.topPos + iconY, 8, 8);
        graphics.blitSprite(SpriteResources.DEFENCE_ICON, this.leftPos + iconX, this.topPos + iconY + 13, 8, 8);
        graphics.blitSprite(SpriteResources.MAGIC_ATTACK_ICON, this.leftPos + iconX, this.topPos + iconY + 26, 8, 8);
        graphics.blitSprite(SpriteResources.MAGIC_DEFENCE_ICON, this.leftPos + iconX, this.topPos + iconY + 39, 8, 8);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + this.data.getMoney(), (float)(this.leftPos + 194), (float)(this.topPos + 10), 0, false);
        int healthWidth = Math.min(100, (int)((double)(this.data.player().getHealth() / this.data.player().getMaxHealth()) * 100.0));
        int runeWidth = Math.min(100, (int)((float)this.data.getRunePoints() / (float)this.data.getMaxRunePoints() * 100.0f));
        int exp = Math.min(100, (int)(this.data.getPlayerLevel().getProgress() * 100.0f));
        int barX = 104;
        int barWidth = 102;
        GuiUtils.drawBorderedBar(graphics, HEALTH, this.leftPos + barX, this.topPos + 22, barWidth, 11, healthWidth, 1, 1);
        GuiUtils.drawBorderedBar(graphics, RUNEPOINTS, this.leftPos + barX, this.topPos + 36, barWidth, 11, runeWidth, 1, 1);
        GuiUtils.drawBorderedBar(graphics, EXPERIENCE, this.leftPos + barX, this.topPos + 50, barWidth, 11, exp, 1, 1);
        GuiGraphicsExtension.drawCenteredString(graphics, this.font, (int)this.data.player().getHealth() + "/" + (int)this.data.player().getMaxHealth(), (float)(this.leftPos + barX) + (float)(barWidth + 1) * 0.5f, (float)(this.topPos + 24), 0xFFFFFF, false);
        GuiGraphicsExtension.drawCenteredString(graphics, this.font, this.data.getRunePoints() + "/" + this.data.getMaxRunePoints(), (float)(this.leftPos + barX) + (float)(barWidth + 1) * 0.5f, (float)(this.topPos + 38), 0xFFFFFF, false);
        graphics.drawString(this.font, this.levelTxt, this.leftPos + 106, this.topPos + 52, 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + this.data.getPlayerLevel().getLevel(), (float)(this.leftPos + barX + 99), (float)(this.topPos + 52), 0, false);
        float statX = 203.0f;
        float statY = 64.5f;
        MutableComponent mut = Component.literal((String)("" + (int)CombatUtils.getAttributeValue((Entity)this.data.player(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE)));
        if (!ItemComponentUtils.isWeapon(this.data.player().getMainHandItem())) {
            mut.withStyle(ChatFormatting.DARK_RED);
        }
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, (Component)mut, (float)this.leftPos + statX, (float)this.topPos + statY, 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + (int)CombatUtils.getAttributeValue((Entity)this.data.player(), (Holder<Attribute>)RuneCraftoryAttributes.DEFENCE.asHolder()), (float)this.leftPos + statX, (float)this.topPos + statY + 13.0f, 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + (int)CombatUtils.getAttributeValue((Entity)this.data.player(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()), (float)this.leftPos + statX, (float)this.topPos + statY + 26.0f, 0, false);
        GuiGraphicsExtension.drawRightAlignedString(graphics, this.font, "" + (int)CombatUtils.getAttributeValue((Entity)this.data.player(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder()), (float)this.leftPos + statX, (float)this.topPos + statY + 39.0f, 0, false);
        Player entity = this.data.player();
        RenderUtils.renderScaledEntityGui((GuiGraphics)graphics, (float)(this.leftPos + 27), (float)(this.topPos + 9), (float)49.0f, (float)70.0f, (float)30.0f, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)entity);
    }

    protected ResourceLocation texture() {
        return INVENTORY;
    }

    protected void buttons() {
        this.addRenderableWidget((GuiEventListener)new TexturedButton(this.leftPos + 8, this.topPos + 103, 12, 12, (Component)Component.literal((String)"<"), b -> {
            InventoryScreen inventory = new InventoryScreen(this.data.player());
            ItemStack stack = this.data.player().containerMenu.getCarried();
            this.data.player().containerMenu.setCarried(ItemStack.EMPTY);
            this.minecraft.setScreen((Screen)inventory);
            this.data.player().containerMenu.setCarried(stack);
            LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SOpenInfo(C2SOpenInfo.Action.INV));
        }).withSprite(SpriteResources.PAGE_BUTTON));
        this.addRenderableWidget((GuiEventListener)new TexturedButton(this.leftPos + 8 + 13, this.topPos + 103, 12, 12, (Component)Component.literal((String)">"), b -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SOpenInfo(C2SOpenInfo.Action.SUB))).withSprite(SpriteResources.PAGE_BUTTON));
    }
}

