/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.gui;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.client.gui.GuiUtils;
import io.github.flemmli97.runecraftory.client.gui.InfoScreen;
import io.github.flemmli97.runecraftory.client.gui.widgets.SpriteResources;
import io.github.flemmli97.runecraftory.common.network.C2SOpenInfo;
import io.github.flemmli97.runecraftory.mixinhelper.GuiGraphicsExtension;
import io.github.flemmli97.tenshilib.client.gui.widget.TexturedButton;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableEntry;
import io.github.flemmli97.tenshilib.client.gui.widget.list.SelectableListWidget;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class InfoSubScreen
extends InfoScreen {
    public static final ResourceLocation SKILL_ENTRY = RuneCraftory.modRes("widget/skill_entry");
    public static final ResourceLocation SKILL_ENTRY_HIGHLIGHTED = RuneCraftory.modRes("widget/skill_entry_highlighted");
    public static final ResourceLocation SKILL_ENTRY_EXPERIENCE = RuneCraftory.modRes("widget/skill_experience_bar");

    public InfoSubScreen(AbstractContainerMenu container, Inventory inv, Component name) {
        super(container, inv, name);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
    }

    @Override
    protected ResourceLocation texture() {
        return InfoScreen.SKILLS;
    }

    @Override
    protected void buttons() {
        this.addRenderableWidget((GuiEventListener)new TexturedButton(this.leftPos + 8, this.topPos + 103, 12, 12, (Component)Component.literal((String)"<"), b -> LoaderNetwork.INSTANCE.sendToServer((CustomPacketPayload)new C2SOpenInfo(C2SOpenInfo.Action.MAIN))).withSprite(SpriteResources.PAGE_BUTTON));
        this.addRenderableWidget((GuiEventListener)new SelectableListWidget(this.leftPos + 27, this.topPos + 124, 160, 65, this.font, Arrays.stream(Skills.values()).map(x$0 -> new SkillListEntry((Skills)((Object)x$0))).toList()).setEntryHeight(13, 0));
    }

    private class SkillListEntry
    implements SelectableEntry {
        private final Skills skill;

        private SkillListEntry(Skills skill) {
            this.skill = skill;
        }

        public void updateDimensions(int width, int height) {
        }

        public void render(SelectableListWidget widget, GuiGraphics graphics, int mouseX, int mouseY, float partialTick, int x, int y, boolean selected, boolean hovered) {
            graphics.blitSprite(hovered ? SKILL_ENTRY_HIGHLIGHTED : SKILL_ENTRY, x, y, 160, 13);
            graphics.drawString(widget.getFont(), (Component)Component.translatable((String)this.skill.getTranslation()), x + 5, y + 3, 0, false);
            GuiGraphicsExtension.drawRightAlignedString(graphics, widget.getFont(), "" + InfoSubScreen.this.data.getSkillLevel(this.skill).getLevel(), (float)(x + 100), (float)(y + 3), 0, false);
            int progress = Math.min(50, (int)(InfoSubScreen.this.data.getSkillLevel(this.skill).getProgress() * 50.0f));
            GuiUtils.drawBorderedBar(graphics, SKILL_ENTRY_EXPERIENCE, x + 104, y + 2, 52, 9, progress, 1, 1);
        }

        public boolean onClick(double relativeMouseX, double relativeMouseY, boolean selected) {
            return false;
        }
    }
}

