/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.model.monster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.ClientHandlers;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.Thunderbolt;
import io.github.flemmli97.runecraftory.common.entities.utils.MoveType;
import io.github.flemmli97.tenshilib.client.data.GeoAnimationManager;
import io.github.flemmli97.tenshilib.client.data.GeoModelManager;
import io.github.flemmli97.tenshilib.client.data.ReloadableCache;
import io.github.flemmli97.tenshilib.client.model.BedrockAnimations;
import io.github.flemmli97.tenshilib.client.model.ExtendedModel;
import io.github.flemmli97.tenshilib.client.model.ModelPartsContainer;
import io.github.flemmli97.tenshilib.client.model.RideableModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ThunderboltModel<T extends Thunderbolt>
extends EntityModel<T>
implements ExtendedModel,
RideableModel<T> {
    public static final ResourceLocation LOCATION = RuneCraftory.modRes("entity/thunderbolt");
    private final ReloadableCache<ModelPartsContainer> model = GeoModelManager.getInstance().getModel(LOCATION, model -> {
        this.head = model.getPart("head");
        this.neck = model.getPart("neck");
        this.ridingPosition = model.getPart("ridingPos");
    });
    protected final ReloadableCache<BedrockAnimations> anim = GeoAnimationManager.getInstance().getAnimation(LOCATION);
    public ModelPartsContainer.ModelPartExtended head;
    public ModelPartsContainer.ModelPartExtended neck;
    public ModelPartsContainer.ModelPartExtended ridingPosition;

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.getModel().getRoot().render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.getModel().resetPoses();
        this.head.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.15f;
        this.head.xRot += headPitch * ((float)Math.PI / 180) * 0.15f;
        this.neck.yRot += netHeadYaw % 360.0f * ((float)Math.PI / 180) * 0.15f;
        this.neck.xRot += headPitch * ((float)Math.PI / 180) * 0.15f;
        float partialTicks = ClientHandlers.getPartialTicks();
        if (((Thunderbolt)entity).deathTime <= 0 && !((BaseMonster)entity).playDeath() && !((Thunderbolt)entity).getAnimationHandler().isCurrent(new String[]{Thunderbolt.FEINT})) {
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "walk", ((Thunderbolt)entity).tickCount, partialTicks, ((BaseMonster)entity).interpolatedMoveTick(partialTicks));
            ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, "run", ((Thunderbolt)entity).tickCount, partialTicks, ((BaseMonster)entity).interpolatedMoveTickOf(MoveType.RUN, partialTicks));
        }
        ((BedrockAnimations)this.anim.get()).doAnimation((ExtendedModel)this, ((Thunderbolt)entity).getAnimationHandler(), partialTicks);
    }

    public ModelPartsContainer getModel() {
        return (ModelPartsContainer)this.model.get();
    }

    public boolean transform(T entity, EntityRenderer<T> entityRenderer, Entity rider, EntityRenderer<?> ridingEntityRenderer, PoseStack poseStack, int riderNum) {
        this.ridingPosition.translateAndRotateWithParents(poseStack);
        ClientHandlers.translateRider(poseStack, entity, rider);
        return true;
    }
}

