/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.npc;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.client.render.npc.NPCRender;
import io.github.flemmli97.runecraftory.client.render.npc.NPCTextureLayer;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.entities.npc.features.FaceFeaturesType;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryNPCLooks;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;

public class NPCFaceLayer<T extends NPCEntity, M extends HumanoidModel<T>, A extends PlayerModel<T>>
extends NPCTextureLayer<T, M, A> {
    private String textureType;

    public NPCFaceLayer(RenderLayerParent<T, M> renderer, A model, A slimModel) {
        super(renderer, model, slimModel, NPCTextureLayer.LayerType.IRIS_LAYER);
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        Object layerModel = this.getModel(entity);
        this.setup(layerModel);
        this.textureType = null;
        if (((NPCEntity)entity).tickCount % 70 <= 2 || entity.isSleeping() || entity.isDeadOrDying() || ((NPCEntity)entity).playDeath()) {
            this.textureType = "eyes_closed";
        }
        this.layer = NPCTextureLayer.LayerType.IRIS_LAYER;
        this.actualRender(poseStack, buffer, packedLight, entity, layerModel);
        this.layer = NPCTextureLayer.LayerType.SCLERA_LAYER;
        float scale = 1.0f + this.layer.expand;
        poseStack.scale(scale, scale, scale);
        this.actualRender(poseStack, buffer, packedLight, entity, layerModel);
        this.layer = NPCTextureLayer.LayerType.EYEBROWS_LAYER;
        scale = 1.0f + this.layer.expand;
        poseStack.scale(scale, scale, scale);
        this.actualRender(poseStack, buffer, packedLight, entity, layerModel);
    }

    @Override
    protected int setColor(T entity) {
        if (this.textureType != null && (this.layer == NPCTextureLayer.LayerType.IRIS_LAYER || this.layer == NPCTextureLayer.LayerType.SCLERA_LAYER)) {
            boolean skin;
            FaceFeaturesType.FaceFeatures feat = (FaceFeaturesType.FaceFeatures)((NPCEntity)entity).lookFeatures.getFeature((NPCFeatureType)RuneCraftoryNPCLooks.FACE.get());
            boolean bl = skin = this.layer == NPCTextureLayer.LayerType.IRIS_LAYER ? feat.useSkinColor(((NPCEntity)entity).lookFeatures, this.textureType, FaceFeaturesType.ExpressionType.IRIS) : feat.useSkinColor(((NPCEntity)entity).lookFeatures, this.textureType, FaceFeaturesType.ExpressionType.SCLERA);
            if (skin) {
                return NPCFaceLayer.setColor(((NPCEntity)entity).lookFeatures, NPCTextureLayer.LayerType.SKIN_LAYER);
            }
        }
        return NPCFaceLayer.setColor(((NPCEntity)entity).lookFeatures, this.layer);
    }

    @Override
    protected ResourceLocation getTexture(T entity) {
        return NPCRender.getTextureFromLook(entity, this.layer, this.textureType);
    }
}

