/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.client.model.misc.ChestModel;
import io.github.flemmli97.runecraftory.common.entities.misc.MarionettaTrapEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MarionettaTrapRender
extends EntityRenderer<MarionettaTrapEntity> {
    protected static final ResourceLocation COMMON = RuneCraftory.modRes("textures/entity/chest.png");
    private static final float SWORD_OFFSET = 360.0f / (float)MarionettaTrapEntity.SWORDS;
    protected final EntityModel<MarionettaTrapEntity> model;
    private final ItemStack sword = new ItemStack((ItemLike)Items.IRON_SWORD);

    public MarionettaTrapRender(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new ChestModel<MarionettaTrapEntity>();
    }

    public void render(MarionettaTrapEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        stack.pushPose();
        stack.scale(1.25f, 1.25f, 1.25f);
        float yaw = Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot());
        float pitch = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        float partialLivingTicks = (float)entity.tickCount + partialTicks;
        stack.mulPose(Axis.YP.rotationDegrees(180.0f + yaw));
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0, -1.5, 0.0);
        float shaking = entity.shake(partialTicks);
        if (shaking > 0.0f) {
            float pT = Mth.sin((float)(shaking * 15.0f));
            float pT2 = Mth.cos((float)(shaking * 30.0f));
            stack.translate((double)pT * 0.15, 0.0, (double)pT2 * 0.1);
        }
        this.model.prepareMobModel((Entity)entity, 0.0f, 0.0f, partialTicks);
        this.model.setupAnim((Entity)entity, 0.0f, 0.0f, partialLivingTicks, yaw, pitch);
        VertexConsumer ivertexbuilder = buffer.getBuffer(this.model.renderType(this.getTextureLocation(entity)));
        this.model.renderToBuffer(stack, ivertexbuilder, packedLight, OverlayTexture.NO_OVERLAY, -1);
        stack.popPose();
        for (int i = 0; i < MarionettaTrapEntity.SWORDS; ++i) {
            float rotationSword = entity.getSpinProgress(partialTicks) * 480.0f - SWORD_OFFSET * (float)i;
            if (rotationSword <= 0.0f) {
                return;
            }
            entity.playSpawnSound(i);
            this.renderSwords(stack, entity, buffer, rotationSword, entity.getAttackProgress(i, partialTicks));
        }
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    private void renderSwords(PoseStack stack, MarionettaTrapEntity entity, MultiBufferSource buffer, float rotation, float attackProgress) {
        stack.pushPose();
        stack.mulPose(Axis.YP.rotationDegrees(rotation));
        stack.mulPose(Axis.XP.rotationDegrees(-15.0f));
        stack.translate(0.0f, 0.0f, 5.0f - 5.0f * attackProgress);
        stack.mulPose(Axis.XP.rotationDegrees(-12.0f));
        Minecraft.getInstance().getItemRenderer().renderStatic(this.sword, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, 0xF000F0, OverlayTexture.NO_OVERLAY, stack, buffer, entity.level(), entity.getId());
        stack.popPose();
    }

    public ResourceLocation getTextureLocation(MarionettaTrapEntity entity) {
        return COMMON;
    }
}

