/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.client.render.projectiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.misc.RockSpearEntity;
import io.github.flemmli97.tenshilib.client.render.RenderUtils;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class RockSpearRender
extends EntityRenderer<RockSpearEntity> {
    private static final ResourceLocation BIG = RuneCraftory.modRes("textures/entity/projectile/avenger_rock_entity.png");
    private static final ResourceLocation SMALL = RuneCraftory.modRes("textures/entity/projectile/screw_rock_entity.png");
    protected final RenderUtils.TextureBuilder textureBuilder = new RenderUtils.TextureBuilder();

    public RockSpearRender(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(RockSpearEntity entity, float rotation, float partialTicks, PoseStack stack, MultiBufferSource buffer, int packedLight) {
        float size = entity.getRange() + 0.5f;
        float yaw = -(entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks) - 90.0f;
        float pitch = -(entity.xRotO + (entity.getXRot() - entity.xRotO) * partialTicks);
        RenderUtils.applyYawPitch((PoseStack)stack, (float)yaw, (float)pitch);
        this.textureBuilder.setLight(packedLight);
        stack.pushPose();
        boolean playerView = entity.getOwner() == Minecraft.getInstance().player && Minecraft.getInstance().options.getCameraType() != CameraType.THIRD_PERSON_BACK;
        float scale = Mth.lerp((float)partialTicks, (float)((float)entity.tickCount * 0.22222222f), (float)((float)(entity.tickCount + 1) * 0.22222222f));
        stack.scale(Math.min(1.0f, scale), 1.0f, 1.0f);
        stack.translate((double)size * 0.5, 0.0, 0.0);
        if (playerView) {
            stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            float height = (float)((double)(entity.bigRock() ? 2.5f : 1.5f) * Math.sin(Math.sqrt((float)entity.tickCount / (float)entity.livingTickMax()) * Math.PI) + (double)0.2f);
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)height, (RenderUtils.TextureBuilder)this.textureBuilder);
        } else {
            stack.mulPose(Axis.XP.rotationDegrees(45.0f));
            float height = (float)((double)(entity.bigRock() ? 2.5f : 1.5f) * Math.sin(Math.sqrt((float)entity.tickCount / (float)entity.livingTickMax()) * Math.PI) + (double)0.2f);
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)height, (RenderUtils.TextureBuilder)this.textureBuilder);
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
            RenderUtils.renderTexture((PoseStack)stack, (VertexConsumer)buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(entity))), (float)size, (float)height, (RenderUtils.TextureBuilder)this.textureBuilder);
        }
        stack.popPose();
        super.render((Entity)entity, rotation, partialTicks, stack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(RockSpearEntity entity) {
        return entity.bigRock() ? BIG : SMALL;
    }
}

