/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCriteria;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LevelTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player) {
        this.trigger(player, inst -> inst.matches(player));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, int level) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)Codec.INT.fieldOf("level").forGetter(TriggerInstance::level)).apply((Applicative)inst, TriggerInstance::new));

        public static Criterion<TriggerInstance> of(int amount) {
            return ((LevelTrigger)((Object)RuneCraftoryCriteria.LEVEL_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), amount));
        }

        public boolean matches(ServerPlayer player) {
            return Platform.INSTANCE.getPlayerData((Player)player).getPlayerLevel().getLevel() >= this.level;
        }
    }
}

