/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import com.mojang.serialization.MapCodec;
import io.github.flemmli97.runecraftory.common.blocks.CraftingBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.ForgingBlockEntity;
import io.github.flemmli97.tenshilib.common.utils.VoxelUtils;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ForgeBlock
extends CraftingBlock {
    public static final MapCodec<ForgeBlock> CODEC = ForgeBlock.simpleCodec(ForgeBlock::new);
    public static final VoxelShape LEFT = Stream.of(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.box((double)2.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.box((double)4.5, (double)14.0, (double)4.5, (double)11.5, (double)16.0, (double)11.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape[] SHAPES_RIGHT = VoxelUtils.joinedOrDirs((VoxelUtils.ShapeBuilder[])new VoxelUtils.ShapeBuilder[]{VoxelUtils.ShapeBuilder.of((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)5.0, (double)13.0), VoxelUtils.ShapeBuilder.of((double)0.0, (double)5.0, (double)4.0, (double)16.0, (double)6.0, (double)13.0)});

    public ForgeBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public MapCodec<ForgeBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(CraftingBlock.PART) == CraftingBlock.EnumPart.LEFT) {
            return LEFT;
        }
        return SHAPES_RIGHT[((Direction)state.getValue((Property)CraftingBlock.FACING)).get2DDataValue()];
    }

    @Override
    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return new ForgingBlockEntity(pos, state);
    }
}

