/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks;

import io.github.flemmli97.runecraftory.common.blocks.TreeBaseBlock;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeBlockEntity;
import io.github.flemmli97.runecraftory.common.blocks.entity.TreeLogBlockEntity;
import io.github.flemmli97.runecraftory.platform.ExtendedBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class TreeLogBlock
extends RotatedPillarBlock
implements EntityBlock,
ExtendedBlock {
    public static final BooleanProperty IS_TREE_PART = BooleanProperty.create((String)"is_tree_part");

    public TreeLogBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)IS_TREE_PART, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IS_TREE_PART});
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        TreeBlockEntity tree = this.resolveTreeForBreak(state, level, pos, null);
        if (tree != null && tree.isPartOf(pos)) {
            tree.onRemove(level, pos, true);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        TreeBaseBlock block;
        Block block2;
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        TreeBlockEntity tree = this.resolveTreeForBreak(state, level, pos, player);
        if (tree == null || !((block2 = tree.getBlockState().getBlock()) instanceof TreeBaseBlock) || !(block = (TreeBaseBlock)block2).runecraftory$isAtMaxAge(tree.getBlockState())) {
            this.playerWillDestroy(level, pos, state, player);
            return level.setBlock(pos, fluid.createLegacyBlock(), 3);
        }
        if (tree.getHealth() <= 0) {
            tree.onRemove(level, pos, true);
            return true;
        }
        tree.onBreak(10);
        TreeLogBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        serverPlayer.connection.send((Packet)new ClientboundBlockUpdatePacket(pos, state));
        return false;
    }

    protected TreeBlockEntity resolveTreeForBreak(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        TreeBlockEntity tree;
        BlockEntity blockEntity;
        if (player != null && player.isCreative() || !((Boolean)state.getValue((Property)IS_TREE_PART)).booleanValue() || !((blockEntity = level.getBlockEntity(pos)) instanceof TreeLogBlockEntity)) {
            return null;
        }
        TreeLogBlockEntity log = (TreeLogBlockEntity)blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(log.treeBase());
        if (!(blockEntity2 instanceof TreeBlockEntity) || !(tree = (TreeBlockEntity)blockEntity2).isPartOf(log.getBlockPos())) {
            return null;
        }
        return tree;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return (Boolean)state.getValue((Property)IS_TREE_PART) != false ? new TreeLogBlockEntity(pos, state) : null;
    }
}

