/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.common.blocks.BossSpawnerBlock;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.manager.StructureBossManager;
import io.github.flemmli97.runecraftory.common.entities.EnsembleMonsters;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BossSpawnerBlockEntity
extends BlockEntity {
    private int lastUpdateDay = -1;
    private int ticker;
    private ResourceLocation spawnListId;
    private StructureBossManager.BossSpawnList spawnList;
    private EntityType<?> nextSpawn;

    public BossSpawnerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RuneCraftoryBlocks.BOSS_SPAWNER_TILE.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, BossSpawnerBlockEntity blockEntity) {
        ++blockEntity.ticker;
        if (blockEntity.ticker % 5 != 0) {
            return;
        }
        Vec3 pos = Vec3.atCenterOf((Vec3i)blockPos.above(2));
        List<ServerPlayer> nearby = LevelCalc.playersAround((EntityGetter)level, pos, 20.0);
        if (blockEntity.nextSpawn == null) {
            blockEntity.updateEntity();
        }
        if (!nearby.isEmpty() && blockEntity.nextSpawn != null) {
            boolean flag;
            EntityProperties prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(blockEntity.nextSpawn);
            boolean canSpawn = false;
            if (prop.spawnerPredicate().isPresent()) {
                ArrayList<ServerPlayer> removed = new ArrayList<ServerPlayer>();
                for (ServerPlayer player : nearby) {
                    if (!prop.spawnerPredicate().get().matches(player, (Entity)player)) {
                        removed.add(player);
                        if (!player.position().closerThan((Position)pos, 16.0)) continue;
                        Vec3 opposite = player.position().subtract(pos).normalize();
                        player.fallDistance = 0.0f;
                        player.setDeltaMovement(opposite);
                        player.displayClientMessage((Component)Component.translatable((String)"runecraftory.misc.spawner.entry.deny").withStyle(ChatFormatting.DARK_PURPLE), true);
                        player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
                        continue;
                    }
                    if (!player.position().closerThan((Position)pos, 10.0)) continue;
                    canSpawn = true;
                }
                nearby.removeAll(removed);
            } else {
                canSpawn = true;
            }
            boolean bl = flag = blockEntity.lastUpdateDay != WorldUtils.day(level);
            if (canSpawn && flag) {
                blockEntity.spawnEntity(nearby, pos);
            }
        }
    }

    public void spawnEntity(List<ServerPlayer> nearby, Vec3 pos) {
        Entity entity;
        if (this.nextSpawn == null) {
            this.updateEntity();
        }
        if (!this.level.isClientSide && this.nextSpawn != null && (entity = this.nextSpawn.create(this.level)) != null) {
            IBaseMob mob;
            this.lastUpdateDay = WorldUtils.day(this.level);
            if (entity instanceof EnsembleMonsters) {
                EnsembleMonsters ensemble = (EnsembleMonsters)entity;
                if (!ensemble.canSpawnerSpawn((ServerLevel)this.level, this.worldPosition, 32)) {
                    return;
                }
                ensemble.setLevel(LevelCalc.levelFromPos((ServerLevel)this.level, Vec3.atCenterOf((Vec3i)this.worldPosition), nearby));
                ensemble.setRestrictRadius(13);
                switch ((Direction)this.getBlockState().getValue((Property)BossSpawnerBlock.FACING)) {
                    case SOUTH: {
                        ensemble.withDirection(Rotation.CLOCKWISE_180);
                        break;
                    }
                    case WEST: {
                        ensemble.withDirection(Rotation.COUNTERCLOCKWISE_90);
                        break;
                    }
                    case EAST: {
                        ensemble.withDirection(Rotation.CLOCKWISE_90);
                        break;
                    }
                    default: {
                        ensemble.withDirection(Rotation.NONE);
                        break;
                    }
                }
            } else if (!this.noNearby()) {
                return;
            }
            if (entity instanceof IBaseMob) {
                mob = (IBaseMob)entity;
                mob.setXPLevel(LevelCalc.levelFromPos((ServerLevel)this.level, Vec3.atCenterOf((Vec3i)this.worldPosition), nearby));
            }
            entity.moveTo((double)this.worldPosition.getX() + 0.5, (double)(this.worldPosition.getY() + 5), (double)this.worldPosition.getZ() + 0.5, this.level.random.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof Mob) {
                mob = (Mob)entity;
                mob.restrictTo(this.worldPosition, 13);
                mob.finalizeSpawn((ServerLevelAccessor)this.level, this.level.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.SPAWNER, null);
            }
            this.level.addFreshEntity(entity);
            this.updateEntity();
        }
    }

    public void setEntity(EntityType<?> entity) {
        this.nextSpawn = entity;
    }

    private void updateEntity() {
        if (this.spawnList != null) {
            this.spawnList.getRandom(this.level.getRandom()).ifPresent(this::setEntity);
        }
    }

    private boolean noNearby() {
        return this.level.getEntitiesOfClass(Mob.class, new AABB(this.worldPosition).inflate(32.0), e -> e.getType() == this.nextSpawn || this.spawnList != null && this.spawnList.has(e.getType())).isEmpty();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.lastUpdateDay = tag.getInt("LastUpdate");
        if (tag.contains("SpawnListId")) {
            this.spawnListId = ResourceLocation.parse((String)tag.getString("SpawnListId"));
            this.spawnList = DataPackHandler.INSTANCE.structureBossManager().getBoss(this.spawnListId);
        }
        if (tag.contains("Entity")) {
            this.nextSpawn = (EntityType)BuiltInRegistries.ENTITY_TYPE.byNameCodec().parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get("Entity")).getOrThrow();
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("LastUpdate", this.lastUpdateDay);
        if (this.spawnListId != null) {
            tag.putString("SpawnListId", this.spawnListId.toString());
        }
        if (this.nextSpawn != null) {
            tag.put("Entity", (Tag)BuiltInRegistries.ENTITY_TYPE.byNameCodec().encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.nextSpawn).getOrThrow());
        }
    }

    public static CompoundTag creatTagFor(ResourceLocation spawnListId) {
        CompoundTag tag = new CompoundTag();
        tag.putString("SpawnListId", spawnListId.toString());
        tag.putInt("LastUpdate", -1);
        return tag;
    }
}

