/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.blocks.entity;

import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryBlocks;
import io.github.flemmli97.runecraftory.common.world.data.BarnData;
import io.github.flemmli97.runecraftory.common.world.data.RunecraftorySavedData;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class MonsterBarnBlockEntity
extends BlockEntity {
    private static final int MAX_SIZE = 5;
    private UUID owner;
    private int cooldown = 0;
    private BarnData barnData;

    public MonsterBarnBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RuneCraftoryBlocks.MONSTER_BARN_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, MonsterBarnBlockEntity blockEntity) {
        BlockPos pos2;
        if (blockEntity.owner == null || --blockEntity.cooldown > 0 || !(level instanceof ServerLevel)) {
            return;
        }
        if (blockEntity.barnData == null) {
            blockEntity.barnData = RunecraftorySavedData.get(level.getServer()).getOrCreateFor(blockEntity.owner, level, blockPos);
        }
        blockEntity.cooldown = 40;
        int size = 5;
        for (BlockPos pos2 : BlockPos.betweenClosed((int)(blockPos.getX() - size), (int)(blockPos.getY() - 1), (int)(blockPos.getZ() - size), (int)(blockPos.getX() + size), (int)(blockPos.getY() - 1), (int)(blockPos.getZ() + size))) {
            if (Math.abs(pos2.getX() - blockPos.getX()) > size || Math.abs(pos2.getZ() - blockPos.getZ()) > size || MonsterBarnBlockEntity.matches(level, pos2, true) || (size = Math.max(Math.abs(pos2.getX() - blockPos.getX()), Math.abs(pos2.getZ() - blockPos.getZ())) - 1) >= 2) continue;
            blockEntity.barnData.update(0, -1);
            return;
        }
        int airLayers = 10;
        pos2 = new BlockPos.MutableBlockPos();
        block1: for (int y = 0; y < airLayers; ++y) {
            for (int x = blockPos.getX() - size; x < blockPos.getX() + size; ++x) {
                for (int z = blockPos.getZ() - size; z < blockPos.getZ() + size; ++z) {
                    pos2.set(x, blockPos.getY() + y, z);
                    if (pos2.equals((Object)blockPos) || MonsterBarnBlockEntity.matches(level, pos2, false)) continue;
                    airLayers = y;
                    break block1;
                }
            }
        }
        if (airLayers >= 3) {
            boolean hasRoof = true;
            for (BlockPos pos2 : BlockPos.betweenClosed((int)(blockPos.getX() - size), (int)(blockPos.getY() + airLayers), (int)(blockPos.getZ() - size), (int)(blockPos.getX() + size), (int)(blockPos.getY() + airLayers), (int)(blockPos.getZ() + size))) {
                if (level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos2.getX(), pos2.getZ()) > pos2.getY()) continue;
                hasRoof = false;
                break;
            }
            blockEntity.barnData.update(size, hasRoof ? airLayers : -1);
        } else {
            blockEntity.barnData.update(0, -1);
        }
    }

    private static boolean matches(Level level, BlockPos pos, boolean ground) {
        BlockState state = level.getBlockState(pos);
        return ground ? state.is(RunecraftoryTags.Blocks.BARN_GROUND) : !state.is((Block)RuneCraftoryBlocks.MONSTER_BARN.get()) && state.getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    @Nullable
    public BarnData getBarnData() {
        return this.barnData;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID uuid) {
        this.owner = uuid;
        this.setChanged();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.hasUUID("Owner")) {
            this.owner = tag.getUUID("Owner");
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (this.owner != null) {
            tag.putUUID("Owner", this.owner);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (this.owner != null) {
            nbt.putUUID("Owner", this.owner);
        }
        return nbt;
    }
}

