/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.runecraftory.api.attachment.Skills;
import io.github.flemmli97.runecraftory.api.calendar.Weather;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.attachment.player.XpLevelHolder;
import io.github.flemmli97.runecraftory.common.components.StaffData;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.items.weapons.ItemStaffBase;
import io.github.flemmli97.runecraftory.common.network.S2CCapSync;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryCrafting;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryDataComponentTypes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.world.data.Calendar;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.loader.LoaderNetwork;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class RunecraftoryCommand {
    public static void reg(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"runecraftory").then(((LiteralArgumentBuilder)Commands.literal((String)"skill").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"skill", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(Stream.concat(Stream.of(Skills.values()).map(Object::toString), Stream.of("ALL")), (SuggestionsBuilder)builder)).then(((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)"level").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillLevel)))).then(Commands.literal((String)"xp").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addSkillXP))))).then(Commands.literal((String)"set").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setSkillLevel))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"level").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"set").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::setLevel)))).then(Commands.literal((String)"xp").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(RunecraftoryCommand::addLevelXP)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"unlockRecipes").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"all").executes(RunecraftoryCommand::unlockRecipes))).then(Commands.literal((String)"id").then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests(RunecraftoryCommand::allRecipes).executes(RunecraftoryCommand::unlockRecipe)))))).then(((LiteralArgumentBuilder)Commands.literal((String)"recalcStats").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"entities", (ArgumentType)EntityArgument.entities()).executes(RunecraftoryCommand::recalcStats)))).then(((LiteralArgumentBuilder)Commands.literal((String)"weather").requires(src -> src.hasPermission(2))).then(Commands.argument((String)"weather", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> SharedSuggestionProvider.suggest(Stream.of(Weather.values()).map(Object::toString), (SuggestionsBuilder)builder)).executes(RunecraftoryCommand::setWeather)))).then(((LiteralArgumentBuilder)Commands.literal((String)"reset").requires(src -> src.hasPermission(2))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"all").executes(RunecraftoryCommand::resetAll))).then(Commands.literal((String)"recipes").executes(RunecraftoryCommand::resetRecipes))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spell").requires(src -> src.hasPermission(2))).then(Commands.literal((String)"cast").then(((RequiredArgumentBuilder)Commands.argument((String)"spell", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, RuneCraftorySpells.SPELL_REGISTRY_KEY)).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<CommandSourceStack>)ctx, Set.of(((CommandSourceStack)ctx.getSource()).getEntityOrException())))).then(Commands.argument((String)"as", (ArgumentType)EntityArgument.entities()).executes(ctx -> RunecraftoryCommand.castSpell((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"as"))))))).then(Commands.literal((String)"apply").then(Commands.argument((String)"spell", (ArgumentType)ResourceArgument.resource((CommandBuildContext)buildContext, RuneCraftorySpells.SPELL_REGISTRY_KEY)).then(((RequiredArgumentBuilder)Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)1, (int)3)).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<CommandSourceStack>)ctx, Set.of(((CommandSourceStack)ctx.getSource()).getEntityOrException())))).then(Commands.argument((String)"as", (ArgumentType)EntityArgument.entities()).executes(ctx -> RunecraftoryCommand.applySpellTo((CommandContext<CommandSourceStack>)ctx, EntityArgument.getEntities((CommandContext)ctx, (String)"as")))))))));
    }

    private static int addSkillLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                for (Skills skill : Skills.values()) {
                    XpLevelHolder skLvl = data.getSkillLevel(skill);
                    data.setSkillLevel(skill, skLvl.getLevel() + amount, skLvl.getXp(), true);
                }
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.lvl.add", (Object[])new Object[]{s, player.getName(), amount}), false);
                ++ret;
            }
            return ret;
        }
        Skills skill = Skills.read(s);
        if (skill == null) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.no", (Object[])new Object[]{s}), false);
            return 0;
        }
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
            XpLevelHolder skLvl = data.getSkillLevel(skill);
            data.setSkillLevel(skill, skLvl.getLevel() + amount, skLvl.getXp(), true);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.lvl.add", (Object[])new Object[]{s, player.getName(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addSkillXP(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                for (Skills skill : Skills.values()) {
                    data.increaseSkill(skill, amount);
                }
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.lvl.add", (Object[])new Object[]{s, player.getName(), amount}), false);
                ++ret;
            }
            return ret;
        }
        Skills skill = Skills.read(s);
        if (skill == null) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.no", (Object[])new Object[]{s}), false);
            return 0;
        }
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).increaseSkill(skill, amount);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.xp.add", (Object[])new Object[]{s, player.getName(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setSkillLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        String s = StringArgumentType.getString(ctx, (String)"skill");
        if (s.equals("ALL")) {
            for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
                PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
                for (Skills skill : Skills.values()) {
                    data.setSkillLevel(skill, amount, 0.0f, true);
                }
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.lvl.set", (Object[])new Object[]{s, player.getName(), amount}), false);
                ++ret;
            }
            return ret;
        }
        Skills skill = Skills.read(s);
        if (skill == null) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.no", (Object[])new Object[]{s}), false);
            return 0;
        }
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).setSkillLevel(skill, amount, 0.0f, true);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.skill.lvl.set", (Object[])new Object[]{Component.translatable((String)skill.getTranslation()), player.getName(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int addLevelXP(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).addXp(amount);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.lvl.xp.add", (Object[])new Object[]{player.getName(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int setLevel(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        int amount = Math.max(1, IntegerArgumentType.getInteger(ctx, (String)"amount"));
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).setPlayerLevel(amount, 0.0f, true);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.lvl.set", (Object[])new Object[]{player.getName(), amount}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetAll(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
            data.resetAll();
            LoaderNetwork.INSTANCE.sendToPlayer((CustomPacketPayload)new S2CCapSync(data), player);
            QuestHandler.getData(player).resetAll();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.reset.all", (Object[])new Object[]{player.getName()}), false);
            ++ret;
        }
        return ret;
    }

    private static CompletableFuture<Suggestions> allRecipes(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        PlayerData data = Platform.INSTANCE.getPlayerData((Player)((CommandSourceStack)ctx.getSource()).getPlayerOrException());
        if (data != null) {
            for (RecipeHolder r : ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.FORGE.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.id());
            }
            for (RecipeHolder r : ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.CHEMISTRY.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.id());
            }
            for (RecipeHolder r : ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.ARMOR.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.id());
            }
            for (RecipeHolder r : ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.COOKING.get())) {
                if (data.getRecipeKeeper().isUnlocked(r)) continue;
                allRecipes.add(r.id());
            }
        }
        return SharedSuggestionProvider.suggest(allRecipes.stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    }

    private static int unlockRecipe(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ResourceLocation res = ResourceLocationArgument.getId(ctx, (String)"id");
        int ret = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).getRecipeKeeper().unlockRecipesRes((Player)player, List.of(res));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.unlock.recipe", (Object[])new Object[]{player.getName(), res.toString()}), false);
            ++ret;
        }
        return ret;
    }

    private static int unlockRecipes(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        HashSet allRecipes = Sets.newHashSet();
        ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.FORGE.get()).forEach(r -> allRecipes.add(r.id()));
        ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.CHEMISTRY.get()).forEach(r -> allRecipes.add(r.id()));
        ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.ARMOR.get()).forEach(r -> allRecipes.add(r.id()));
        ((CommandSourceStack)ctx.getSource()).getServer().getRecipeManager().getAllRecipesFor((RecipeType)RuneCraftoryCrafting.COOKING.get()).forEach(r -> allRecipes.add(r.id()));
        int ret = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            Platform.INSTANCE.getPlayerData((Player)player).getRecipeKeeper().unlockRecipesRes((Player)player, allRecipes);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.unlock.recipes", (Object[])new Object[]{player.getName()}), false);
            ++ret;
        }
        return ret;
    }

    private static int resetRecipes(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int ret = 0;
        for (ServerPlayer player : EntityArgument.getPlayers(ctx, (String)"player")) {
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
            data.getRecipeKeeper().lockRecipesRes((Player)player, data.getRecipeKeeper().unlockedRecipes());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.reset.recipe", (Object[])new Object[]{player.getName()}), false);
            ++ret;
        }
        return ret;
    }

    private static int setWeather(CommandContext<CommandSourceStack> ctx) {
        Weather weather;
        String s = StringArgumentType.getString(ctx, (String)"weather");
        try {
            weather = Weather.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"runecraftory.command.weather.no", (Object[])new Object[]{s}));
            return 0;
        }
        Calendar.get((Level)((CommandSourceStack)ctx.getSource()).getLevel()).updateWeatherTo(((CommandSourceStack)ctx.getSource()).getLevel(), weather);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.set.weather", (Object[])new Object[]{Component.translatable((String)weather.translation)}), false);
        return 1;
    }

    private static int recalcStats(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection entities = EntityArgument.getEntities(ctx, (String)"entities");
        int i = 0;
        for (Entity e : entities) {
            if (e instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)e;
                Platform.INSTANCE.getPlayerData((Player)player).recalculateStats(false);
                ++i;
                continue;
            }
            if (e instanceof NPCEntity) {
                NPCEntity npc = (NPCEntity)e;
                npc.recalcStatsFull();
                ++i;
                continue;
            }
            if (!(e instanceof BaseMonster)) continue;
            BaseMonster monster = (BaseMonster)e;
            monster.recalcStatsFull();
            ++i;
        }
        int affected = i;
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"runecraftory.command.recalc.stats", (Object[])new Object[]{affected}), false);
        return i;
    }

    private static int castSpell(CommandContext<CommandSourceStack> ctx, Collection<? extends Entity> entities) throws CommandSyntaxException {
        int success = 0;
        Holder.Reference spell = ResourceArgument.getResource(ctx, (String)"spell", (ResourceKey)RuneCraftorySpells.SPELLS.registry().key());
        for (Entity entity : entities) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            ((Spell)spell.value()).use(living);
            ++success;
        }
        return success;
    }

    private static int applySpellTo(CommandContext<CommandSourceStack> ctx, Collection<? extends Entity> entities) throws CommandSyntaxException {
        int success = 0;
        Holder.Reference spell = ResourceArgument.getResource(ctx, (String)"spell", (ResourceKey)RuneCraftorySpells.SPELLS.registry().key());
        int tier = IntegerArgumentType.getInteger(ctx, (String)"tier");
        for (Entity entity : entities) {
            LivingEntity living;
            ItemStack stack;
            if (!(entity instanceof LivingEntity) || !((stack = (living = (LivingEntity)entity).getMainHandItem()).getItem() instanceof ItemStaffBase)) continue;
            StaffData data = (StaffData)stack.getOrDefault((DataComponentType)RuneCraftoryDataComponentTypes.STAFF.get(), (Object)StaffData.DEFAULT);
            DataComponentType dataComponentType = (DataComponentType)RuneCraftoryDataComponentTypes.STAFF.get();
            stack.set(dataComponentType, (Object)(switch (tier) {
                case 3 -> data.setTier3Spell((Holder<Spell>)spell);
                case 2 -> data.setTier2Spell((Holder<Spell>)spell);
                default -> data.setTier1Spell((Holder<Spell>)spell);
            }));
            ++success;
        }
        return success;
    }
}

