/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.effects;

import io.github.flemmli97.runecraftory.common.effects.SyncedMobEffect;
import io.github.flemmli97.runecraftory.common.entities.utils.SleepingEntity;
import io.github.flemmli97.runecraftory.mixinhelper.MobToggleHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class SleepEffect
extends SyncedMobEffect {
    public SleepEffect() {
        super(MobEffectCategory.HARMFUL, 9505582, eff -> ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)0));
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        block6: {
            block5: {
                if (!(living instanceof Player)) break block5;
                Player player = (Player)living;
                if (player.getAbilities().invulnerable) break block6;
            }
            if (!living.noPhysics) {
                living.setDeltaMovement(new Vec3(living.getDeltaMovement().x, -0.08, living.getDeltaMovement().z));
            }
            if (living instanceof MobToggleHandler) {
                MobToggleHandler mob = (MobToggleHandler)living;
                mob.runecraftory$setIgnoreNoAI();
                living.travel(new Vec3(0.0, 0.0, 0.0));
            }
        }
        return super.applyEffectTick(living, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void onEffectAdded(LivingEntity entity, MobEffectInstance instance) {
        if (entity instanceof SleepingEntity) {
            SleepingEntity sleeping = (SleepingEntity)entity;
            sleeping.setSleeping(true);
        }
        entity.setDeltaMovement(Vec3.ZERO);
        Platform.INSTANCE.getEntityData(entity).setSleeping(true);
    }

    public void onEffectRemoved(LivingEntity entity, MobEffectInstance instance) {
        if (entity instanceof SleepingEntity) {
            SleepingEntity sleeping = (SleepingEntity)entity;
            sleeping.setSleeping(false);
        }
        Platform.INSTANCE.getEntityData(entity).setSleeping(false);
    }
}

