/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySounds;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.tenshilib.common.entity.OverlayEntityRender;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class BossMonster
extends BaseMonster
implements OverlayEntityRender {
    public static int DEATH_DURATION = 140;
    protected static final List<Supplier<Holder<Attribute>>> STAT_INCREASE = List.of(() -> Attributes.ATTACK_DAMAGE, () -> RuneCraftoryAttributes.DEFENCE.asHolder(), () -> RuneCraftoryAttributes.MAGIC_ATTACK.asHolder(), () -> RuneCraftoryAttributes.MAGIC_DEFENCE.asHolder());
    protected static final ResourceLocation STAT_INCREASE_ID = RuneCraftory.modRes("boss_enraged_buff");
    private static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.defineId(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected final RunecraftoryBossbar bossInfo = this.createBossBar();
    private int combatTick;
    private int noPlayerRegenTick;
    private int fullHealDelay;
    private ResourceKey<Level> restrictDimension;
    protected int deathRays;

    public BossMonster(EntityType<? extends BossMonster> type, Level level) {
        super(type, level);
    }

    public static <T extends BaseMonster> ImmutableMap<String, BiConsumer<AnimationState, T>> createAnimationHandler(Consumer<ImmutableMap.Builder<String, BiConsumer<AnimationState, T>>> cons) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        cons.accept(builder);
        return (ImmutableMap)builder.build().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.getDisplayName(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ENRAGED, (Object)false);
    }

    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            if (!this.isTamed() && this.isAlive()) {
                this.updatePlayers();
                this.updateBossBar();
                if ((this.getTarget() == null || !this.getTarget().isAlive()) && this.bossInfo.getPlayers().stream().noneMatch(Player::canBeSeenAsEnemy)) {
                    if (++this.combatTick > 200 && ++this.noPlayerRegenTick > 40) {
                        this.heal(this.getMaxHealth() * 0.1f);
                        if (this.getHealth() >= this.getMaxHealth()) {
                            this.fullyHeal();
                        }
                        this.noPlayerRegenTick = 0;
                    }
                    if (this.combatTick > 300 && this.hasRestriction() && !this.isWithinRestriction() && this.restrictDimension != null) {
                        BlockPos restrict = this.getRestrictCenter();
                        if (this.level().dimension() == this.restrictDimension) {
                            TeleportSpell.safeTeleportTo((Entity)this, restrict.getX(), restrict.getY(), restrict.getZ());
                        } else {
                            ServerLevel serverLevel = this.getServer().getLevel(this.restrictDimension);
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((Entity)this, serverLevel, restrict.getX(), restrict.getY(), restrict.getZ());
                            }
                        }
                    }
                } else {
                    this.combatTick = 0;
                    this.noPlayerRegenTick = 0;
                }
            }
            if (--this.fullHealDelay == 1) {
                this.fullyHeal();
            }
        }
        if (this.isAlive()) {
            this.deathTime = 0;
            this.deathRays = 0;
        }
    }

    public void restrictTo(@Nullable BlockPos pos, int distance) {
        super.restrictTo(pos, distance);
        this.restrictDimension = this.level().dimension();
    }

    public void clearRestriction() {
        super.clearRestriction();
        this.restrictDimension = null;
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        return !this.transitionalAnimations() && super.hurt(source, amount);
    }

    @Override
    protected boolean isImmobile() {
        return super.isImmobile() || this.transitionalAnimations();
    }

    protected boolean transitionalAnimations() {
        return this.getSpawnAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSpawnAnimation()}) || this.getDeathAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getDeathAnimation()});
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Enraged", this.isEnraged());
        compound.putInt("FullHealDelay", this.fullHealDelay);
        if (this.restrictDimension != null) {
            compound.putString("RestrictDim", this.restrictDimension.location().toString());
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setEnraged(compound.getBoolean("Enraged"), true);
        this.fullHealDelay = compound.getInt("FullHealDelay");
        if (this.hasCustomName()) {
            this.bossInfo.setName(this.getDisplayName());
        }
        if (compound.contains("RestrictDim")) {
            this.restrictDimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)compound.getString("RestrictDim")));
        }
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        this.bossInfo.setName(this.getDisplayName());
    }

    @Override
    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public void setOwner(Player player) {
        super.setOwner(player);
        if (player != null) {
            this.bossInfo.removeAllPlayers();
        }
    }

    @Override
    protected void tickDeath() {
        super.tickDeath();
        if (!this.level().isClientSide && this.deathTime == 1) {
            this.updateBossBar();
        }
        if (this.level().isClientSide) {
            if (this.deathTime < 50) {
                if (this.deathTime % 10 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((Entity)this, 24.0, 4, 1.0f);
                    this.level().playLocalSound((Entity)this, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 2.0f, 0.8f);
                }
            } else if (this.deathTime < 74) {
                if (this.deathTime % 5 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((Entity)this, 24.0, 4, 1.0f);
                    this.level().playLocalSound((Entity)this, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 2.0f, 0.8f);
                }
            } else if (this.deathTime < 95) {
                if (this.deathTime % 3 == 0) {
                    ++this.deathRays;
                    S2CScreenShake.sendAround((Entity)this, 24.0, 4, 1.0f);
                    this.level().playLocalSound((Entity)this, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 2.0f, 0.8f);
                }
            } else if (this.deathTime < 120 && this.deathTime % 2 == 0) {
                ++this.deathRays;
                S2CScreenShake.sendAround((Entity)this, 24.0, 4, 1.0f);
                this.level().playLocalSound((Entity)this, (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 2.0f, 0.8f);
            }
        }
        if (!this.level().isClientSide && this.deathTime >= this.maxDeathTime()) {
            S2CScreenShake.sendAround((Entity)this, 24.0, 4, 3.0f);
            this.playSound(this.getBossDeathSound(), 2.0f, 1.0f);
        }
    }

    @Override
    public int maxDeathTime() {
        return DEATH_DURATION;
    }

    @Override
    public int deathRays() {
        return this.deathRays;
    }

    @Override
    protected float tamingMultiplier(ItemStack stack) {
        boolean flag = stack.is(this.tamingItem());
        return flag ? 1.0f : 0.0f;
    }

    @Override
    protected void tameEntity(Player owner) {
        super.tameEntity(owner);
        this.setEnraged(false, false);
    }

    public boolean isEnraged() {
        return this.isAlive() && !this.isTamed() && (Boolean)this.entityData.get(ENRAGED) != false;
    }

    public void setEnraged(boolean flag, boolean load) {
        this.entityData.set(ENRAGED, (Object)flag);
        if (!load) {
            if (flag) {
                STAT_INCREASE.forEach(att -> {
                    AttributeInstance inst = this.getAttribute((Holder)att.get());
                    if (inst.getModifier(STAT_INCREASE_ID) == null) {
                        inst.addPermanentModifier(new AttributeModifier(STAT_INCREASE_ID, 0.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                    }
                });
            } else {
                STAT_INCREASE.forEach(att -> this.getAttribute((Holder)att.get()).removeModifier(STAT_INCREASE_ID));
            }
        }
        if (flag && !load && this.isAlive() && this.getAngryAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getAngryAnimation());
        }
    }

    @Override
    public int animationCooldown(String anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 20 + this.getRandom().nextInt(30) : 30 + this.getRandom().nextInt(35)) + diffAdd;
    }

    protected void updateBossBar() {
        this.bossInfo.setProgress(this.getHealth() / this.getMaxHealth());
    }

    @Override
    protected void actuallyHurt(DamageSource source, float damageAmount) {
        super.actuallyHurt(source, damageAmount);
        this.combatTick = 0;
        if (!this.isTamed() && this.checkRage()) {
            this.setEnraged(true, false);
        }
    }

    @Override
    public void onDeathDamageRecord(ServerPlayer player, DamageSource source, float damage) {
        super.onDeathDamageRecord(player, source, damage);
        if (!this.isTamed() && (double)damage > (double)this.getMaxHealth() * 0.05 && (this.deathScore <= 0 || player != this.getKillCredit())) {
            player.awardKillScore((Entity)this, this.deathScore, source);
        }
    }

    protected boolean checkRage() {
        return (double)(this.getHealth() / this.getMaxHealth()) < 0.5 && !this.isEnraged();
    }

    protected void fullyHeal() {
        this.heal(this.getMaxHealth());
        this.setEnraged(false, false);
    }

    private void updatePlayers() {
        HashSet<ServerPlayer> set = new HashSet<ServerPlayer>();
        for (ServerPlayer serverPlayer : this.level().getEntitiesOfClass(ServerPlayer.class, this.arenaAABB(), e -> true)) {
            this.bossInfo.addPlayer(serverPlayer);
            set.add(serverPlayer);
        }
        HashSet set2 = Sets.newHashSet((Iterable)this.bossInfo.getPlayers());
        set2.removeAll(set);
        for (ServerPlayer serverPlayer : set2) {
            this.bossInfo.removePlayerFading(serverPlayer);
        }
    }

    public AABB arenaAABB() {
        if (this.hasRestriction()) {
            return new AABB(this.getRestrictCenter()).inflate((double)(this.getRestrictRadius() + 1.0f));
        }
        return this.getBoundingBox().inflate(Math.max(48.0, this.getAttributeValue(Attributes.FOLLOW_RANGE) + 1.0));
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        for (ServerPlayer player : this.bossInfo.getPlayers()) {
            this.stopSeenByPlayer(player);
        }
    }

    @Override
    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bossInfo.removePlayer(player);
        if (this.isAlive() && !this.isTamed() && player.isRemoved() && this.bossInfo.getPlayers().stream().noneMatch(Player::canBeSeenAsEnemy)) {
            this.fullHealDelay = 10;
        }
    }

    public int overlayU(int orig) {
        return this.isEnraged() ? (int)(Math.sin((float)this.tickCount / 7.0f) * 5.0 + 5.0) : orig;
    }

    public int overlayV(int orig) {
        return this.isEnraged() ? 0 : orig;
    }

    public void playAmbientSound() {
        if (this.getSpawnAnimation() != null && this.getAnimationHandler().isCurrent(new String[]{this.getSpawnAnimation()})) {
            return;
        }
        super.playAmbientSound();
    }

    protected SoundEvent getBossDeathSound() {
        return (SoundEvent)RuneCraftorySounds.ENTITY_BOSS_DEFEAT.get();
    }

    public void playRandomizedSound(SoundEvent event) {
        this.playSound(event, 1.0f, (this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.2f + 0.8f);
    }

    @Override
    public boolean allowAnimation(String prev, String other) {
        if (prev == null) {
            return super.allowAnimation(null, other);
        }
        return !prev.equals(other);
    }

    public String getAngryAnimation() {
        return null;
    }
}

