/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryMemoryTypes;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToAttackTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.MoveToWalkTargetWithSight;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.PlayAnimation;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetAnimationToPlay;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.data.AnimationPlayHolder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimatedEntity;
import io.github.flemmli97.tenshilib.common.registry.TenshilibMemoryModules;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class MonsterBehaviourUtils {
    public static <E extends BaseMonster> Predicate<E> chancedStart(Supplier<Float> floats) {
        return entity -> {
            if (entity.getRandom().nextFloat() < ((Float)floats.get()).floatValue()) {
                return true;
            }
            if (!BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN)) {
                int cooldown = entity.animationCooldown(null);
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)cooldown);
            }
            return false;
        };
    }

    public static <E extends BaseMonster> SetAnimationToPlay<E> checkedAttack(String ... animations) {
        return new SetAnimationToPlay(animations).filter((animation, entity) -> {
            String previous = (String)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()));
            return entity.allowAnimation(previous, (String)animation);
        });
    }

    @SafeVarargs
    public static <E extends BaseMonster> SetAnimationToPlay<E> checkedAttack(AnimationPlayHolder<E> ... animations) {
        return new SetAnimationToPlay(animations).filter((animation, entity) -> {
            String previous = (String)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()));
            return entity.allowAnimation(previous, (String)animation);
        });
    }

    public static <E extends BaseMonster> PlayAnimation<E> cooldownedPlay() {
        return MonsterBehaviourUtils.cooldownedPlay(null);
    }

    public static <E extends BaseMonster> PlayAnimation<E> requireInRangePlay() {
        return MonsterBehaviourUtils.cooldownedPlay(entity -> {
            AnimationPlayHolder anim = (AnimationPlayHolder)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)TenshilibMemoryModules.ANIMATION_TO_PLAY.get()));
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            return target != null && entity.isInAttackBox((Entity)target, anim.animation());
        });
    }

    public static <E extends BaseMonster> PlayAnimation<E> cooldownedPlay(Predicate<E> condition) {
        PlayAnimation behaviour = new PlayAnimation().withCallback(MonsterBehaviourUtils.cooldownHandler()).withCallback(MonsterBehaviourUtils.cooldownHandlerCont());
        if (condition != null) {
            behaviour.startCondition(condition);
        }
        return behaviour;
    }

    public static <E extends BaseMonster> PlayAnimation.OnStart<E> cooldownHandler() {
        return (animation, entity) -> {
            double calc = entity.animationCooldown(animation);
            int cooldown = Mth.ceil((double)(calc += entity.getAnimationHandler().get(animation).length()));
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)cooldown);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()), (Object)animation, (int)(cooldown + 80));
        };
    }

    public static <E extends BaseMonster> PlayAnimation.OnContinue<E> cooldownHandlerCont() {
        return (animation, chains, entity) -> {
            double calc = BrainUtils.getTimeUntilMemoryExpires((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN);
            if (chains != null) {
                for (AnimationPlayHolder.AnimationHolder chain : chains) {
                    calc += entity.getAnimationHandler().get(chain.animation()).length();
                }
                int cooldown = Mth.ceil((double)calc);
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (int)cooldown);
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)RuneCraftoryMemoryTypes.LAST_ANIMATION.get()), (Object)animation, (int)cooldown);
            }
        };
    }

    public static <T extends BaseMonster> Predicate<T> inAABBRange(String animation) {
        return entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            return target != null && entity.isInAttackBox((Entity)target, animation);
        };
    }

    public static <E extends LivingEntity> ToIntBiFunction<E, LivingEntity> closeEnough(int dist) {
        return (entity, target) -> dist;
    }

    public static <E extends Mob> Predicate<E> ifCloserThan(double dist) {
        return entity -> {
            LivingEntity target = entity.getTarget();
            if (target == null) {
                return false;
            }
            double distance = dist + (double)entity.getBbWidth() * 0.5 + (double)target.getBbWidth() * 0.5;
            return entity.distanceToSqr((Entity)target) <= distance * distance;
        };
    }

    public static <E extends Mob> Predicate<E> ifFurtherThan(double dist) {
        return entity -> {
            LivingEntity target = entity.getTarget();
            if (target == null) {
                return false;
            }
            double distance = dist + (double)entity.getBbWidth() * 0.5 + (double)target.getBbWidth() * 0.5;
            return entity.distanceToSqr((Entity)target) >= distance * distance;
        };
    }

    public static <E extends LivingEntity> Consumer<ExtendedBehaviour<E>> withCondition(Predicate<E> test) {
        return behaviour -> {
            behaviour.startCondition(test);
            behaviour.stopIf(e -> !test.test(e));
        };
    }

    public static <E extends PathfinderMob & AnimatedEntity> MoveToAttackTarget<E> timedMovement() {
        return MonsterBehaviourUtils.timedMovement(30, 45);
    }

    public static <E extends PathfinderMob & AnimatedEntity> MoveToAttackTarget<E> timedMovement(int min, int max) {
        MoveToAttackTarget<E> behaviour = MonsterBehaviourUtils.moveAttack();
        behaviour.runFor(e -> min + e.getRandom().nextInt(max - min));
        return behaviour;
    }

    public static <E extends PathfinderMob & AnimatedEntity> MoveToAttackTarget<E> moveAttack() {
        MoveToAttackTarget behaviour = new MoveToAttackTarget();
        behaviour.runFor(e -> 100);
        return behaviour;
    }

    public static <E extends PathfinderMob> MoveToWalkTargetWithSight<E> moveTo() {
        return new MoveToWalkTargetWithSight();
    }

    @SafeVarargs
    public static <T> Predicate<T> and(Predicate<T> ... and) {
        return t -> {
            for (Predicate pred : and) {
                if (pred.test(t)) continue;
                return false;
            }
            return true;
        };
    }
}

