/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.util.BrainUtils;

public class LookAtInteractingPlayer
extends ExtendedBehaviour<NPCEntity> {
    private static final MemoryTest MEMORIES = MemoryTest.builder((int)1).usesMemories(new MemoryModuleType[]{MemoryModuleType.LOOK_TARGET});

    public LookAtInteractingPlayer() {
        this.noTimeout();
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, NPCEntity entity) {
        ServerPlayer player = entity.getLastInteractedPlayer();
        return entity.isAlive() && player != null;
    }

    protected boolean shouldKeepRunning(NPCEntity entity) {
        ServerPlayer player = entity.getLastInteractedPlayer();
        return entity.isAlive() && player != null;
    }

    protected void start(NPCEntity entity) {
        BrainUtils.setMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)entity.getLastInteractedPlayer(), true));
    }

    protected void stop(NPCEntity entity) {
        super.stop((LivingEntity)entity);
        BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET);
    }

    protected void tick(NPCEntity entity) {
        super.tick((LivingEntity)entity);
        BrainUtils.setMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)entity.getLastInteractedPlayer(), true));
        BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.PATH);
        BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET);
    }
}

