/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.ThrowItemAt;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.NPCAttackActions;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SerializableBehaviour;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SetSpellAttack;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.npc.SetWeaponBasedAttack;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCEntity;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.DummyBehaviour;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetAwayFromTarget;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SerializableBehaviours {
    public static final SerializableBehaviour<Unit> IDLE = new SerializableBehaviour<Unit>(MapCodec.unit((Object)Unit.INSTANCE), data -> List.of(new Idle().runFor(e -> 1)));
    public static final SerializableBehaviour<WalkToData> WALK_TO = new SerializableBehaviour<WalkToData>(WalkToData.CODEC, data -> List.of(new SetWalkTargetToAttackTarget().speedMod((e, t) -> Float.valueOf(data.speed())).closeEnoughDist((e, t) -> data.closeEnough()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<WalkAwayData> WALK_AWAY = new SerializableBehaviour<WalkAwayData>(WalkAwayData.CODEC, data -> List.of(new SetWalkTargetAwayFromTarget().speedMod((e, t) -> Float.valueOf(data.speed())).minDist(data.minDistance()).radius((double)data.radius()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<KeepDistanceData> KEEP_DISTANCE = new SerializableBehaviour<KeepDistanceData>(KeepDistanceData.CODEC, data -> List.of(new SetWalkTargetWithinDist().speedMod((e, t) -> Float.valueOf(data.speed())).min((double)data.min()).max((double)data.max()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<RandomWalkData> RANDOM_WALK = new SerializableBehaviour<RandomWalkData>(RandomWalkData.CODEC, data -> List.of(new SetRandomWalkTarget().speedModifier((e, t) -> Float.valueOf(data.speed())).setRadius((double)data.radius()), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<WalkToData> WALK_TO_FOLLOW = new SerializableBehaviour<WalkToData>(WalkToData.CODEC, data -> List.of(new CustomBehaviour(e -> {
        Player target = e.followEntity();
        if (target != null) {
            BrainUtils.setMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true));
            BrainUtils.setMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), data.speed(), data.closeEnough()));
        }
    }), DummyBehaviour.opt(MonsterBehaviourUtils.moveTo())));
    public static final SerializableBehaviour<Unit> LOOK_AT_FOLLOW = new SerializableBehaviour<Unit>(MapCodec.unit((Object)Unit.INSTANCE), data -> List.of(new CustomBehaviour(e -> {
        Player target = e.followEntity();
        if (target != null) {
            BrainUtils.setForgettableMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true), (int)(40 + e.getRandom().nextInt(20)));
        }
    })));
    public static final SerializableBehaviour<Unit> ATTACK_WITH_WEAPON = new SerializableBehaviour<Unit>(MapCodec.unit((Object)Unit.INSTANCE), data -> List.of(new CustomBehaviour(e -> {
        LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)e);
        if (target != null) {
            BrainUtils.setForgettableMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true), (int)(40 + e.getRandom().nextInt(20)));
        }
    }), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetWeaponBasedAttack(), new CustomBehaviour(entity -> {
        LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
        if (target == null || !entity.getSensing().hasLineOfSight((Entity)target) || !entity.isWithinMeleeAttackRange(target)) {
            return;
        }
        entity.swing(InteractionHand.MAIN_HAND);
        entity.doHurtTarget((Entity)target);
    })})));
    public static final SerializableBehaviour<SpellAttackData> ATTACK_WITH_SPELL = new SerializableBehaviour<SpellAttackData>(SpellAttackData.CODEC, new SerializableBehaviour.BehaviourSequenceFactory<SpellAttackData>(){

        @Override
        public List<ExtendedBehaviour<NPCEntity>> create(SpellAttackData data) {
            return List.of(new CustomBehaviour(e -> {
                LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)e);
                if (target != null) {
                    BrainUtils.setForgettableMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true), (int)(40 + e.getRandom().nextInt(20)));
                }
            }), new SetSpellAttack<NPCEntity>(data.spell(), entity -> data.amount().getInt(NPCAttackActions.createLootContext(entity))));
        }

        @Override
        public void addCondition(SpellAttackData data, Consumer<Predicate<NPCEntity>> predicate) {
            if (!data.ignoreSeal()) {
                predicate.accept(npc -> !EntityUtils.sealed((LivingEntity)npc));
            }
        }
    });
    public static final SerializableBehaviour<ItemThrowData> THROW_ITEM = new SerializableBehaviour<ItemThrowData>(ItemThrowData.CODEC, data -> List.of(new CustomBehaviour(e -> {
        LivingEntity target;
        Object object = target = data.throwAtTarget() ? BrainUtils.getTargetOfEntity((LivingEntity)e) : e.followEntity();
        if (target != null) {
            BrainUtils.setForgettableMemory((LivingEntity)e, (MemoryModuleType)MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)target, true), (int)(40 + e.getRandom().nextInt(20)));
        }
    }), new ThrowItemAt(data.stacks())));

    public record ItemThrowData(List<ItemStack> stacks, boolean throwAtTarget) {
        public static final MapCodec<ItemThrowData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)CodecUtils.ITEM_STACK_CODEC.listOf().fieldOf("items").forGetter(ItemThrowData::stacks), (App)Codec.BOOL.fieldOf("throw_at_target").forGetter(ItemThrowData::throwAtTarget)).apply((Applicative)inst, ItemThrowData::new));
    }

    public record WalkToData(float speed, int closeEnough) {
        public static final MapCodec<WalkToData> CODEC = RecordCodecBuilder.mapCodec(data -> data.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(WalkToData::speed), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("close_enough").forGetter(WalkToData::closeEnough)).apply((Applicative)data, WalkToData::new));
    }

    public record RandomWalkData(float speed, int radius) {
        public static final MapCodec<RandomWalkData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(RandomWalkData::speed), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").forGetter(RandomWalkData::radius)).apply((Applicative)inst, RandomWalkData::new));
    }

    public record KeepDistanceData(float speed, float min, float max) {
        public static final MapCodec<KeepDistanceData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(KeepDistanceData::speed), (App)Codec.FLOAT.fieldOf("min").forGetter(KeepDistanceData::min), (App)Codec.FLOAT.fieldOf("max").forGetter(KeepDistanceData::max)).apply((Applicative)inst, KeepDistanceData::new));
    }

    public record WalkAwayData(float speed, float minDistance, int radius) {
        public static final MapCodec<WalkAwayData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.FLOAT.fieldOf("walk_speed").forGetter(WalkAwayData::speed), (App)Codec.FLOAT.fieldOf("min_distance").forGetter(WalkAwayData::minDistance), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("radius").forGetter(WalkAwayData::radius)).apply((Applicative)inst, WalkAwayData::new));
    }

    public record SpellAttackData(Spell spell, boolean ignoreSeal, NumberProvider amount) {
        public static final MapCodec<SpellAttackData> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)RuneCraftorySpells.SPELLS.registry().byNameCodec().fieldOf("spell").forGetter(SpellAttackData::spell), (App)Codec.BOOL.fieldOf("ignore_seal").forGetter(SpellAttackData::ignoreSeal), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(SpellAttackData::amount)).apply((Applicative)inst, SpellAttackData::new));

        public SpellAttackData(Spell spell) {
            this(spell, false, (NumberProvider)ConstantValue.exactly((float)1.0f));
        }
    }
}

