/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public class BigRaccoonLeafEntity
extends BaseProjectile {
    private static final EntityDataAccessor<Boolean> SPIN = SynchedEntityData.defineId(BigRaccoonLeafEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> INITIAL_YAW = SynchedEntityData.defineId(BigRaccoonLeafEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private Vec3 shootDir;
    private Vec3 center;
    private Vec3 axis;
    private float circleRadius;

    public BigRaccoonLeafEntity(EntityType<? extends BaseProjectile> type, Level level) {
        super(type, level);
    }

    public BigRaccoonLeafEntity(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)RuneCraftoryEntities.BIG_RACCOON_LEAF.get()), level, shooter);
        if (shooter.getBbHeight() > 2.0f) {
            this.setPos(this.getX(), shooter.getY() + (double)shooter.getBbHeight() * 0.5, this.getZ());
        }
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        super.shoot(x, y, z, velocity, inaccuracy);
        this.entityData.set(INITIAL_YAW, (Object)Float.valueOf(this.getYRot()));
        this.shootDir = this.getDeltaMovement();
        this.center = this.position().add(this.shootDir);
        this.axis = MathsHelper.getUp(this.getDeltaMovement());
    }

    public void setCenter(float radius) {
        Vec3 dir = this.getShootDir().normalize().scale((double)radius);
        this.center = this.position().add(dir);
        this.axis = MathsHelper.getUp(dir);
        this.circleRadius = radius;
    }

    private Vec3 getShootDir() {
        return this.shootDir == null ? this.getDeltaMovement() : this.shootDir;
    }

    public float radius() {
        return 0.5f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPIN, (Object)false);
        builder.define(INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public int livingTickMax() {
        return 30;
    }

    public void tick() {
        if (!this.level().isClientSide) {
            Vec3 dir = this.position().subtract(this.center).normalize().scale((double)this.circleRadius);
            float angle = (float)(Math.PI * 2 / (double)this.livingTickMax());
            if (!this.spinRight()) {
                angle *= -1.0f;
            }
            if (this.firstTick) {
                angle *= 2.0f;
            }
            Vector3d point = new Vector3d(dir.x, dir.y, dir.z).rotateAxis((double)angle, this.axis.x(), this.axis.y(), this.axis.z());
            Vec3 newPos = this.center.add(point.x(), point.y(), point.z());
            this.setDeltaMovement(newPos.subtract(this.position()));
            this.hasImpulse = true;
        }
        super.tick();
    }

    public void withRightSpin(boolean spin) {
        this.entityData.set(SPIN, (Object)spin);
    }

    public boolean spinRight() {
        return (Boolean)this.entityData.get(SPIN);
    }

    public float initialYaw() {
        return ((Float)this.entityData.get(INITIAL_YAW)).floatValue();
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.getOwner(), result.getEntity(), new DynamicDamage.Builder((Entity)this, this.getOwner()).hurtResistant(2).element(ItemElement.EARTH), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * (double)this.damageMultiplier, null);
        if (att) {
            this.discard();
        }
        return att;
    }

    protected void onBlockHit(BlockHitResult result) {
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ListTag listTag = compound.getList("Axis", 6);
        this.axis = new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
        listTag = compound.getList("Center", 6);
        this.center = new Vec3(listTag.getDouble(0), listTag.getDouble(1), listTag.getDouble(2));
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Axis", (Tag)this.newDoubleList(new double[]{this.axis.x, this.axis.y, this.axis.z}));
        compound.put("Center", (Tag)this.newDoubleList(new double[]{this.center.x, this.center.y, this.center.z}));
    }
}

