/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.registry.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.common.attachment.player.PlayerData;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.items.ItemElement;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryAttributes;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.utils.math.OrientedBoundingBox;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;

public class SwipingWaterLaserEntity
extends BaseBeam {
    private static final EntityDataAccessor<Integer> MAX_LIVING_TICK = SynchedEntityData.defineId(SwipingWaterLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> TOTAL_ROTATION = SynchedEntityData.defineId(SwipingWaterLaserEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final Object2IntMap<Entity> hitEntities = new Object2IntOpenHashMap();

    public SwipingWaterLaserEntity(EntityType<? extends SwipingWaterLaserEntity> type, Level level) {
        super(type, level);
    }

    public SwipingWaterLaserEntity(Level level, LivingEntity shooter, float rotationAngle) {
        super((EntityType<? extends BaseBeam>)((EntityType)RuneCraftoryEntities.SWIPING_WATER_LASER.get()), level, shooter);
        this.entityData.set(TOTAL_ROTATION, (Object)Float.valueOf(rotationAngle));
    }

    public SwipingWaterLaserEntity setMaxTicks(int ticks) {
        this.entityData.set(MAX_LIVING_TICK, (Object)ticks);
        return this;
    }

    public void setRotationToDirWithOffset(double dirX, double dirY, double dirZ, float acc, float yawOffset) {
        super.setRotationToDir(dirX, dirY, dirZ, acc);
        this.setYRot(this.getYRot() + yawOffset);
        this.updateYawPitch();
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MAX_LIVING_TICK, (Object)20);
        builder.define(TOTAL_ROTATION, (Object)Float.valueOf(0.0f));
    }

    public float getRange() {
        return 12.0f;
    }

    public float radius() {
        return 0.4f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return (Integer)this.entityData.get(MAX_LIVING_TICK);
    }

    public void updateHitDetectBox() {
        double dist = this.hitVec != null ? this.hitVec.subtract(this.position()).length() : 0.0;
        double diff = Mth.sin((float)((this.getYRot() - this.yRotO) * ((float)Math.PI / 180))) * this.getRange();
        double width = this.radius() * 2.0f;
        double height = 1.0;
        this.hitObb = new OrientedBoundingBox(new AABB(-width * 0.5 + diff, -width * 0.5, 0.0, width * 0.5, height * 0.5, dist + 0.5), this.getYRot(), -this.getXRot(), this.position());
    }

    public void tick() {
        Entity entity;
        float amount = ((Float)this.entityData.get(TOTAL_ROTATION)).floatValue() / (float)this.livingTickMax();
        if (amount != 0.0f) {
            this.hit = null;
        }
        super.tick();
        if (amount != 0.0f) {
            this.setYRot(Mth.wrapDegrees((float)(this.getYRot() + amount)));
        }
        if ((entity = this.getOwner()) instanceof ServerPlayer) {
            boolean keep;
            ServerPlayer player = (ServerPlayer)entity;
            PlayerData data = Platform.INSTANCE.getPlayerData((Player)player);
            AnimationState action = data.getWeaponHandler().getAnimation();
            boolean bl = keep = action != null && action.is(new String[]{PlayerModelAnimations.WATER_LASER_ONE, PlayerModelAnimations.WATER_LASER_TWO, PlayerModelAnimations.WATER_LASER_THREE});
            if (!keep && this.tickCount < this.livingTickMax() - 5) {
                this.entityData.set(MAX_LIVING_TICK, (Object)(this.tickCount + 5));
            }
        }
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
    }

    public void onImpact(EntityHitResult res) {
        Entity e = res.getEntity();
        CombatUtils.damageWithFaintAndCrit(this.getOwner(), e, new DynamicDamage.Builder((Entity)this, this.getOwner()).hurtResistant(5).magic().noKnockback().element(ItemElement.WATER), CombatUtils.getAttributeValue(this.getOwner(), (Holder<Attribute>)RuneCraftoryAttributes.MAGIC_ATTACK.asHolder()) * (double)this.damageMultiplier, null);
        this.hitEntities.put((Object)e, this.tickCount);
    }

    @Override
    protected boolean check(Entity e, Predicate<AABB> intersects) {
        if (this.tickCount - this.hitEntities.getOrDefault((Object)e, this.tickCount - 20) <= 19) {
            return false;
        }
        return super.check(e, intersects);
    }

    public boolean canStartDamage() {
        return true;
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(MAX_LIVING_TICK, (Object)compound.getInt("MaxTicks"));
        this.entityData.set(TOTAL_ROTATION, (Object)Float.valueOf(compound.getFloat("TotalRotation")));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("MaxTicks", ((Integer)this.entityData.get(MAX_LIVING_TICK)).intValue());
        compound.putFloat("TotalRotation", ((Float)this.entityData.get(TOTAL_ROTATION)).floatValue());
    }
}

