/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.Goblin;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.ThrowHandItemSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.DynamicDamage;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;

public class GoblinGangster
extends Goblin {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder(Goblin.BUILDER, new String[]{SLEEP});
    public static final String DOUBLE_STAB = BUILDER.add("double_stab", AnimationsBuilder.definition((double)0.88).marker("attack", new double[]{0.4, 0.72}));
    public static final String DOUBLE_THROW = BUILDER.add("double_throw", AnimationsBuilder.definition((double)0.96).marker("attack", new double[]{0.4, 0.76}));
    public static final String INTERACT = BUILDER.add("interact", DOUBLE_THROW);
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private final AnimationHandler<GoblinGangster> animationHandler = new AnimationHandler((Entity)this, ANIMS);

    public GoblinGangster(EntityType<? extends Goblin> type, Level level) {
        super(type, level);
    }

    public void quickAttack(Entity target) {
        DynamicDamage.Builder source = new DynamicDamage.Builder((Entity)this).noKnockback().hurtResistant(1);
        CombatUtils.mobAttack((LivingEntity)this, target, source);
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)RuneCraftoryItems.CUTLASS_PROP.get()));
        this.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)RuneCraftoryItems.CUTLASS_PROP.get()));
        this.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{DOUBLE_STAB}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget()}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(6).start(new String[]{DOUBLE_THROW}).play(MonsterBehaviourUtils.cooldownedPlay()).end(3).build();
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.5;
        double length = (double)this.getBbWidth() * 2.15;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{DOUBLE_THROW})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                if (this.getTarget() != null && this.getSensing().hasLineOfSight((Entity)this.getTarget())) {
                    ((ThrowHandItemSpell)RuneCraftorySpells.THROW_HAND_ITEM.get()).use((LivingEntity)this);
                }
                this.stopUsingItem();
            }
        } else if (anim.is(new String[]{DOUBLE_STAB})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.getTarget(), this::quickAttack);
            }
        }
    }

    public AnimationHandler<GoblinGangster> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 1 ? (Spell)RuneCraftorySpells.THROW_HAND_ITEM.get() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(DOUBLE_THROW);
            } else {
                this.getAnimationHandler().setAnimation(DOUBLE_STAB);
            }
        }
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }
}

