/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.behaviour.MonsterBehaviourUtils;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftoryItems;
import io.github.flemmli97.runecraftory.common.registry.RuneCraftorySpells;
import io.github.flemmli97.runecraftory.common.spells.MultiArrowSpell;
import io.github.flemmli97.runecraftory.common.spells.ThrowHandItemSpell;
import io.github.flemmli97.runecraftory.common.spells.WaterLaserSpell;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.AttackBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.SelectableBehaviourBuilder;
import io.github.flemmli97.tenshilib.common.entity.ai.brain.behaviour.SetWalkTargetWithinDist;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationDefinitionContainer;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationState;
import io.github.flemmli97.tenshilib.common.entity.animated.AnimationsBuilder;
import java.util.List;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class Mimic
extends LeapingMonster {
    public static final AnimationsBuilder BUILDER = new AnimationsBuilder();
    public static final String MELEE = BUILDER.add("attack", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String INTERACT = BUILDER.add("interact", MELEE);
    public static final String LEAP = BUILDER.add("leap", AnimationsBuilder.definition((double)0.6).marker("attack_start", new double[]{0.2}).marker("attack_end", new double[]{0.48}));
    public static final String THROW = BUILDER.add("throw", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String ARROW = BUILDER.add("arrow", THROW);
    public static final String CAST = BUILDER.add("cast", AnimationsBuilder.definition((double)0.6).marker("attack", new double[]{0.44}));
    public static final String CLOSE = BUILDER.add("close", AnimationsBuilder.definition((double)0.32));
    public static final AnimationDefinitionContainer ANIMS = BUILDER.build();
    private static final EntityDataAccessor<Boolean> AWAKE = SynchedEntityData.defineId(Mimic.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimationHandler<Mimic> animationHandler = new AnimationHandler((Entity)this, ANIMS);
    private final List<ItemStack> throwables = List.of(new ItemStack((ItemLike)Items.APPLE), new ItemStack((ItemLike)RuneCraftoryItems.BATTLE_AXE.get()), new ItemStack((ItemLike)RuneCraftoryItems.STEEL_SWORD.get()), new ItemStack((ItemLike)RuneCraftoryItems.MUSHROOM.get()));
    private int sleepTick = -1;
    private boolean sleeping;

    public Mimic(EntityType<? extends Mimic> type, Level level) {
        super((EntityType<? extends LeapingMonster>)type, level);
        this.moveControl = new JumpingMover(this);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(AWAKE, (Object)false);
    }

    @Override
    protected void applyAttributes() {
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.5);
        super.applyAttributes();
    }

    @Override
    public List<? extends ExtendedSensor<? extends BaseMonster>> getSensors() {
        return List.of(new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setRadius(5.0).setPredicate((target, entity) -> !entity.isAwake() && entity.targetPred.test(target)).setScanRate(e -> 4), new NearbyLivingEntitySensor().setPredicate((target, entity) -> entity.isAwake() && entity.targetPred.test(target)).setScanRate(e -> 10), new HurtBySensor());
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCombatAI() {
        return AttackBehaviourBuilder.create().start(new String[]{MELEE}).play(MonsterBehaviourUtils.requireInRangePlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget().closeEnoughDist(MonsterBehaviourUtils.closeEnough(1))}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{LEAP}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(7.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(4).start(new String[]{LEAP}).play(MonsterBehaviourUtils.cooldownedPlay()).condition(MonsterBehaviourUtils.ifFurtherThan(5.0)).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(2.0).max(7.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(5).start(new String[]{THROW}).play(MonsterBehaviourUtils.cooldownedPlay()).end(3).start(new String[]{ARROW}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).start(new String[]{CAST}).play(MonsterBehaviourUtils.cooldownedPlay()).prepare(new ExtendedBehaviour[]{new SetWalkTargetWithinDist().min(4.0).max(12.0)}).prepareOptional(new ExtendedBehaviour[]{MonsterBehaviourUtils.moveAttack()}).end(3).build();
    }

    @Override
    public ExtendedBehaviour<? extends BaseMonster> getCooldownAI() {
        return SelectableBehaviourBuilder.builder().add(6, new ExtendedBehaviour[]{new SetWalkTargetToAttackTarget(), MonsterBehaviourUtils.moveTo()}).add(3, MonsterBehaviourUtils.ifCloserThan(7.0), new ExtendedBehaviour[]{new SetRandomWalkTarget(), MonsterBehaviourUtils.moveTo()}).build();
    }

    @Override
    protected ExtendedBehaviour<? extends BaseMonster> getWanderBehaviour() {
        return new Idle();
    }

    @Override
    public boolean hurt(DamageSource source, float amount) {
        boolean ret = super.hurt(source, amount);
        if (ret && !this.sleeping) {
            this.setAwake();
        }
        return ret;
    }

    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide) {
            if (this.getTarget() == null) {
                --this.sleepTick;
            }
            if (this.sleepTick == 0) {
                this.entityData.set(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.getNavigation().stop();
            }
        }
    }

    @Override
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.isTamed() && !this.isAwake()) {
            BrainUtils.setTargetOfEntity((LivingEntity)this, (LivingEntity)player);
            this.playSound(SoundEvents.CHEST_OPEN, this.getSoundVolume() * 0.5f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    @Override
    public AABB attackBB(AnimationState anim) {
        double width = (double)this.getBbWidth() * 1.6;
        double length = (double)this.getBbWidth() * 1.8;
        return new AABB(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.getBbHeight() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimationState anim) {
        if (anim.is(new String[]{THROW})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ItemStack held = this.getMainHandItem();
                this.setItemSlot(EquipmentSlot.MAINHAND, this.throwables.get(this.random.nextInt(this.throwables.size())));
                ((ThrowHandItemSpell)RuneCraftorySpells.THROW_HAND_ITEM.get()).use((LivingEntity)this);
                this.setItemSlot(EquipmentSlot.MAINHAND, held);
            }
        } else if (anim.is(new String[]{CAST})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((WaterLaserSpell)RuneCraftorySpells.WATER_LASER.get()).use((LivingEntity)this);
            }
        } else if (anim.is(new String[]{ARROW})) {
            this.getNavigation().stop();
            if (anim.isAt("attack")) {
                ((MultiArrowSpell)RuneCraftorySpells.DOUBLE_ARROW.get()).use((LivingEntity)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<? extends Mimic> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    protected boolean isLeapingAnim(String anim) {
        return anim.equals(LEAP);
    }

    @Override
    public double leapHeightMotion() {
        return 0.3;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, (Entity)this.getControllingPassenger(), command == 2 ? (Spell)RuneCraftorySpells.THROW_HAND_ITEM.get() : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(THROW);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            this.sleeping = true;
            if (this.isAwake()) {
                this.entityData.set(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.getNavigation().stop();
            }
        } else {
            this.sleeping = false;
        }
    }

    @Override
    public void setTarget(@Nullable LivingEntity livingEntity) {
        super.setTarget(livingEntity);
        if (livingEntity != null && !this.sleeping) {
            this.setAwake();
        }
    }

    public void setAwake() {
        this.entityData.set(AWAKE, (Object)true);
        this.sleepTick = 200;
    }

    public boolean isAwake() {
        return (Boolean)this.entityData.get(AWAKE);
    }

    public boolean canBeCollidedWith() {
        return !this.isAwake();
    }

    protected float getJumpPower() {
        if (this.getTarget() != null) {
            return 0.24f * this.getBlockJumpFactor();
        }
        return 0.36f * this.getBlockJumpFactor();
    }

    public void jumpFromGround() {
        Vec3 vec3 = this.getDeltaMovement();
        this.setDeltaMovement(vec3.x, this.getJumpPower(), vec3.z);
        this.hasImpulse = true;
    }

    private int getJumpDelay() {
        if (this.getTarget() != null) {
            return this.random.nextInt(5) + 4;
        }
        return this.random.nextInt(6) + 8;
    }

    @Override
    public String getInteractAnimation() {
        return INTERACT;
    }

    @Override
    public boolean hasSleepingAnimation() {
        return true;
    }

    protected static class JumpingMover
    extends MoveControl {
        private final Mimic mimic;
        private int jumpDelay;

        public JumpingMover(Mimic mimic) {
            super((Mob)mimic);
            this.mimic = mimic;
        }

        public void tick() {
            this.mob.setYHeadRot(this.mob.getYRot());
            this.mob.setYBodyRot(this.mob.getYRot());
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                this.mob.setZza(0.0f);
                return;
            }
            this.mimic.setAwake();
            this.operation = MoveControl.Operation.WAIT;
            double dX = this.wantedX - this.mob.getX();
            double dZ = this.wantedZ - this.mob.getZ();
            float n = (float)(Mth.atan2((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), n, 90.0f));
            if (this.mob.onGround()) {
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.mimic.getJumpDelay();
                    this.mimic.getJumpControl().jump();
                    this.mimic.playSound(SoundEvents.CHEST_OPEN, this.mimic.getSoundVolume() * 0.5f, 1.0f);
                } else {
                    this.mimic.xxa = 0.0f;
                    this.mimic.zza = 0.0f;
                    this.mob.setSpeed(0.0f);
                }
            } else {
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)));
            }
        }
    }
}

